/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.event.ProjectorEvent;
import flaxbeard.immersivepetroleum.client.IPShaders;
import flaxbeard.immersivepetroleum.client.gui.ProjectorScreen;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPKeyBinds;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.util.IPItemStackHandler;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.projector.MultiblockProjection;
import flaxbeard.immersivepetroleum.common.util.projector.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.glfw.GLFW;

public class ProjectorItem
extends IPItemBase
implements IUpgradeableTool {
    static final Map<Class<? extends MultiblockHandler.IMultiblock>, String> nameCache = new HashMap<Class<? extends MultiblockHandler.IMultiblock>, String>();
    private static final Slot[] NONE = new Slot[0];

    public ProjectorItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(ImmersivePetroleum.creativeTab));
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        Settings settings;
        String selfKey = this.m_5671_(stack);
        if (stack.m_41782_() && (settings = ProjectorItem.getSettings(stack)).getMultiblock() != null) {
            Component name = settings.getMultiblock().getDisplayName();
            return Component.m_237110_((String)(selfKey + ".specific"), (Object[])new Object[]{name}).m_130940_(ChatFormatting.GOLD);
        }
        return Component.m_237115_((String)selfKey).m_130940_(ChatFormatting.GOLD);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        Settings settings = ProjectorItem.getSettings(stack);
        if (settings.getMultiblock() != null) {
            MutableComponent text;
            MutableComponent title;
            Vec3i size = settings.getMultiblock().getSize(worldIn);
            tooltip.add((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.build0"));
            tooltip.add((Component)Component.m_237110_((String)"desc.immersivepetroleum.info.projector.build1", (Object[])new Object[]{settings.getMultiblock().getDisplayName()}));
            if (this.isPressing(340) || this.isPressing(344)) {
                title = Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdshift.text").m_130940_(ChatFormatting.DARK_AQUA);
                tooltip.add((Component)title);
                MutableComponent mbSize = Component.m_237110_((String)"desc.immersivepetroleum.info.projector.size", (Object[])new Object[]{size.m_123341_(), size.m_123342_(), size.m_123343_()}).m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add(this.indent((Component)mbSize));
                Direction dir = Direction.m_122407_((int)settings.getRotation().ordinal());
                MutableComponent rotation = Component.m_237115_((String)("desc.immersivepetroleum.info.projector.rotated." + dir)).m_130940_(ChatFormatting.DARK_GRAY);
                MutableComponent flip = settings.isMirrored() ? Component.m_237115_((String)"desc.immersivepetroleum.info.projector.flipped.true").m_130940_(ChatFormatting.DARK_GRAY) : Component.m_237115_((String)"desc.immersivepetroleum.info.projector.flipped.false").m_130940_(ChatFormatting.DARK_GRAY);
                if (settings.getPos() != null) {
                    int x = settings.getPos().m_123341_();
                    int y = settings.getPos().m_123342_();
                    int z = settings.getPos().m_123343_();
                    MutableComponent centerText = Component.m_237110_((String)"desc.immersivepetroleum.info.projector.center", (Object[])new Object[]{x, y, z}).m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add(this.indent((Component)centerText));
                }
                tooltip.add(this.indent((Component)rotation));
                tooltip.add(this.indent((Component)flip));
            } else {
                text = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdshift")).m_130946_("] ").m_7220_((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdshift.text")).m_130940_(ChatFormatting.DARK_AQUA);
                tooltip.add((Component)text);
            }
            if (this.isPressing(341) || this.isPressing(345)) {
                title = Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdctrl.text").m_130940_(ChatFormatting.DARK_PURPLE);
                MutableComponent ctrl0 = Component.m_237115_((String)"desc.immersivepetroleum.info.projector.control1").m_130940_(ChatFormatting.DARK_GRAY);
                MutableComponent ctrl1 = Component.m_237110_((String)"desc.immersivepetroleum.info.projector.control2", (Object[])new Object[]{IPKeyBinds.keybind_preview_flip.m_90863_()}).m_130940_(ChatFormatting.DARK_GRAY);
                MutableComponent ctrl2 = Component.m_237115_((String)"desc.immersivepetroleum.info.projector.control3").m_130940_(ChatFormatting.DARK_GRAY);
                tooltip.add((Component)title);
                tooltip.add(this.indent((Component)ctrl0));
                tooltip.add(this.indent((Component)ctrl1));
                tooltip.add(this.indent((Component)ctrl2));
            } else {
                text = Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdctrl")).m_130946_("] ").m_7220_((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.holdctrl.text")).m_130940_(ChatFormatting.DARK_PURPLE);
                tooltip.add((Component)text);
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"desc.immersivepetroleum.info.projector.noMultiblock"));
        }
    }

    private Component indent(Component text) {
        return Component.m_237113_((String)"  ").m_7220_(text);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isPressing(int key) {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return GLFW.glfwGetKey((long)window, (int)key) == 1;
    }

    public static String getActualMBName(MultiblockHandler.IMultiblock multiblock) {
        if (!nameCache.containsKey(multiblock.getClass())) {
            String name = multiblock.getClass().getSimpleName();
            name = switch (name = name.substring(0, name.indexOf("Multiblock"))) {
                case "LightningRod" -> "Lightningrod";
                case "ImprovedBlastfurnace" -> "BlastFurnaceAdvanced";
                default -> name;
            };
            nameCache.put(multiblock.getClass(), name);
        }
        return nameCache.get(multiblock.getClass());
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (world.f_46443_) {
            boolean changeMode = false;
            Settings settings = ProjectorItem.getSettings(held);
            switch (settings.getMode()) {
                case PROJECTION: {
                    if (!player.m_6144_()) break;
                    if (settings.getPos() != null) {
                        settings.setPos(null);
                        settings.sendPacketToServer(hand);
                        break;
                    }
                    changeMode = true;
                    break;
                }
                case MULTIBLOCK_SELECTION: {
                    if (!player.m_6144_()) {
                        ProjectorItem.openGUI(hand, held);
                        break;
                    }
                    changeMode = true;
                    break;
                }
            }
            if (changeMode) {
                int modeId = settings.getMode().ordinal() + 1;
                settings.setMode(Settings.Mode.values()[modeId >= Settings.Mode.values().length ? 0 : modeId]);
                settings.applyTo(held);
                settings.sendPacketToServer(hand);
                player.m_5661_(settings.getMode().getTranslated(), true);
            }
        }
        return InteractionResultHolder.m_19090_((Object)held);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openGUI(InteractionHand hand, ItemStack held) {
        MCUtil.setScreen(new ProjectorScreen(hand, held));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player playerIn = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        ItemStack stack = playerIn.m_21120_(hand);
        Settings settings = ProjectorItem.getSettings(stack);
        if (playerIn.m_6144_() && settings.getPos() != null) {
            if (world.f_46443_) {
                settings.setPos(null);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return InteractionResult.SUCCESS;
        }
        if (settings.getMode() == Settings.Mode.PROJECTION && settings.getPos() == null && settings.getMultiblock() != null) {
            BlockState state = world.m_8055_(pos);
            BlockPos.MutableBlockPos hit = pos.m_122032_();
            if (!state.m_60767_().m_76336_() && facing == Direction.UP) {
                hit.m_122154_((Vec3i)hit, 0, 1, 0);
            }
            Vec3i size = settings.getMultiblock().getSize(world);
            ProjectorItem.alignHit(hit, playerIn, size, settings.getRotation(), settings.isMirrored());
            if (playerIn.m_6144_() && playerIn.m_7500_()) {
                if (!world.f_46443_) {
                    if (settings.getMultiblock().getUniqueName().m_135815_().contains("excavator_demo") || settings.getMultiblock().getUniqueName().m_135815_().contains("bucket_wheel")) {
                        hit.m_122154_((Vec3i)hit, 0, -2, 0);
                    }
                    BiPredicate<Integer, MultiblockProjection.Info> pred = (layer, info) -> {
                        BlockState tstate1;
                        BlockState tstate0;
                        BlockPos realPos = info.tPos.m_121955_((Vec3i)hit);
                        ProjectorEvent.PlaceBlock event = new ProjectorEvent.PlaceBlock(info.multiblock, info.templateWorld, info.tBlockInfo.f_74675_, world, realPos, tstate0 = info.getModifiedState(world, realPos), settings.getRotation());
                        if (!MinecraftForge.EVENT_BUS.post((Event)event) && world.m_46597_(realPos, tstate1 = event.getState())) {
                            ProjectorEvent.PlaceBlockPost postEvent = new ProjectorEvent.PlaceBlockPost(info.multiblock, info.templateWorld, event.getTemplatePos(), world, realPos, tstate1, settings.getRotation());
                            MinecraftForge.EVENT_BUS.post((Event)postEvent);
                        }
                        return false;
                    };
                    MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                    projection.setFlip(settings.isMirrored());
                    projection.setRotation(settings.getRotation());
                    projection.processAll(pred);
                }
                return InteractionResult.SUCCESS;
            }
            if (world.f_46443_) {
                settings.setPos((BlockPos)hit);
                settings.applyTo(stack);
                settings.sendPacketToServer(hand);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Settings getSettings(@Nullable ItemStack stack) {
        return new Settings(stack);
    }

    private static void alignHit(BlockPos.MutableBlockPos hit, Player playerIn, Vec3i size, Rotation rotation, boolean mirror) {
        int x = (rotation.ordinal() % 2 == 0 ? size.m_123341_() : size.m_123343_()) / 2;
        int z = (rotation.ordinal() % 2 == 0 ? size.m_123343_() : size.m_123341_()) / 2;
        Direction facing = playerIn.m_6350_();
        boolean xEven = size.m_123341_() % 2 == 0;
        boolean zEven = size.m_123343_() % 2 == 0;
        switch (facing) {
            case NORTH: {
                hit.m_122154_((Vec3i)hit, 0, 0, -z + (zEven ? 1 : 0));
                break;
            }
            case SOUTH: {
                hit.m_122154_((Vec3i)hit, 0, 0, z);
                break;
            }
            case EAST: {
                hit.m_122154_((Vec3i)hit, x, 0, 0);
                break;
            }
            case WEST: {
                hit.m_122154_((Vec3i)hit, -x + (xEven ? 1 : 0), 0, 0);
                break;
            }
        }
    }

    public CompoundTag getUpgrades(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128469_("upgrades") : new CompoundTag();
    }

    public void clearUpgrades(ItemStack stack) {
        ItemUtils.removeTag((ItemStack)stack, (String)"upgrades");
    }

    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    public boolean canModify(ItemStack stack) {
        return true;
    }

    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
    }

    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public void finishUpgradeRecalculation(ItemStack stack) {
    }

    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return NONE;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            final ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)this);
            return new IPItemStackHandler(0){
                private final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(invSize);
                    this.shaders = CapabilityUtils.constantOptional((Object)new CapabilityShader.ShaderWrapper_Item(key, stack));
                }

                @Override
                public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public static enum RenderLayer {
        ALL,
        BAD,
        PERFECT;

    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.side == LogicalSide.CLIENT && event.player != null && event.player == Minecraft.m_91087_().m_91288_() && event.phase == TickEvent.Phase.END && !IPKeyBinds.keybind_preview_flip.m_90862_() && IPKeyBinds.keybind_preview_flip.m_90859_()) {
                ClientInputHandler.doAFlip();
            }
        }

        public static void onSneakScrolling(InputEvent.MouseScrollingEvent event, Player player, double scrollDelta, boolean isSneaking) {
            boolean off;
            ItemStack mainItem = player.m_21205_();
            ItemStack secondItem = player.m_21206_();
            boolean main = mainItem.m_150930_((Item)IPContent.Items.PROJECTOR.get()) && Utils.hasKey(mainItem, "settings", 10);
            boolean bl = off = secondItem.m_150930_((Item)IPContent.Items.PROJECTOR.get()) && Utils.hasKey(secondItem, "settings", 10);
            if (main || off) {
                ItemStack target = main ? mainItem : secondItem;
                Settings settings = ProjectorItem.getSettings(target);
                if (scrollDelta > 0.0) {
                    settings.rotateCCW();
                } else {
                    settings.rotateCW();
                }
                settings.applyTo(target);
                settings.sendPacketToServer(main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                Direction facing = Direction.m_122407_((int)settings.getRotation().ordinal());
                player.m_5661_((Component)Component.m_237115_((String)("desc.immersivepetroleum.info.projector.rotated." + facing)), true);
                event.setCanceled(true);
            }
        }

        private static void doAFlip() {
            ItemStack target;
            LocalPlayer player = MCUtil.getPlayer();
            ItemStack mainItem = player.m_21205_();
            ItemStack secondItem = player.m_21206_();
            boolean main = mainItem.m_150930_((Item)IPContent.Items.PROJECTOR.get()) && Utils.hasKey(mainItem, "settings", 10);
            boolean off = secondItem.m_150930_((Item)IPContent.Items.PROJECTOR.get()) && Utils.hasKey(mainItem, "settings", 10);
            ItemStack itemStack = target = main ? mainItem : secondItem;
            if (main || off) {
                Settings settings = ProjectorItem.getSettings(target);
                settings.flip();
                settings.applyTo(target);
                settings.sendPacketToServer(main ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                MutableComponent flip = settings.isMirrored() ? Component.m_237115_((String)"desc.immersivepetroleum.info.projector.flipped.true") : Component.m_237115_((String)"desc.immersivepetroleum.info.projector.flipped.false");
                player.m_5661_((Component)flip, true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientRenderHandler {
        static final BlockPos.MutableBlockPos FULL_MAX = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        private static final Tesselator PHANTOM_TESSELATOR = new Tesselator();

        @SubscribeEvent
        public static void renderLevelStage(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                ClientRenderHandler.renderProjection(event);
            }
        }

        private static void renderProjection(RenderLevelStageEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                PoseStack matrix = event.getPoseStack();
                matrix.m_85836_();
                Vec3 renderView = MCUtil.getGameRenderer().m_109153_().m_90583_();
                matrix.m_85837_(-renderView.f_82479_, -renderView.f_82480_, -renderView.f_82481_);
                ItemStack secondItem = mc.f_91074_.m_21206_();
                boolean off = secondItem.m_150930_((Item)IPContent.Items.PROJECTOR.get()) && Utils.hasKey(secondItem, "settings", 10);
                for (int i = 0; i <= 10; ++i) {
                    ItemStack stack;
                    ItemStack itemStack = stack = i == 10 ? secondItem : mc.f_91074_.m_150109_().m_8020_(i);
                    if (!stack.m_150930_((Item)IPContent.Items.PROJECTOR.get()) || !Utils.hasKey(stack, "settings", 10)) continue;
                    Settings settings = ProjectorItem.getSettings(stack);
                    matrix.m_85836_();
                    boolean renderMoving = i == mc.f_91074_.m_150109_().f_35977_ || i == 10 && off;
                    ClientRenderHandler.renderSchematic(matrix, settings, (Player)mc.f_91074_, mc.f_91074_.f_19853_, event.getPartialTick(), renderMoving);
                    matrix.m_85849_();
                }
                matrix.m_85849_();
            }
        }

        public static void renderSchematic(PoseStack matrix, Settings settings, Player player, Level world, float partialTicks, boolean renderMoving) {
            if (settings.getMultiblock() == null) {
                return;
            }
            Vec3i size = settings.getMultiblock().getSize(world);
            BlockPos.MutableBlockPos hit = new BlockPos.MutableBlockPos(FULL_MAX.m_123341_(), FULL_MAX.m_123342_(), FULL_MAX.m_123343_());
            MutableBoolean isPlaced = new MutableBoolean(false);
            if (settings.getPos() != null) {
                hit.m_122190_((Vec3i)settings.getPos());
                isPlaced.setTrue();
            } else if (renderMoving && MCUtil.getHitResult() != null && MCUtil.getHitResult().m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockRTResult = (BlockHitResult)MCUtil.getHitResult();
                BlockPos pos = blockRTResult.m_82425_();
                BlockState state = world.m_8055_(pos);
                if (state.m_60767_().m_76336_() || blockRTResult.m_82434_() != Direction.UP) {
                    hit.m_122190_((Vec3i)pos);
                } else {
                    hit.m_122154_((Vec3i)pos, 0, 1, 0);
                }
                ProjectorItem.alignHit(hit, player, size, settings.getRotation(), settings.isMirrored());
            }
            if (!hit.equals((Object)FULL_MAX)) {
                ResourceLocation name = settings.getMultiblock().getUniqueName();
                if (name.m_135815_().contains("excavator_demo") || name.m_135815_().contains("bucket_wheel")) {
                    hit.m_122154_((Vec3i)hit, 0, -2, 0);
                }
                MultiblockProjection projection = new MultiblockProjection(world, settings.getMultiblock());
                projection.setRotation(settings.getRotation());
                projection.setFlip(settings.isMirrored());
                ArrayList toRender = new ArrayList();
                MutableInt currentLayer = new MutableInt();
                MutableInt badBlocks = new MutableInt();
                MutableInt goodBlocks = new MutableInt();
                BiPredicate<Integer, MultiblockProjection.Info> bipred = (layer, info) -> {
                    if (badBlocks.getValue() == 0 && layer > currentLayer.getValue()) {
                        currentLayer.setValue((Number)layer);
                    } else if (!Objects.equals(layer, currentLayer.getValue())) {
                        return true;
                    }
                    if (isPlaced.booleanValue() && Objects.equals(layer, currentLayer.getValue())) {
                        BlockPos realPos = info.tPos.m_121955_((Vec3i)hit);
                        BlockState toCompare = world.m_8055_(realPos);
                        BlockState tState = info.getModifiedState(world, realPos);
                        boolean skip = false;
                        if (tState == toCompare) {
                            toRender.add(Pair.of((Object)((Object)RenderLayer.PERFECT), (Object)info));
                            goodBlocks.increment();
                            skip = true;
                        } else if (!toCompare.m_60795_()) {
                            toRender.add(Pair.of((Object)((Object)RenderLayer.BAD), (Object)info));
                            skip = true;
                        } else {
                            badBlocks.increment();
                        }
                        if (skip) {
                            return false;
                        }
                    }
                    toRender.add(Pair.of((Object)((Object)RenderLayer.ALL), (Object)info));
                    return false;
                };
                projection.processAll(bipred);
                boolean perfect = goodBlocks.getValue().intValue() == projection.getBlockCount();
                BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
                BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                float flicker = world.f_46441_.m_188501_() / 2.0f + 0.25f;
                matrix.m_85837_((double)hit.m_123341_(), (double)hit.m_123342_(), (double)hit.m_123343_());
                toRender.sort((a, b) -> {
                    int bo;
                    int ao = ((RenderLayer)((Object)((Object)a.getLeft()))).ordinal();
                    if (ao > (bo = ((RenderLayer)((Object)((Object)b.getLeft()))).ordinal())) {
                        return 1;
                    }
                    if (ao < bo) {
                        return -1;
                    }
                    return 0;
                });
                MultiBufferSource.BufferSource mainBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                ItemStack heldStack = player.m_21205_();
                for (Pair pair : toRender) {
                    MultiblockProjection.Info rInfo = (MultiblockProjection.Info)pair.getRight();
                    switch ((RenderLayer)((Object)pair.getLeft())) {
                        case ALL: {
                            boolean held = heldStack.m_41720_() == rInfo.getRawState().m_60734_().m_5456_();
                            float alpha = held ? 1.0f : 0.5f;
                            matrix.m_85836_();
                            ClientRenderHandler.renderPhantom(matrix, world, rInfo, settings.isMirrored(), flicker, alpha, partialTicks);
                            if (held) {
                                ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xAFAFAF, flicker);
                            }
                            matrix.m_85849_();
                            break;
                        }
                        case BAD: {
                            matrix.m_85836_();
                            matrix.m_85837_((double)rInfo.tPos.m_123341_(), (double)rInfo.tPos.m_123342_(), (double)rInfo.tPos.m_123343_());
                            ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xFF0000, flicker);
                            matrix.m_85849_();
                            break;
                        }
                        case PERFECT: {
                            int x = rInfo.tPos.m_123341_();
                            int y = rInfo.tPos.m_123342_();
                            int z = rInfo.tPos.m_123343_();
                            min.m_122178_(Math.min(x, min.m_123341_()), Math.min(y, min.m_123342_()), Math.min(z, min.m_123343_()));
                            max.m_122178_(Math.max(x, max.m_123341_()), Math.max(y, max.m_123342_()), Math.max(z, max.m_123343_()));
                        }
                    }
                }
                if (perfect) {
                    matrix.m_85836_();
                    ClientRenderHandler.renderOutlineBox((MultiBufferSource)mainBuffer, matrix, (Vec3i)min, (Vec3i)max, 48896, flicker);
                    matrix.m_85849_();
                    if (!player.m_21206_().m_41619_() && player.m_21206_().m_41720_() == IPContent.DEBUGITEM.get()) {
                        matrix.m_85836_();
                        matrix.m_85837_((double)min.m_123341_(), (double)min.m_123342_(), (double)min.m_123343_());
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 0xFF0000, flicker);
                        matrix.m_85849_();
                        matrix.m_85836_();
                        matrix.m_85837_((double)max.m_123341_(), (double)max.m_123342_(), (double)max.m_123343_());
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 65280, flicker);
                        matrix.m_85849_();
                        matrix.m_85836_();
                        BlockPos center = min.m_7949_().m_121955_((Vec3i)max);
                        matrix.m_85837_((double)(center.m_123341_() / 2), (double)(center.m_123342_() / 2), (double)(center.m_123343_() / 2));
                        ClientRenderHandler.renderCenteredOutlineBox((MultiBufferSource)mainBuffer, matrix, 255, flicker);
                        matrix.m_85849_();
                    }
                }
                mainBuffer.m_109911_();
            }
        }

        private static void renderPhantom(PoseStack matrix, Level realWorld, MultiblockProjection.Info rInfo, boolean mirror, float flicker, float alpha, float partialTicks) {
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            ModelBlockRenderer blockRenderer = dispatcher.m_110937_();
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            matrix.m_85837_((double)rInfo.tPos.m_123341_(), (double)rInfo.tPos.m_123342_(), (double)rInfo.tPos.m_123343_());
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)PHANTOM_TESSELATOR.m_85915_());
            BlockState state = rInfo.getModifiedState(realWorld, rInfo.tPos);
            ProjectorEvent.RenderBlock renderEvent = new ProjectorEvent.RenderBlock(rInfo.multiblock, rInfo.templateWorld, rInfo.tBlockInfo.f_74675_, realWorld, rInfo.tPos, state, rInfo.settings.m_74404_());
            if (!MinecraftForge.EVENT_BUS.post((Event)renderEvent)) {
                state = renderEvent.getState();
                state.m_60701_((LevelAccessor)realWorld, rInfo.tPos, 3);
                ModelData modelData = ModelData.EMPTY;
                BlockEntity te = rInfo.templateWorld.m_7702_(rInfo.tBlockInfo.f_74675_);
                if (te != null) {
                    te.f_58856_ = state;
                    modelData = te.getModelData();
                }
                RenderShape blockrendertype = state.m_60799_();
                switch (blockrendertype) {
                    case MODEL: {
                        BakedModel ibakedmodel = dispatcher.m_110910_(state);
                        int i = blockColors.m_92577_(state, null, null, 0);
                        float red = (float)(i >> 16 & 0xFF) / 255.0f;
                        float green = (float)(i >> 8 & 0xFF) / 255.0f;
                        float blue = (float)(i & 0xFF) / 255.0f;
                        modelData = ibakedmodel.getModelData((BlockAndTintGetter)rInfo.templateWorld, rInfo.tBlockInfo.f_74675_, state, modelData);
                        IPShaders.projNoise(flicker * alpha, (float)MCUtil.getPlayer().f_19797_ + partialTicks);
                        VertexConsumer vc = buffer.m_6299_(IPRenderTypes.PROJECTION);
                        blockRenderer.renderModel(matrix.m_85850_(), vc, state, ibakedmodel, red, green, blue, 0xF000F0, OverlayTexture.f_118083_, modelData, null);
                        break;
                    }
                    case ENTITYBLOCK_ANIMATED: {
                        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                        MCUtil.getItemRenderer().m_174269_(stack, ItemTransforms.TransformType.NONE, 0xF000F0, OverlayTexture.f_118083_, matrix, (MultiBufferSource)buffer, 0);
                        break;
                    }
                }
            }
            buffer.m_109911_();
        }

        private static void renderOutlineBox(MultiBufferSource buffer, PoseStack matrix, Vec3i min, Vec3i max, int rgb, float flicker) {
            ClientRenderHandler.renderBox(buffer, matrix, Vec3.m_82528_((Vec3i)min), Vec3.m_82528_((Vec3i)max).m_82520_(1.0, 1.0, 1.0), rgb, flicker);
        }

        private static void renderBox(MultiBufferSource buffer, PoseStack matrix, Vec3 min, Vec3 max, int rgb, float flicker) {
            VertexConsumer builder = buffer.m_6299_(IPRenderTypes.TRANSLUCENT_LINE);
            float alpha = 0.25f + 0.5f * flicker;
            int rgba = rgb | (int)(alpha * 255.0f) << 24;
            ClientRenderHandler.line(builder, matrix, min, max, 2, 6, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 6, 7, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 7, 3, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 3, 2, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 2, 0, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 6, 4, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 3, 1, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 7, 5, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 0, 4, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 4, 5, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 5, 1, rgba);
            ClientRenderHandler.line(builder, matrix, min, max, 1, 0, rgba);
        }

        private static void renderCenteredOutlineBox(MultiBufferSource buffer, PoseStack matrix, int rgb, float flicker) {
            ClientRenderHandler.renderBox(buffer, matrix, Vec3.f_82478_, new Vec3(1.0, 1.0, 1.0), rgb, flicker);
        }

        private static Vector3f combine(Vec3 start, Vec3 end, int mixBits) {
            float eps = 0.01f;
            return new Vector3f((float)((mixBits & 4) != 0 ? end.f_82479_ + (double)0.01f : start.f_82479_ - (double)0.01f), (float)((mixBits & 2) != 0 ? end.f_82480_ + (double)0.01f : start.f_82480_ - (double)0.01f), (float)((mixBits & 1) != 0 ? end.f_82481_ + (double)0.01f : start.f_82481_ - (double)0.01f));
        }

        private static void line(VertexConsumer out, PoseStack mat, Vec3 min, Vec3 max, int startBits, int endBits, int rgba) {
            Vector3f start = ClientRenderHandler.combine(min, max, startBits);
            Vector3f end = ClientRenderHandler.combine(min, max, endBits);
            Vector3f delta = end.m_122281_();
            delta.m_122267_(start);
            out.m_85982_(mat.m_85850_().m_85861_(), start.m_122239_(), start.m_122260_(), start.m_122269_()).m_193479_(rgba).m_85977_(mat.m_85850_().m_85864_(), delta.m_122239_(), delta.m_122260_(), delta.m_122269_()).m_5752_();
            out.m_85982_(mat.m_85850_().m_85861_(), end.m_122239_(), end.m_122260_(), end.m_122269_()).m_193479_(rgba).m_85977_(mat.m_85850_().m_85864_(), delta.m_122239_(), delta.m_122260_(), delta.m_122269_()).m_5752_();
        }
    }
}

