/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.fluids;

import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPRegisters;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class IPFluid
extends FlowingFluid {
    public static final List<IPFluidEntry> FLUIDS = new ArrayList<IPFluidEntry>();
    private static IPFluidEntry staticEntry;
    protected final IPFluidEntry entry;

    public static IPFluidEntry makeFluid(String name, int density, int viscosity) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014);
    }

    public static <B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, blockFactory);
    }

    public static <S extends IPFluid> IPFluidEntry makeFluid(String name, int density, int viscosity, Function<IPFluidEntry, S> sourceFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, sourceFactory);
    }

    public static <S extends IPFluid, B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, Function<IPFluidEntry, S> sourceFactory, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        return IPFluid.makeFluid(name, density, viscosity, 0.014, sourceFactory, blockFactory);
    }

    public static IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale) {
        IPFluidEntry entry = IPFluidEntry.make(name, IPFluid::new, Flowing::new, IPFluidBlock::new, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, IPFluid::new, Flowing::new, blockFactory, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <S extends IPFluid> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, Function<IPFluidEntry, S> sourceFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, sourceFactory, Flowing::new, IPFluidBlock::new, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    public static <S extends IPFluid, B extends IPFluidBlock> IPFluidEntry makeFluid(String name, int density, int viscosity, double motionScale, Function<IPFluidEntry, S> sourceFactory, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> blockFactory) {
        IPFluidEntry entry = IPFluidEntry.make(name, sourceFactory, Flowing::new, blockFactory, IPFluid.builder(density, viscosity, motionScale));
        return entry;
    }

    protected static Material createMaterial(MaterialColor color) {
        return new Material(color, true, false, false, false, false, true, PushReaction.DESTROY);
    }

    private static IPFluid makeFluid(Function<IPFluidEntry, ? extends IPFluid> make, IPFluidEntry entry) {
        staticEntry = entry;
        IPFluid ret = make.apply(entry);
        staticEntry = null;
        return ret;
    }

    protected IPFluid(IPFluidEntry entry) {
        this.entry = entry;
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
        for (Property<?> p : (this.entry == null ? staticEntry : this.entry).properties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    protected void m_7456_(@Nonnull LevelAccessor arg0, @Nonnull BlockPos arg1, @Nonnull BlockState arg2) {
    }

    protected boolean m_6760_() {
        return false;
    }

    public boolean hasCustomSlowdown() {
        return false;
    }

    public double getEntitySlowdown() {
        return 0.8;
    }

    @Nonnull
    public Fluid m_5615_() {
        return (Fluid)this.entry.flowing.get();
    }

    @Nonnull
    public Fluid m_5613_() {
        return (Fluid)this.entry.source.get();
    }

    @Nonnull
    public Item m_6859_() {
        return (Item)this.entry.bucket.get();
    }

    public FluidType getFluidType() {
        return (FluidType)this.entry.type.get();
    }

    protected int m_6713_(@Nonnull LevelReader arg0) {
        return 1;
    }

    protected int m_6719_(@Nonnull LevelReader arg0) {
        return 4;
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    public int m_6718_(@Nonnull LevelReader p_205569_1_) {
        return 5;
    }

    protected float m_6752_() {
        return 100.0f;
    }

    @Nonnull
    protected BlockState m_5804_(@Nonnull FluidState state) {
        return (BlockState)((IPFluidBlock)((Object)this.entry.block.get())).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(IPFluid.m_76092_((FluidState)state)));
    }

    public boolean m_7444_(FluidState state) {
        return state.m_192917_(this.m_5613_());
    }

    public int m_7430_(@Nonnull FluidState state) {
        return this.m_7444_(state) ? 8 : (Integer)state.m_61143_((Property)f_75948_);
    }

    public boolean m_6212_(Fluid fluidIn) {
        return fluidIn == this.m_5613_() || fluidIn == this.m_5615_();
    }

    private static Consumer<FluidType.Properties> builder(int density, int viscosity, double motionScale) {
        return builder -> builder.viscosity(viscosity).density(density).motionScale(motionScale);
    }

    public record IPFluidEntry(RegistryObject<IPFluid> source, RegistryObject<IPFluid> flowing, RegistryObject<IPFluidBlock> block, RegistryObject<BucketItem> bucket, RegistryObject<FluidType> type, List<Property<?>> properties) {
        public Fluid get() {
            return (Fluid)this.source().get();
        }

        public void setEffect(MobEffect effect, int duration, int level) {
            ((IPFluidBlock)((Object)this.block().get())).setEffect(effect, duration, level);
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes) {
            return IPFluidEntry.make(name, 0, makeSource, makeFlowing, makeBlock, buildAttributes, ImmutableList.of());
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            return IPFluidEntry.make(name, 0, makeSource, makeFlowing, makeBlock, buildAttributes, properties);
        }

        protected static <S extends IPFluid, F extends IPFluid, B extends IPFluidBlock> IPFluidEntry make(String name, int burnTime, Function<IPFluidEntry, S> makeSource, Function<IPFluidEntry, F> makeFlowing, BiFunction<IPFluidEntry, BlockBehaviour.Properties, B> makeBlock, @javax.annotation.Nullable Consumer<FluidType.Properties> buildAttributes, List<Property<?>> properties) {
            FluidType.Properties builder = FluidType.Properties.create();
            if (buildAttributes != null) {
                buildAttributes.accept(builder);
            }
            RegistryObject type = IPRegisters.FLUID_TYPE.register(name, () -> new CustomFluidType(name, builder));
            MutableObject thisMutable = new MutableObject();
            RegistryObject<IPFluid> source = IPRegisters.registerFluid(name, () -> IPFluidEntry.lambda$make$1(makeSource, (Mutable)thisMutable));
            RegistryObject<IPFluid> flow = IPRegisters.registerFluid(name + "_flowing", () -> IPFluidEntry.lambda$make$2(makeFlowing, (Mutable)thisMutable));
            RegistryObject<IPFluidBlock> block = IPRegisters.registerBlock(name + "_fluid_block", () -> IPFluidEntry.lambda$make$3(makeBlock, (Mutable)thisMutable));
            RegistryObject<BucketItem> bucket = IPRegisters.registerItem(name + "_bucket", () -> new IPBucketItem((Supplier<? extends Fluid>)source, burnTime));
            IPFluidEntry entry = new IPFluidEntry(source, flow, block, bucket, (RegistryObject<FluidType>)type, properties);
            thisMutable.setValue((Object)entry);
            FLUIDS.add(entry);
            return entry;
        }

        private static /* synthetic */ IPFluidBlock lambda$make$3(BiFunction makeBlock, Mutable thisMutable) {
            return (IPFluidBlock)((Object)makeBlock.apply((IPFluidEntry)thisMutable.getValue(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
        }

        private static /* synthetic */ IPFluid lambda$make$2(Function makeFlowing, Mutable thisMutable) {
            return IPFluid.makeFluid(makeFlowing, (IPFluidEntry)thisMutable.getValue());
        }

        private static /* synthetic */ IPFluid lambda$make$1(Function makeSource, Mutable thisMutable) {
            return IPFluid.makeFluid(makeSource, (IPFluidEntry)thisMutable.getValue());
        }
    }

    public static class IPFluidBlock
    extends LiquidBlock {
        private static IPFluidEntry staticEntry;
        protected final IPFluidEntry entry;
        @javax.annotation.Nullable
        private MobEffect effect;
        private int duration;
        private int level;

        public IPFluidBlock(IPFluidEntry entry, BlockBehaviour.Properties props) {
            super(entry.source(), (BlockBehaviour.Properties)Util.m_137469_((Object)props, p -> {
                staticEntry = entry;
            }));
            this.entry = entry;
            staticEntry = null;
        }

        public void setEffect(@javax.annotation.Nullable MobEffect effect, int duration, int level) {
            this.effect = effect;
            this.duration = duration;
            this.level = level;
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            for (Property<?> p : (this.entry == null ? staticEntry : this.entry).properties()) {
                builder.m_61104_(new Property[]{p});
            }
        }

        public FluidState m_5888_(BlockState pState) {
            FluidState state = super.m_5888_(pState);
            for (Property prop : state.m_61147_()) {
                if (!pState.m_61138_(prop)) continue;
                state = IPFluidBlock.copyValue(prop, state, pState);
            }
            return state;
        }

        public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
            super.m_7892_(pState, pLevel, pPos, pEntity);
            if (this.effect != null && pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                living.m_7292_(new MobEffectInstance(this.effect, this.duration, this.level));
            }
        }

        public static <S extends StateHolder<?, S>, P extends Comparable<P>> S copyValue(Property<P> prop, S oldState, StateHolder<?, ?> from) {
            return (S)((StateHolder)oldState.m_61124_(prop, from.m_61143_(prop)));
        }
    }

    public static class Flowing
    extends IPFluid {
        public Flowing(IPFluidEntry entry) {
            super(entry);
        }

        @Override
        protected void m_7180_(@Nonnull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }
    }

    public static class IPBucketItem
    extends BucketItem {
        private static final Item.Properties PROPS = new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).m_41491_(ImmersivePetroleum.creativeTab);
        private int burnTime;

        public IPBucketItem(Supplier<? extends Fluid> fluid, int burnTime) {
            super(fluid, PROPS);
            this.burnTime = burnTime;
        }

        public IPBucketItem(Supplier<? extends Fluid> fluid, Function<Item.Properties, Item.Properties> props) {
            super(fluid, props.apply(PROPS));
        }

        public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @javax.annotation.Nullable CompoundTag nbt) {
            return new FluidBucketWrapper(stack);
        }

        public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
            return this.burnTime;
        }
    }

    private static class CustomFluidType
    extends FluidType {
        final ResourceLocation stillTexture;
        final ResourceLocation flowTexture;

        public CustomFluidType(String name, FluidType.Properties properties) {
            super(properties);
            this.stillTexture = ResourceUtils.ip("block/fluid/" + name + "_still");
            this.flowTexture = ResourceUtils.ip("block/fluid/" + name + "_flow");
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowTexture;
                }
            });
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            if (!(state.m_76152_() instanceof IPFluid)) {
                return false;
            }
            IPFluid ipFluid = (IPFluid)state.m_76152_();
            if (!ipFluid.hasCustomSlowdown()) {
                return false;
            }
            double drag = ipFluid.getEntitySlowdown();
            boolean isFalling = entity.m_20184_().f_82480_ <= 0.0;
            double y = entity.m_20186_();
            double walkSpeed = entity.m_20142_() ? drag * 1.125 : drag;
            double swimSpeed = 0.02f;
            entity.m_19920_((float)(swimSpeed *= entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_()), movementVector);
            entity.m_6478_(MoverType.SELF, entity.m_20184_());
            Vec3 deltaMovment = entity.m_20184_();
            if (entity.f_19862_ && entity.m_6147_()) {
                deltaMovment = new Vec3(deltaMovment.f_82479_, 0.2, deltaMovment.f_82481_);
            }
            entity.m_20256_(deltaMovment.m_82542_(walkSpeed, drag, walkSpeed));
            Vec3 vec32 = entity.m_20994_(gravity, isFalling, entity.m_20184_());
            entity.m_20256_(vec32);
            if (entity.f_19862_ && entity.m_20229_(vec32.f_82479_, vec32.f_82480_ + 0.6 - entity.m_20186_() + y, vec32.f_82481_)) {
                entity.m_20334_(vec32.f_82479_, 0.3, vec32.f_82481_);
            }
            return true;
        }
    }
}

