/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.fluid.IPressurizedFluidOutput;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.multiblocks.OilTankMultiblock;
import flaxbeard.immersivepetroleum.common.util.AABBUtils;
import flaxbeard.immersivepetroleum.common.util.FluidHelper;
import flaxbeard.immersivepetroleum.common.util.LayeredComparatorOutput;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class OilTankTileEntity
extends MultiblockPartBlockEntity<OilTankTileEntity>
implements IPCommonTickableTile,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IComparatorOverride,
IPressurizedFluidOutput {
    public static final Set<BlockPos> Redstone_IN = ImmutableSet.of((Object)new BlockPos(2, 2, 5), (Object)new BlockPos(2, 2, 2));
    public final FluidTank tank = new FluidTank(1024000);
    public final EnumMap<Port, PortState> portConfig = new EnumMap(Port.class);
    static final int MAX_FLUID_IO = 10000;
    private final MultiblockCapability<IFluidHandler> inputHandler = MultiblockCapability.make((Object)this, be -> be.inputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidInput(new IFluidTank[]{this.tank}));
    private final MultiblockCapability<IFluidHandler> outputHandler = MultiblockCapability.make((Object)this, be -> be.outputHandler, MultiblockPartBlockEntity::master, (ResettableCapability)this.registerFluidOutput(new IFluidTank[]{this.tank}));
    private final LayeredComparatorOutput comparatorHelper = new LayeredComparatorOutput(this.tank.getCapacity(), 3, () -> this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_()), layer -> {
        BlockPos masterPos = this.f_58858_.m_121996_((Vec3i)this.offsetToMaster);
        for (int z = -2; z <= 2; ++z) {
            for (int x = -2; x <= 2; ++x) {
                BlockPos pos = masterPos.m_7918_(x, layer, z);
                this.f_58857_.m_46672_(pos, this.f_58857_.m_8055_(pos).m_60734_());
            }
        }
    });
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(OilTankTileEntity::getShape);

    public OilTankTileEntity(BlockEntityType<OilTankTileEntity> type, BlockPos pWorldPosition, BlockState pBlockState) {
        super((IETemplateMultiblock)OilTankMultiblock.INSTANCE, type, true, pWorldPosition, pBlockState);
        this.redstoneControlInverted = false;
        for (Port port : Port.values()) {
            if (port == Port.DYNAMIC_B || port == Port.DYNAMIC_C || port == Port.BOTTOM) {
                this.portConfig.put(port, PortState.OUTPUT);
                continue;
            }
            this.portConfig.put(port, PortState.INPUT);
        }
    }

    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        for (Port port : Port.DYNAMIC_PORTS) {
            this.portConfig.put(port, PortState.values()[nbt.m_128451_(port.m_7912_())]);
        }
    }

    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        for (Port port : Port.DYNAMIC_PORTS) {
            nbt.m_128405_(port.m_7912_(), this.getPortStateFor(port).ordinal());
        }
    }

    @Override
    public void tickClient() {
    }

    @Override
    public void tickServer() {
        if (this.isDummy()) {
            return;
        }
        int threshold = 1;
        PortState portStateA = this.getPortStateFor(Port.DYNAMIC_A);
        PortState portStateB = this.getPortStateFor(Port.DYNAMIC_B);
        PortState portStateC = this.getPortStateFor(Port.DYNAMIC_C);
        PortState portStateD = this.getPortStateFor(Port.DYNAMIC_D);
        boolean wasBalancing = false;
        if (portStateA == PortState.OUTPUT && portStateC == PortState.INPUT || portStateA == PortState.INPUT && portStateC == PortState.OUTPUT) {
            wasBalancing |= this.equalize(Port.DYNAMIC_A, threshold, 1000);
        }
        if (portStateB == PortState.OUTPUT && portStateD == PortState.INPUT || portStateB == PortState.INPUT && portStateD == PortState.OUTPUT) {
            wasBalancing |= this.equalize(Port.DYNAMIC_B, threshold, 1000);
        }
        if (this.isRSDisabled()) {
            for (Port port : Port.values()) {
                if ((wasBalancing || this.getPortStateFor(port) != PortState.OUTPUT) && (!wasBalancing || port != Port.BOTTOM)) continue;
                Direction facing = this.getPortDirection(port);
                BlockPos pos = this.getBlockPosForPos(port.posInMultiblock).m_121945_(facing);
                FluidUtil.getFluidHandler((Level)this.f_58857_, (BlockPos)pos, (Direction)facing.m_122424_()).map(out -> {
                    FluidStack fs;
                    int accepted;
                    if (this.tank.getFluidAmount() > 0 && (accepted = out.fill(fs = FluidHelper.copyFluid(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 432), false), IFluidHandler.FluidAction.SIMULATE)) > 0) {
                        int drained = out.fill(FluidHelper.copyFluid(fs, Math.min(fs.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
                        this.tank.drain(Utils.copyFluidStackWithAmount((FluidStack)this.tank.getFluid(), (int)drained, (boolean)false), IFluidHandler.FluidAction.EXECUTE);
                        this.m_6596_();
                        this.markContainingBlockForUpdate(null);
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
        }
        this.comparatorHelper.update(this.tank.getFluidAmount());
    }

    private boolean equalize(Port port, int threshold, int maxTransfer) {
        Direction facing = this.getPortDirection(port);
        BlockPos pos = this.getBlockPosForPos(port.posInMultiblock).m_121945_(facing);
        BlockEntity te = this.m_58904_().m_7702_(pos);
        if (te instanceof OilTankTileEntity) {
            OilTankTileEntity otherMaster = (OilTankTileEntity)te;
            otherMaster = (OilTankTileEntity)otherMaster.master();
            int diff = otherMaster.tank.getFluidAmount() - this.tank.getFluidAmount();
            int amount = Math.min(Math.abs(diff) / 2, maxTransfer);
            return diff <= -threshold && this.transfer(this, otherMaster, amount) || diff >= threshold && this.transfer(otherMaster, this, amount);
        }
        return false;
    }

    private boolean transfer(OilTankTileEntity src, OilTankTileEntity dst, int amount) {
        FluidStack fs = new FluidStack(src.tank.getFluid(), amount);
        int accepted = dst.tank.fill(fs, IFluidHandler.FluidAction.SIMULATE);
        if (accepted > 0) {
            fs = new FluidStack(src.tank.getFluid(), accepted);
            dst.tank.fill(fs, IFluidHandler.FluidAction.EXECUTE);
            src.tank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
            src.m_6596_();
            dst.m_6596_();
            src.markContainingBlockForUpdate(null);
            dst.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private Direction getPortDirection(Port port) {
        switch (port) {
            case DYNAMIC_B: 
            case DYNAMIC_D: {
                return this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            }
            case DYNAMIC_A: 
            case DYNAMIC_C: {
                return this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
            }
            case TOP: {
                return Direction.UP;
            }
        }
        return Direction.DOWN;
    }

    public boolean isRSDisabled() {
        Set<BlockPos> rsPositions = this.getRedstonePos();
        if (rsPositions == null || rsPositions.isEmpty()) {
            return false;
        }
        MultiblockPartBlockEntity master = this.master();
        if (master == null) {
            master = this;
        }
        if (master.computerControl.isAttached()) {
            return !master.computerControl.isEnabled();
        }
        boolean ret = false;
        for (BlockPos rsPos : rsPositions) {
            OilTankTileEntity tile = (OilTankTileEntity)this.getEntityForPos(rsPos);
            if (tile == null) continue;
            ret |= tile.isRSPowered();
        }
        return this.redstoneControlInverted != ret;
    }

    public boolean interact(@Nonnull Direction side, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull ItemStack heldItem, float hitX, float hitY, float hitZ) {
        OilTankTileEntity master = (OilTankTileEntity)this.master();
        if (master != null && FluidUtils.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)master.tank)) {
            this.updateMasterBlock(null, true);
            return true;
        }
        return false;
    }

    public boolean hammerUseSide(@Nonnull Direction side, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull Vec3 hitVec) {
        Level level = this.getLevelNonnull();
        if (!level.f_46443_) {
            for (Port port : Port.DYNAMIC_PORTS) {
                if (!port.posInMultiblock.equals((Object)this.posInMultiblock)) continue;
                OilTankTileEntity master = (OilTankTileEntity)this.master();
                if (master == null) break;
                PortState portState = master.getPortStateFor(port);
                master.portConfig.put(port, portState.next());
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    public PortState getPortStateFor(Port port) {
        return this.portConfig.get((Object)port);
    }

    public int getMaxAcceptedFluidAmount(FluidStack resource) {
        return 10000;
    }

    public Set<BlockPos> getRedstonePos() {
        return Redstone_IN;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            for (Port port : Port.values()) {
                OilTankTileEntity master;
                if (!port.matches(this.posInMultiblock)) continue;
                OilTankTileEntity oilTankTileEntity = master = this.isDummy() ? (OilTankTileEntity)this.master() : this;
                if (master == null) {
                    return LazyOptional.empty();
                }
                return switch (master.portConfig.get((Object)port)) {
                    default -> throw new IncompatibleClassChangeError();
                    case PortState.INPUT -> this.inputHandler.getAndCast();
                    case PortState.OUTPUT -> this.outputHandler.getAndCast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public boolean isLadder() {
        int x = this.posInMultiblock.m_123341_();
        int z = this.posInMultiblock.m_123343_();
        return x == 3 && z == 0;
    }

    public Component[] getOverlayText(Player player, @Nonnull HitResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND))) {
            OilTankTileEntity master = (OilTankTileEntity)this.master();
            FluidStack fs = master != null ? master.tank.getFluid() : this.tank.getFluid();
            return new Component[]{TextUtils.formatFluidStack((FluidStack)fs)};
        }
        return null;
    }

    public boolean useNixieFont(@Nonnull Player player, @Nonnull HitResult mop) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-3, -1, -3), pos.m_7918_(3, 4, 3));
    }

    public int getComparatorInputOverride() {
        OilTankTileEntity master = (OilTankTileEntity)this.master();
        if (master != null && this.offsetToMaster.m_123342_() >= 0 && this.offsetToMaster.m_123342_() < this.comparatorHelper.getLayers()) {
            return master.comparatorHelper.getLayerOutput(this.offsetToMaster.m_123342_());
        }
        return 0;
    }

    @Nonnull
    public VoxelShape getBlockBounds(CollisionContext ctx) {
        return SHAPES.get((Object)this.posInMultiblock, (Object)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        int x = posInMultiblock.m_123341_();
        int y = posInMultiblock.m_123342_();
        int z = posInMultiblock.m_123343_();
        ArrayList<AABB> main = new ArrayList<AABB>();
        if (y == 0) {
            if (x == 0 && z == 1) {
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 4.0, 16.0, 4.0);
                AABBUtils.box16(main, 8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
            }
            if (x == 4 && z == 1) {
                AABBUtils.box16(main, 12.0, 0.0, 0.0, 16.0, 16.0, 4.0);
                AABBUtils.box16(main, 0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
            }
            if (x == 0 && z == 5) {
                AABBUtils.box16(main, 0.0, 0.0, 12.0, 4.0, 16.0, 16.0);
                AABBUtils.box16(main, 8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
            }
            if (x == 4 && z == 5) {
                AABBUtils.box16(main, 12.0, 0.0, 12.0, 16.0, 16.0, 16.0);
                AABBUtils.box16(main, 0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
            }
            if (x < 1 || z < 2 || x > 3 || z > 4) {
                AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
            }
            if (z >= 2 && z <= 4) {
                if (x == 0) {
                    AABBUtils.box16(main, 8.0, 0.0, 0.0, 16.0, 8.0, 16.0);
                }
                if (x == 4) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 8.0, 8.0, 16.0);
                }
            }
            if (x >= 1 && x <= 3) {
                if (z == 1) {
                    AABBUtils.box16(main, 0.0, 0.0, 8.0, 16.0, 8.0, 16.0);
                }
                if (z == 5) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 8.0, 8.0);
                }
            }
        }
        if (x == 3 && z == 0 && (y == 1 || y == 2)) {
            AABBUtils.box16(main, 2.0, 0.0, 15.0, 14.0, 16.0, 16.0);
        }
        if (y == 2 && z == 0 && (x == 2 || x == 4)) {
            AABBUtils.box16(main, 0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
        }
        if (y == 3) {
            if (z >= 1 && z <= 5) {
                if (x == 0) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
                } else if (x == 4) {
                    AABBUtils.box16(main, 15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
                }
            }
            if (x >= 0 && x <= 4) {
                if (z == 5) {
                    AABBUtils.box16(main, 0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
                } else if (z == 1 && x != 4) {
                    AABBUtils.box16(main, 0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
                }
            }
        }
        if (main.isEmpty()) {
            main.add(AABBUtils.FULL);
        }
        return main;
    }

    public static enum Port implements StringRepresentable
    {
        TOP(new BlockPos(2, 2, 3)),
        BOTTOM(new BlockPos(2, 0, 3)),
        DYNAMIC_A(new BlockPos(0, 1, 2)),
        DYNAMIC_B(new BlockPos(4, 1, 2)),
        DYNAMIC_C(new BlockPos(0, 1, 4)),
        DYNAMIC_D(new BlockPos(4, 1, 4));

        public static final Port[] DYNAMIC_PORTS;
        public final BlockPos posInMultiblock;

        private Port(BlockPos posInMultiblock) {
            this.posInMultiblock = posInMultiblock;
        }

        public boolean matches(BlockPos posInMultiblock) {
            return posInMultiblock.equals((Object)this.posInMultiblock);
        }

        @Nonnull
        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        static Set<BlockPos> toSet(Port ... ports) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Port port : ports) {
                builder.add((Object)port.posInMultiblock);
            }
            return builder.build();
        }

        static {
            DYNAMIC_PORTS = new Port[]{DYNAMIC_A, DYNAMIC_B, DYNAMIC_C, DYNAMIC_D};
        }
    }

    public static enum PortState implements StringRepresentable
    {
        INPUT,
        OUTPUT;


        @Nonnull
        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ENGLISH);
        }

        public Component getText() {
            return Component.m_237115_((String)("desc.immersivepetroleum.info.oiltank." + this.m_7912_()));
        }

        public PortState next() {
            return this == INPUT ? OUTPUT : INPUT;
        }
    }
}

