/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReservoirRegionDataStorage
extends SavedData {
    private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/RegionDataStorage");
    private static final String DATA_NAME = "ImmersivePetroleum-ReservoirRegions";
    private static ReservoirRegionDataStorage active_instance;
    final Map<RegionPos, RegionData> regions = new HashMap<RegionPos, RegionData>();
    final DimensionDataStorage dimData;

    public static ReservoirRegionDataStorage get() {
        return active_instance;
    }

    public static final void init(DimensionDataStorage dimData) {
        active_instance = (ReservoirRegionDataStorage)dimData.m_164861_(t -> new ReservoirRegionDataStorage(dimData, (CompoundTag)t), () -> {
            log.debug("Creating new ReservoirRegionDataStorage instance.");
            return new ReservoirRegionDataStorage(dimData);
        }, DATA_NAME);
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData) {
        this.dimData = dimData;
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData, CompoundTag nbt) {
        this.dimData = dimData;
        this.load(nbt);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.regions.forEach((key, entry) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", key.x());
            tag.m_128405_("z", key.z());
            list.add((Object)tag);
        });
        nbt.m_128365_("regions", (Tag)list);
        log.debug("Saved regions file.");
        return nbt;
    }

    private void load(CompoundTag nbt) {
        ListTag regions = nbt.m_128437_("regions", 10);
        for (int i = 0; i < regions.size(); ++i) {
            CompoundTag tag = regions.m_128728_(i);
            int x = tag.m_128451_("x");
            int z = tag.m_128451_("z");
            RegionPos rPos = new RegionPos(x, z);
            RegionData rData = this.getOrCreateRegionData(rPos);
            this.regions.put(rPos, rData);
        }
        log.debug("Loaded regions file.");
    }

    public void markAllDirty() {
        this.m_77762_();
        this.regions.values().forEach(SavedData::m_77762_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIsland(ResourceKey<Level> dimensionKey, ReservoirIsland island) {
        RegionPos regionPos = new RegionPos(island.getBoundingBox().getCenter());
        RegionData regionData = this.getOrCreateRegionData(regionPos);
        Multimap<ResourceKey<Level>, ReservoirIsland> multimap = regionData.reservoirlist;
        synchronized (multimap) {
            if (!regionData.reservoirlist.containsEntry(dimensionKey, (Object)island)) {
                regionData.reservoirlist.put(dimensionKey, (Object)island);
                island.setRegion(regionData);
                regionData.m_77762_();
            }
        }
    }

    @Nullable
    public ReservoirIsland getIsland(Level world, BlockPos pos) {
        return this.getIsland(world, Utils.toColumnPos(pos));
    }

    @Nullable
    public ReservoirIsland getIsland(Level world, ColumnPos pos) {
        if (world.f_46443_) {
            return null;
        }
        ResourceKey dimKey = world.m_46472_();
        ReservoirIsland ret = this.getIsland((ResourceKey<Level>)dimKey, pos, 0, 0);
        ret = this.getIsland((ResourceKey<Level>)dimKey, pos, 1, -1);
        if (ret == null && (ret = this.getIsland((ResourceKey<Level>)dimKey, pos, 1, 1)) == null && (ret = this.getIsland((ResourceKey<Level>)dimKey, pos, -1, -1)) == null) {
            ret = this.getIsland((ResourceKey<Level>)dimKey, pos, -1, 1);
        }
        return ret;
    }

    private ReservoirIsland getIsland(ResourceKey<Level> dimKey, ColumnPos pos, int regionXOff, int regionZOff) {
        RegionData regionData = this.getRegionData(new RegionPos(pos, regionXOff, regionZOff));
        return regionData != null ? regionData.get(dimKey, pos) : null;
    }

    public boolean existsAt(ColumnPos pos) {
        boolean ret = false;
        ret = this.existsAt(pos, 1, -1);
        if (!(ret || (ret = this.existsAt(pos, 1, 1)) || (ret = this.existsAt(pos, -1, -1)))) {
            ret = this.existsAt(pos, -1, 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsAt(ColumnPos pos, int regionXOff, int regionZOff) {
        RegionData regionData = this.getRegionData(new RegionPos(pos, regionXOff, regionZOff));
        if (regionData == null) {
            return false;
        }
        boolean ret = false;
        Multimap<ResourceKey<Level>, ReservoirIsland> multimap = regionData.reservoirlist;
        synchronized (multimap) {
            ret = regionData.reservoirlist.values().stream().anyMatch(island -> island.contains(pos));
        }
        return ret;
    }

    @Nullable
    public RegionData getRegionData(BlockPos pos) {
        return this.getRegionData(new RegionPos(pos));
    }

    @Nullable
    public RegionData getRegionData(RegionPos regionPos) {
        RegionData ret = this.regions.getOrDefault(regionPos, null);
        return ret;
    }

    private RegionData getOrCreateRegionData(RegionPos regionPos) {
        RegionData ret = this.regions.computeIfAbsent(regionPos, p -> {
            String fn = this.getRegionFileName((RegionPos)p);
            RegionData data = (RegionData)this.dimData.m_164861_(t -> new RegionData((RegionPos)p, (CompoundTag)t), () -> new RegionData((RegionPos)p), fn);
            this.m_77762_();
            log.debug("Created RegionData[{}, {}]", (Object)regionPos.x(), (Object)regionPos.z());
            return data;
        });
        return ret;
    }

    private String getRegionFileName(RegionPos regionPos) {
        return DATA_NAME + File.separatorChar + regionPos.x() + "_" + regionPos.z();
    }

    public record RegionPos(int x, int z) {
        public RegionPos(BlockPos pos, int xOff, int zOff) {
            this(pos.m_123341_() + 256 * xOff >> 9, pos.m_123343_() + 256 * zOff >> 9);
        }

        public RegionPos(ColumnPos pos, int xOff, int zOff) {
            this(pos.f_140723_() + 256 * xOff >> 9, pos.f_140724_() + 256 * zOff >> 9);
        }

        public RegionPos(BlockPos pos) {
            this(pos.m_123341_() >> 9, pos.m_123343_() >> 9);
        }

        public RegionPos(ColumnPos pos) {
            this(pos.f_140723_() >> 9, pos.f_140724_() >> 9);
        }
    }

    public static class RegionData
    extends SavedData {
        final RegionPos regionPos;
        final Multimap<ResourceKey<Level>, ReservoirIsland> reservoirlist = ArrayListMultimap.create();

        RegionData(RegionPos regionPos) {
            this.regionPos = regionPos;
        }

        RegionData(RegionPos regionPos, CompoundTag nbt) {
            this.regionPos = regionPos;
            this.load(nbt);
        }

        public void m_77757_(File pFile) {
            if (!pFile.getParentFile().exists()) {
                pFile.getParentFile().mkdirs();
            }
            super.m_77757_(pFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundTag m_7176_(CompoundTag nbt) {
            ListTag reservoirs = new ListTag();
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                for (ResourceKey dimension : this.reservoirlist.keySet()) {
                    CompoundTag dim = new CompoundTag();
                    dim.m_128359_("dimension", dimension.m_135782_().toString());
                    ListTag islands = new ListTag();
                    for (ReservoirIsland island : this.reservoirlist.get((Object)dimension)) {
                        islands.add((Object)island.writeToNBT());
                    }
                    dim.m_128365_("islands", (Tag)islands);
                    reservoirs.add((Object)dim);
                }
            }
            nbt.m_128365_("reservoirs", (Tag)reservoirs);
            log.debug("{} Saved.", (Object)this);
            return nbt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(CompoundTag nbt) {
            ListTag reservoirs = nbt.m_128437_("reservoirs", 10);
            if (!reservoirs.isEmpty()) {
                Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
                synchronized (multimap) {
                    for (int i = 0; i < reservoirs.size(); ++i) {
                        CompoundTag dim = reservoirs.m_128728_(i);
                        ResourceLocation rl = new ResourceLocation(dim.m_128461_("dimension"));
                        ResourceKey dimType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                        ListTag islands = dim.m_128437_("islands", 10);
                        List<ReservoirIsland> list = islands.stream().map(inbt -> ReservoirIsland.readFromNBT((CompoundTag)inbt)).filter(o -> o != null).collect(Collectors.toList());
                        list.forEach(island -> island.setRegion(this));
                        this.reservoirlist.putAll((Object)dimType, list);
                    }
                }
                log.debug("{} Loaded.", (Object)this);
            }
        }

        public RegionPos position() {
            return this.regionPos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public ReservoirIsland get(ResourceKey<Level> dimension, ColumnPos pos) {
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                for (ReservoirIsland island : this.reservoirlist.get(dimension)) {
                    if (!island.contains(pos)) continue;
                    return island;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Multimap<ResourceKey<Level>, ReservoirIsland> getReservoirIslandList() {
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                return ImmutableMultimap.copyOf(this.reservoirlist);
            }
        }

        public int hashCode() {
            return Objects.hash(this.regionPos);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegionData)) {
                return false;
            }
            RegionData other = (RegionData)((Object)obj);
            return Objects.equals(this.regionPos, other.regionPos);
        }

        public String toString() {
            return String.format("RegionData[%d, %d]", this.regionPos.x(), this.regionPos.z());
        }
    }
}

