/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.particle;

import com.mojang.math.Vector3f;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
public class FlareFire
extends SimpleAnimatedParticle {
    final double ogMotionY;
    final float red;
    final float green;
    final float blue;
    final float rotation;

    protected FlareFire(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet spriteWithAge) {
        super(world, x, y, z, spriteWithAge, 0.0f);
        this.m_107250_(0.5f, 0.5f);
        this.m_108339_(spriteWithAge);
        this.f_172258_ = 1.0f;
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.m_107257_(60);
        this.f_107663_ = 0.5f;
        this.blue = 1.0f;
        this.green = 1.0f;
        this.red = 1.0f;
        this.ogMotionY = motionY;
        this.rotation = 0.25f * (world.f_46441_.m_188501_() - 0.5f);
        this.f_107204_ = 360.0f * world.f_46441_.m_188501_();
        this.f_107231_ = this.f_107204_ + this.rotation * world.f_46441_.m_188501_();
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
    }

    public void m_5989_() {
        float f = (float)this.f_107224_ / (float)this.f_107225_;
        Vector3f vec = Wind.getDirection();
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        if (this.f_107224_ == this.f_107225_ - 36) {
            this.f_107228_ = this.f_107229_ = (float)((double)0.4f * Math.random());
            this.f_107227_ = this.f_107229_;
        }
        this.m_108339_(this.f_107644_);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        this.m_6257_(vec.m_122239_() * f, this.ogMotionY * (double)(1.0f - f), vec.m_122269_() * f);
        this.f_107231_ += this.rotation;
    }

    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class Wind {
        private static Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        private static long lastGT;
        private static float lastDirection;
        private static float thisDirection;

        public static Vector3f getDirection() {
            return vec;
        }

        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent event) {
            if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START) {
                ClientLevel world = MCUtil.getLevel();
                if (world == null) {
                    return;
                }
                long gameTime = world.m_46467_();
                if (gameTime / 20L != lastGT) {
                    lastGT = gameTime / 20L;
                    double fGameTime = (double)gameTime / 20.0;
                    Random lastRand = new Random(Mth.m_14107_((double)fGameTime));
                    Random thisRand = new Random(Mth.m_14165_((double)fGameTime));
                    lastDirection = lastRand.nextFloat() * 360.0f;
                    thisDirection = thisRand.nextFloat() * 360.0f;
                }
                double interpDirection = Mth.m_14179_((float)((float)(gameTime % 20L) / 20.0f), (float)lastDirection, (float)thisDirection);
                float xSpeed = (float)Math.sin(interpDirection) * 0.1f;
                float zSpeed = (float)Math.cos(interpDirection) * 0.1f;
                vec = new Vector3f(xSpeed, 0.0f, zSpeed);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull SimpleParticleType typeIn, @Nonnull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FlareFire(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

