/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.elements;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiReactiveList
extends Button {
    private final Screen gui;
    private String[] entries;
    private int[] padding = new int[]{0, 0, 0, 0};
    private boolean needsSlider = false;
    private int perPage;
    private Function<String, String> translationFunction;
    private int scrollMode = 0;
    private float textScale = 1.0f;
    private int textColor = 0xE0E0E0;
    private int textHoverColor = -557004;
    private int offset;
    private int maxOffset;
    private long prevWheelNano = 0L;
    private int targetEntry = -1;
    private float hoverTimer = 0.0f;
    static final ResourceLocation TEXTURE = ResourceUtils.ie("textures/gui/hud_elements.png");
    public int selectedOption = -1;

    public GuiReactiveList(Screen gui, int x, int y, int w, int h, Button.OnPress handler, String ... entries) {
        super(x, y, w, h, (Component)Component.m_237119_(), handler);
        this.gui = gui;
        this.entries = entries;
        this.recalculateEntries();
    }

    private void recalculateEntries() {
        float f = this.f_93619_ - this.padding[0] - this.padding[1];
        Objects.requireNonNull(MCUtil.getFont());
        this.perPage = (int)(f / (9.0f * this.textScale));
        if (this.perPage < this.entries.length) {
            this.needsSlider = true;
            this.maxOffset = this.entries.length - this.perPage;
        } else {
            this.needsSlider = false;
        }
    }

    public GuiReactiveList setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public GuiReactiveList setTextHoverColor(int color) {
        this.textHoverColor = color;
        return this;
    }

    public GuiReactiveList setPadding(int up, int down, int left, int right) {
        this.padding[0] = up;
        this.padding[1] = down;
        this.padding[2] = left;
        this.padding[3] = right;
        this.recalculateEntries();
        return this;
    }

    public GuiReactiveList setTranslationFunc(Function<String, String> func) {
        this.translationFunction = func;
        return this;
    }

    public GuiReactiveList setScrollMode(int mode) {
        this.scrollMode = mode;
        return this;
    }

    public GuiReactiveList setFormatting(float textScale) {
        this.textScale = textScale;
        this.recalculateEntries();
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    /*
     * Unable to fully structure code
     */
    public void m_6305_(@Nonnull PoseStack transform, int mx, int my, float partialTicks) {
        fr = MCUtil.getFont();
        mmY = my - this.f_93621_;
        strWidth = this.f_93618_ - this.padding[2] - this.padding[3] - (this.needsSlider != false ? 6 : 0);
        if (this.needsSlider) {
            ClientUtils.bindTexture((ResourceLocation)GuiReactiveList.TEXTURE);
            this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 6, this.f_93621_, 16, 136, 6, 4);
            this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 6, this.f_93621_ + this.f_93619_ - 4, 16, 144, 6, 4);
            for (i = 0; i < this.f_93619_ - 8; i += 2) {
                this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 6, this.f_93621_ + 4 + i, 16, 141, 6, 2);
            }
            Objects.requireNonNull(fr);
            sliderSize = Math.max(6, this.f_93619_ - this.maxOffset * 9);
            silderShift = (float)(this.f_93619_ - sliderSize) / (float)this.maxOffset * (float)this.offset;
            this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 5, (int)((float)this.f_93621_ + silderShift + 1.0f), 20, 129, 4, 2);
            this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 5, (int)((float)this.f_93621_ + silderShift + (float)sliderSize - 4.0f), 20, 132, 4, 3);
            for (i = 0; i < sliderSize - 7; ++i) {
                this.m_93228_(transform, this.f_93620_ + this.f_93618_ - 5, (int)((float)this.f_93621_ + silderShift + 3.0f + (float)i), 20, 131, 4, 1);
            }
        }
        transform.m_85841_(this.textScale, this.textScale, 1.0f);
        this.f_93622_ = mx >= this.f_93620_ && mx < this.f_93620_ + this.f_93618_ && my >= this.f_93621_ && my < this.f_93621_ + this.f_93619_;
        hasTarget = false;
        for (i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
            j = this.offset + i;
            col = this.textColor;
            if (!this.f_93622_) ** GOTO lbl-1000
            Objects.requireNonNull(fr);
            if (mmY < i * 9) ** GOTO lbl-1000
            Objects.requireNonNull(fr);
            if (mmY < (i + 1) * 9) {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = selectionHover = false;
            }
            if (selectionHover) {
                hasTarget = true;
                if (this.targetEntry != j) {
                    this.targetEntry = j;
                    this.hoverTimer = 0.0f;
                } else {
                    this.hoverTimer = (float)((double)this.hoverTimer + 2.5 * (double)partialTicks);
                }
                col = this.textHoverColor;
            }
            if (j > this.entries.length - 1) {
                j = this.entries.length - 1;
            }
            if ((overLength = (s = this.translationFunction != null ? this.translationFunction.apply(this.entries[j]) : this.entries[j]).length() - fr.m_92834_((String)s, strWidth).length()) > 0) {
                if (selectionHover && this.hoverTimer > 20.0f) {
                    textOffset = (int)this.hoverTimer / 10 % s.length();
                    s = s.substring(textOffset) + " " + s.substring(0, textOffset);
                }
                s = fr.m_92834_((String)s, strWidth);
            }
            tx = (float)(this.f_93620_ + this.padding[2]) / this.textScale;
            v1 = this.f_93621_ + this.padding[0];
            Objects.requireNonNull(fr);
            ty = (float)(v1 + 9 * i) / this.textScale;
            transform.m_85837_((double)tx, (double)ty, 0.0);
            fr.m_92883_(transform, (String)s, 0.0f, 0.0f, col);
            transform.m_85837_((double)(-tx), (double)(-ty), 0.0);
        }
        transform.m_85841_(1.0f / this.textScale, 1.0f / this.textScale, 1.0f);
        if (!hasTarget) {
            this.targetEntry = -1;
            this.hoverTimer = 0.0f;
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta != 0.0 && this.maxOffset > 0) {
            if (delta < 0.0 && this.offset < this.maxOffset) {
                ++this.offset;
            }
            if (delta > 0.0 && this.offset > 0) {
                --this.offset;
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mx, double my, int key) {
        this.selectedOption = -1;
        if (this.f_93623_ && this.f_93624_ && this.m_7972_(key) && this.m_93680_(mx, my)) {
            Font fr = MCUtil.getFont();
            double mmY = my - (double)this.f_93621_;
            for (int i = 0; i < Math.min(this.perPage, this.entries.length); ++i) {
                Objects.requireNonNull(fr);
                if (!(mmY >= (double)(i * 9))) continue;
                Objects.requireNonNull(fr);
                if (!(mmY < (double)((i + 1) * 9))) continue;
                this.selectedOption = this.offset + i;
            }
        }
        super.m_6375_(mx, my, key);
        return this.selectedOption != -1;
    }
}

