/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client;

import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.SpecialManualElement;
import com.electronwill.nightconfig.core.Config;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.ClientEventHandler;
import flaxbeard.immersivepetroleum.client.gui.CokerUnitScreen;
import flaxbeard.immersivepetroleum.client.gui.DerrickScreen;
import flaxbeard.immersivepetroleum.client.gui.DistillationTowerScreen;
import flaxbeard.immersivepetroleum.client.gui.HydrotreaterScreen;
import flaxbeard.immersivepetroleum.client.particle.FluidParticleData;
import flaxbeard.immersivepetroleum.client.render.SeismicResultRenderer;
import flaxbeard.immersivepetroleum.client.render.debugging.DebugRenderHandler;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPMenuTypes;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.RecipeReloadListener;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientProxy
extends CommonProxy {
    @Override
    public void setup() {
    }

    @Override
    public void registerContainersAndScreens() {
        MenuScreens.m_96206_(IPMenuTypes.DISTILLATION_TOWER.getType(), DistillationTowerScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.COKER.getType(), CokerUnitScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.DERRICK.getType(), DerrickScreen::new);
        MenuScreens.m_96206_(IPMenuTypes.HYDROTREATER.getType(), HydrotreaterScreen::new);
    }

    @Override
    public void completed(ParallelDispatchEvent event) {
        event.enqueueWork(() -> ManualHelper.addConfigGetter(str -> switch (str) {
            case "distillationtower_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.distillationTower_energyModifier.get());
            case "coker_operationcost" -> (int)(1024.0 * (Double)IPServerConfig.REFINING.cokerUnit_energyModifier.get());
            case "hydrotreater_operationcost_lower" -> (int)(80.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "hydrotreater_operationcost_upper" -> (int)(512.0 * (Double)IPServerConfig.REFINING.hydrotreater_energyModifier.get());
            case "pumpjack_consumption" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_consumption.get();
            case "pumpjack_speed" -> (Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get();
            case "pumpjack_days" -> {
                int oil_min = 1000000;
                int oil_max = 5000000;
                for (ReservoirType reservoir : ReservoirType.map.values()) {
                    if (!reservoir.name.equals("oil")) continue;
                    oil_min = reservoir.minSize;
                    oil_max = reservoir.maxSize;
                    break;
                }
                float averageSize = (float)(oil_min + oil_max) / 2.0f;
                float pumpspeed = ((Integer)IPServerConfig.EXTRACTION.pumpjack_speed.get()).intValue();
                yield Mth.m_14143_((float)(averageSize / pumpspeed / 24000.0f));
            }
            case "autolubricant_speedup" -> 1.25;
            case "portablegenerator_flux" -> FuelHandler.getFluxGeneratedPerTick((Fluid)IPContent.Fluids.GASOLINE.source().get());
            default -> {
                Config cfg = IPServerConfig.getRawConfig();
                if (cfg.contains(str)) {
                    yield cfg.get(str);
                }
                yield null;
            }
        }));
        this.setupManualPages();
    }

    @Override
    public void preInit() {
    }

    @Override
    public void preInitEnd() {
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new RecipeReloadListener(null));
        MinecraftForge.EVENT_BUS.register((Object)new DebugRenderHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SeismicResultRenderer());
    }

    @Override
    public void renderTile(BlockEntity te, VertexConsumer iVertexBuilder, PoseStack transform, MultiBufferSource buffer) {
        BlockEntityRenderer tesr = Minecraft.m_91087_().m_167982_().m_112265_(te);
        if (tesr == null) {
            return;
        }
        if (te instanceof PumpjackTileEntity) {
            PumpjackTileEntity pumpjack = (PumpjackTileEntity)te;
            transform.m_85836_();
            transform.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.m_85837_(1.0, 1.0, -2.0);
            float pt = 0.0f;
            if (MCUtil.getPlayer() != null) {
                pumpjack.activeTicks = MCUtil.getPlayer().f_19797_;
                pt = Minecraft.m_91087_().m_91296_();
            }
            tesr.m_6922_((BlockEntity)pumpjack, pt, transform, buffer, 0xF000F0, OverlayTexture.f_118083_);
            transform.m_85849_();
        } else {
            transform.m_85836_();
            transform.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
            transform.m_85837_(0.0, 1.0, -4.0);
            tesr.m_6922_(te, 0.0f, transform, buffer, 0xF000F0, OverlayTexture.f_118083_);
            transform.m_85849_();
        }
    }

    @Override
    public void drawUpperHalfSlab(PoseStack transform, ItemStack stack) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        BlockState state = ((IEBlocks.BlockEntry)IEBlocks.MetalDecoration.STEEL_SCAFFOLDING.get(MetalScaffoldingType.STANDARD)).defaultBlockState();
        BakedModel model = blockRenderer.m_110907_().m_110893_(state);
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        transform.m_85836_();
        transform.m_85837_(0.0, 0.5, 1.0);
        blockRenderer.m_110937_().renderModel(transform.m_85850_(), buffers.m_6299_(RenderType.m_110451_()), state, model, 1.0f, 1.0f, 1.0f, -1, -1, ModelData.EMPTY, RenderType.m_110463_());
        transform.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnSpillParticles(Level world, BlockPos pos, Fluid fluid, int particles, float yOffset, float flow) {
        if (fluid == null || fluid == Fluids.f_76191_) {
            return;
        }
        for (int i = 0; i < particles; ++i) {
            float xa = (world.f_46441_.m_188501_() - 0.5f) / 2.0f;
            float ya = 0.25f + (0.5f + world.f_46441_.m_188501_() * 0.25f) * flow / 800.0f;
            float za = (world.f_46441_.m_188501_() - 0.5f) / 2.0f;
            float rx = (world.f_46441_.m_188501_() - 0.5f) * 0.5f;
            float rz = (world.f_46441_.m_188501_() - 0.5f) * 0.5f;
            double x = (double)pos.m_123341_() + 0.5 + (double)rx;
            double y = (float)pos.m_123342_() + yOffset;
            double z = (double)pos.m_123343_() + 0.5 + (double)rz;
            world.m_7106_((ParticleOptions)new FluidParticleData(fluid), x, y, z, (double)xa, (double)ya, (double)za);
        }
    }

    @Override
    public Level getClientWorld() {
        return MCUtil.getLevel();
    }

    @Override
    public Player getClientPlayer() {
        return MCUtil.getPlayer();
    }

    @Override
    public void handleEntitySound(SoundEvent soundEvent, Entity entity, boolean active, float volume, float pitch) {
    }

    @Override
    public void handleTileSound(SoundEvent soundEvent, BlockEntity te, boolean active, float volume, float pitch) {
    }

    public void setupManualPages() {
        ClientProxy.handleReservoirManual(ResourceUtils.ip("reservoir"), 0);
        ClientProxy.flarestack(ResourceUtils.ip("flarestack"), 12);
    }

    private static void flarestack(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.readFromFile(location);
        builder.appendText(() -> {
            ArrayList<Component[]> list = new ArrayList<Component[]>();
            for (TagKey<Fluid> tag : FlarestackHandler.getSet()) {
                for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
                    if (!fluid.m_205067_(tag)) continue;
                    Component[] entry = new Component[]{Component.m_237119_(), new FluidStack(fluid, 1).getDisplayName()};
                    list.add(entry);
                }
            }
            StringBuilder additionalText = new StringBuilder();
            ArrayList<ManualEntry.SpecialElementData> newElements = new ArrayList<ManualEntry.SpecialElementData>();
            int nextLine = 0;
            int page = 0;
            while (nextLine < list.size()) {
                int linesOnPage = page == 0 ? 12 : 14;
                int endIndex = Math.min(nextLine + linesOnPage, list.size());
                List onPage = list.subList(nextLine, endIndex);
                nextLine = endIndex;
                String key = "flarestack_table" + page;
                additionalText.append("<&").append(key).append(">");
                newElements.add(new ManualEntry.SpecialElementData(key, 0, (SpecialManualElement)new ManualElementTable(man, (Component[][])onPage.toArray(x$0 -> new Component[x$0][]), false)));
                ++page;
            }
            return Pair.of((Object)additionalText.toString(), newElements);
        });
        man.addEntry(man.getRoot().getOrCreateSubnode((Comparable)ResourceUtils.ip("petroleum")), builder.create(), priority);
    }

    private static void handleReservoirManual(ResourceLocation location, int priority) {
        ManualInstance man = ManualHelper.getManual();
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(man);
        builder.setContent(ClientProxy::createContent);
        builder.setLocation(location);
        man.addEntry(man.getRoot().addNewSubnode((Comparable)ResourceUtils.ip("petroleum"), 100), builder.create(), priority);
    }

    protected static ManualEntry.EntryData createContent() {
        String tString;
        ArrayList<ManualEntry.SpecialElementData> itemList = new ArrayList<ManualEntry.SpecialElementData>();
        StringBuilder contentBuilder = new StringBuilder();
        for (int i = 0; i < 5 && !I18n.m_118938_((String)(tString = "ie.manual.entry.reservoirs.oil" + i), (Object[])new Object[0]).equals(tString); ++i) {
            contentBuilder.append(I18n.m_118938_((String)tString, (Object[])new Object[0]));
        }
        ClientProxy.createReservoirPages(contentBuilder, itemList);
        String translatedTitle = I18n.m_118938_((String)"ie.manual.entry.reservoirs.title", (Object[])new Object[0]);
        String tanslatedSubtext = I18n.m_118938_((String)"ie.manual.entry.reservoirs.subtitle", (Object[])new Object[0]);
        String formattedContent = contentBuilder.toString().replaceAll("\r\n|\r|\n", "\n");
        return new ManualEntry.EntryData(translatedTitle, tanslatedSubtext, formattedContent, itemList);
    }

    private static void createReservoirPages(StringBuilder contentBuilder, ArrayList<ManualEntry.SpecialElementData> itemList) {
        ReservoirType[] reservoirs = ReservoirType.map.values().toArray(new ReservoirType[0]);
        for (int i = 0; i < reservoirs.length; ++i) {
            StringBuilder strBuilder;
            char c;
            ReservoirType reservoir = reservoirs[i];
            ImmersivePetroleum.log.debug("Creating entry for " + reservoir);
            String name = "desc.immersivepetroleum.info.reservoir." + reservoir.name;
            String localizedName = I18n.m_118938_((String)name, (Object[])new Object[0]);
            if (localizedName.equalsIgnoreCase(name)) {
                localizedName = reservoir.name;
            }
            boolean isVowel = (c = localizedName.toLowerCase().charAt(0)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
            String aOrAn = I18n.m_118938_((String)(isVowel ? "ie.manual.entry.reservoirs.vowel" : "ie.manual.entry.reservoirs.consonant"), (Object[])new Object[0]);
            String dimBWList = "";
            String bioBWList = "";
            if (reservoir.getDimensions().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getDimensions().forEach(rl -> strBuilder.append(strBuilder.length() > 0 ? ", " : "").append("<dim;").append(rl).append(">"));
                dimBWList = reservoir.getDimensions().isBlacklist() ? I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.invalid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn}) : I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.valid", (Object[])new Object[]{localizedName, strBuilder.toString(), aOrAn});
            } else {
                dimBWList = I18n.m_118938_((String)"ie.manual.entry.reservoirs.dim.any", (Object[])new Object[]{localizedName, aOrAn});
            }
            if (reservoir.getBiomes().hasEntries()) {
                strBuilder = new StringBuilder();
                reservoir.getBiomes().forEach(rl -> {
                    Biome bio = (Biome)ForgeRegistries.BIOMES.getValue(rl);
                    strBuilder.append(strBuilder.length() > 0 ? ", " : "").append((Object)(bio != null ? bio.toString() : rl));
                });
                bioBWList = reservoir.getBiomes().isBlacklist() ? I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.invalid", (Object[])new Object[]{strBuilder.toString()}) : I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.valid", (Object[])new Object[]{strBuilder.toString()});
            } else {
                bioBWList = I18n.m_118938_((String)"ie.manual.entry.reservoirs.bio.any", (Object[])new Object[0]);
            }
            String fluidName = "";
            Fluid fluid = reservoir.getFluid();
            if (fluid != null) {
                fluidName = new FluidStack(fluid, 1).getDisplayName().getString();
            }
            String repRate = "";
            if (reservoir.residual > 0) {
                repRate = reservoir.equilibrium > 0 ? I18n.m_118938_((String)"ie.manual.entry.reservoirs.replenish", (Object[])new Object[]{reservoir.residual, fluidName, Utils.fDecimal(reservoir.equilibrium / 1000)}) : I18n.m_118938_((String)"ie.manual.entry.reservoirs.replenish_depleted", (Object[])new Object[]{reservoir.residual, fluidName});
            }
            contentBuilder.append("<&").append(reservoir.m_6423_().toString()).append(">");
            contentBuilder.append(I18n.m_118938_((String)"ie.manual.entry.reservoirs.content", (Object[])new Object[]{dimBWList, fluidName, Utils.fDecimal(reservoir.minSize / 1000), Utils.fDecimal(reservoir.maxSize / 1000), repRate, bioBWList}));
            if (i < reservoirs.length - 1) {
                contentBuilder.append("<np>");
            }
            itemList.add(new ManualEntry.SpecialElementData(reservoir.m_6423_().toString(), 0, (SpecialManualElement)new ManualElementItem(ManualHelper.getManual(), new ItemStack[]{new ItemStack((ItemLike)fluid.m_6859_())})));
        }
    }
}

