/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HighPressureRefineryRecipeBuilder
extends IEFinishedRecipe<HighPressureRefineryRecipeBuilder> {
    public static HighPressureRefineryRecipeBuilder builder(FluidStack fluidOutput, int energy, int time) {
        return new HighPressureRefineryRecipeBuilder().setTimeAndEnergy(time, energy).addResultFluid(fluidOutput);
    }

    protected HighPressureRefineryRecipeBuilder() {
        super((IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get());
    }

    public HighPressureRefineryRecipeBuilder addResultFluid(FluidStack fluid) {
        return (HighPressureRefineryRecipeBuilder)this.addFluid("result", fluid);
    }

    public HighPressureRefineryRecipeBuilder addInputFluid(FluidStack fluid) {
        return (HighPressureRefineryRecipeBuilder)this.addFluid("input", fluid);
    }

    public HighPressureRefineryRecipeBuilder addInputFluid(FluidTagInput fluid) {
        return (HighPressureRefineryRecipeBuilder)this.addFluidTag("input", fluid);
    }

    public HighPressureRefineryRecipeBuilder addInputFluid(TagKey<Fluid> fluid, int amount) {
        return (HighPressureRefineryRecipeBuilder)this.addFluidTag("input", fluid, amount);
    }

    public HighPressureRefineryRecipeBuilder addSecondaryInputFluid(FluidStack fluid) {
        return (HighPressureRefineryRecipeBuilder)this.addFluid("secondary_input", fluid);
    }

    public HighPressureRefineryRecipeBuilder addSecondaryInputFluid(FluidTagInput fluid) {
        return (HighPressureRefineryRecipeBuilder)this.addFluidTag("secondary_input", fluid);
    }

    public HighPressureRefineryRecipeBuilder addSecondaryInputFluid(TagKey<Fluid> fluid, int amount) {
        return (HighPressureRefineryRecipeBuilder)this.addFluidTag("secondary_input", fluid, amount);
    }

    public HighPressureRefineryRecipeBuilder addItemWithChance(ItemStack item, double chance) {
        return (HighPressureRefineryRecipeBuilder)this.addWriter(jsonObject -> jsonObject.add("secondary_result", (JsonElement)this.serializerItemStackWithChance(item, chance)));
    }

    protected HighPressureRefineryRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (HighPressureRefineryRecipeBuilder)((HighPressureRefineryRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }

    protected JsonObject serializerItemStackWithChance(ItemStack stack, double chance) {
        JsonObject itemJson = this.serializeItemStack(stack);
        itemJson.addProperty("chance", Double.toString(chance));
        return itemJson;
    }
}

