/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Objects;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CokerUnitRecipeBuilder
extends IEFinishedRecipe<CokerUnitRecipeBuilder> {
    public static CokerUnitRecipeBuilder builder(ItemStack output, TagKey<Fluid> outputFluid, int fluidOutAmount) {
        Objects.requireNonNull(output);
        if (output.m_41619_()) {
            throw new IllegalArgumentException("Input stack cannot be empty.");
        }
        return ((CokerUnitRecipeBuilder)new CokerUnitRecipeBuilder().addResult(output)).addOutputFluid(outputFluid, fluidOutAmount);
    }

    public static CokerUnitRecipeBuilder builder(ItemStack output, Fluid fluid, int amount) {
        Objects.requireNonNull(output);
        if (output.m_41619_()) {
            throw new IllegalArgumentException("Input stack cannot be empty.");
        }
        return ((CokerUnitRecipeBuilder)new CokerUnitRecipeBuilder().addResult(output)).addOutputFluid(fluid, amount);
    }

    private CokerUnitRecipeBuilder() {
        super((IERecipeSerializer)Serializers.COKER_SERIALIZER.get());
    }

    public CokerUnitRecipeBuilder addInputItem(TagKey<Item> item, int amount) {
        return (CokerUnitRecipeBuilder)this.addInput(new IngredientWithSize(item, amount));
    }

    public CokerUnitRecipeBuilder addInputFluid(TagKey<Fluid> fluidTag, int amount) {
        return (CokerUnitRecipeBuilder)this.addFluidTag("inputfluid", new FluidTagInput(fluidTag.f_203868_(), amount));
    }

    @Deprecated
    public CokerUnitRecipeBuilder addOutputFluid(TagKey<Fluid> fluidTag, int amount) {
        return (CokerUnitRecipeBuilder)this.addFluidTag("resultfluid", new FluidTagInput(fluidTag.f_203868_(), amount));
    }

    public CokerUnitRecipeBuilder addOutputFluid(Fluid fluid, int amount) {
        return (CokerUnitRecipeBuilder)this.addFluid("resultfluid", new FluidStack(fluid, amount));
    }

    public CokerUnitRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (CokerUnitRecipeBuilder)((CokerUnitRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }
}

