/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class ShaderBagItem
extends IEBaseItem
implements IEItemInterfaces.IColouredItem {
    @Nonnull
    private final Rarity rarity;

    public ShaderBagItem(Rarity rarity) {
        super(new Item.Properties());
        this.rarity = rarity;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.rarity.f_43022_.m_126665_();
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)("desc.immersiveengineering.info.shader.rarity." + this.rarity.name().toLowerCase(Locale.US))).m_130946_(" ").m_7220_(super.m_7626_(stack));
    }

    public String m_5524_() {
        return "item.immersiveengineering.shader_bag";
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.rarity;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && ShaderRegistry.totalWeight.containsKey(this.rarity)) {
            ResourceLocation shader = ShaderRegistry.getRandomShader(player.m_20148_(), player.m_217043_(), this.rarity, true);
            if (shader == null) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            ItemStack shaderItem = new ItemStack(IEItems.Misc.SHADER);
            ItemNBTHelper.putString(shaderItem, "shader_name", shader.toString());
            Rarity shaderRarity = ShaderRegistry.shaderRegistry.get(shader).getRarity();
            if (ShaderRegistry.sortedRarityMap.indexOf(shaderRarity) <= ShaderRegistry.sortedRarityMap.indexOf(Rarity.EPIC) && ShaderRegistry.sortedRarityMap.indexOf(this.rarity) >= ShaderRegistry.sortedRarityMap.indexOf(Rarity.COMMON)) {
                Utils.unlockIEAdvancement(player, "main/secret_luckofthedraw");
            }
            stack.m_41774_(1);
            if (stack.m_41613_() <= 0) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)shaderItem);
            }
            if (!player.m_150109_().m_36054_(shaderItem)) {
                player.m_7197_(shaderItem, false, true);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }
}

