/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.fluids.IEFluid;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.mixin.accessors.FlowingFluidAccess;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;

public class ConcreteFluid
extends IEFluid {
    boolean hasFlownInTick = false;

    public ConcreteFluid(IEFluids.FluidEntry entry) {
        super(entry);
    }

    protected boolean m_6685_() {
        return true;
    }

    @Override
    public int m_6718_(LevelReader p_205569_1_) {
        return 20;
    }

    public void m_6292_(Level world, BlockPos pos, FluidState state) {
        boolean mayDry;
        this.hasFlownInTick = false;
        super.m_6292_(world, pos, state);
        int timer = (Integer)state.m_61143_((Property)IEProperties.INT_32);
        int level = ConcreteFluid.m_76092_((FluidState)state);
        int quantaRemaining = 16 - level;
        boolean bl = mayDry = timer >= 31;
        if (this.m_7444_(state)) {
            for (Direction neighborSide : Direction.Plane.HORIZONTAL) {
                if (!world.m_8055_(pos.m_121945_(neighborSide)).m_60819_().m_76152_().m_6212_((Fluid)this)) continue;
                mayDry = false;
            }
        }
        if (mayDry) {
            IEBlocks.BlockEntry<IEBaseBlock> solidBlock = level >= 5 && level < 8 ? IEBlocks.TO_SLAB.get(IEBlocks.StoneDecoration.CONCRETE.getId()) : IEBlocks.StoneDecoration.CONCRETE;
            world.m_46597_(pos, solidBlock.get().m_49966_());
            for (LivingEntity living : world.m_45976_(LivingEntity.class, new AABB(pos, pos.m_7918_(1, 1, 1)))) {
                living.m_7292_(new MobEffectInstance((MobEffect)IEPotions.CONCRETE_FEET.get(), Integer.MAX_VALUE));
            }
        } else if (world.m_8055_(pos).m_60734_() == this.entry.getBlock()) {
            BlockState newState = (BlockState)world.m_8055_(pos).m_61124_((Property)IEProperties.INT_32, (Comparable)Integer.valueOf(Math.min(timer + 1, 31)));
            world.m_46597_(pos, newState);
        }
    }

    @Nonnull
    protected FluidState m_76035_(LevelReader worldIn, BlockPos pos, @Nonnull BlockState blockStateIn) {
        int maxNeighborLevel = 0;
        int correspondingTimer = 0;
        for (Direction neighborSide : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(neighborSide);
            BlockState neighborState = worldIn.m_8055_(neighborPos);
            FluidState fluidAtNeighbor = neighborState.m_60819_();
            if (!fluidAtNeighbor.m_76152_().m_6212_((Fluid)this) || !((FlowingFluidAccess)((Object)this)).callCanPassThroughWall(neighborSide, (BlockGetter)worldIn, pos, blockStateIn, neighborPos, neighborState)) continue;
            maxNeighborLevel = Math.max(maxNeighborLevel, fluidAtNeighbor.m_76186_());
            correspondingTimer = Math.max(correspondingTimer, (Integer)fluidAtNeighbor.m_61143_((Property)IEProperties.INT_32));
        }
        correspondingTimer = Math.min(correspondingTimer + 1, 31);
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = worldIn.m_8055_(abovePos);
        FluidState aboveFluid = aboveState.m_60819_();
        FluidState currFluid = blockStateIn.m_60819_();
        if (!aboveFluid.m_76178_() && aboveFluid.m_76152_().m_6212_((Fluid)this) && ((FlowingFluidAccess)((Object)this)).callCanPassThroughWall(Direction.UP, (BlockGetter)worldIn, pos, blockStateIn, abovePos, aboveState)) {
            return this.getFlowingFluidState(8, true, currFluid, Math.max(correspondingTimer, (Integer)aboveFluid.m_61143_((Property)IEProperties.INT_32)));
        }
        int newLevel = maxNeighborLevel - this.m_6713_(worldIn);
        if (newLevel <= 0) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.getFlowingFluidState(newLevel, false, currFluid, correspondingTimer);
    }

    public FluidState getFlowingFluidState(int level, boolean falling, FluidState currentState, int baseDecay) {
        FluidState baseState = super.m_75953_(level, falling);
        if (this.m_6212_(currentState.m_76152_())) {
            baseDecay = Math.max((Integer)currentState.m_61143_((Property)IEProperties.INT_32), baseDecay);
        }
        baseState = (FluidState)baseState.m_61124_((Property)IEProperties.INT_32, (Comparable)Integer.valueOf(baseDecay));
        return baseState;
    }

    protected void m_6364_(@Nonnull LevelAccessor worldIn, @Nonnull BlockPos pos, BlockState blockStateIn, Direction direction, @Nonnull FluidState fluidStateIn) {
        if (blockStateIn.m_60734_() instanceof LiquidBlockContainer) {
            ((LiquidBlockContainer)blockStateIn.m_60734_()).m_7361_(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.m_60795_()) {
                this.m_7456_(worldIn, pos, blockStateIn);
            }
            worldIn.m_7731_(pos, fluidStateIn.m_76188_(), 3);
        }
        this.hasFlownInTick = true;
    }

    public static class Flowing
    extends ConcreteFluid {
        public Flowing(IEFluids.FluidEntry entry) {
            super(entry);
            this.m_76142_((FluidState)((FluidState)this.m_76144_().m_61090_()).m_61124_((Property)f_75948_, (Comparable)Integer.valueOf(7)));
        }

        @Override
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }
    }
}

