/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.utils.IEGLShaders;
import blusunrize.immersiveengineering.client.utils.InvertingVertexBuffer;
import blusunrize.immersiveengineering.common.config.IEClientConfig;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import org.lwjgl.opengl.GL11;

public class VertexBufferHolder
implements IVertexBufferHolder {
    private static final Lazy<Boolean> HAS_OPTIFINE = Lazy.of(() -> {
        try {
            Class.forName("net.optifine.Config");
            IELogger.logger.warn("OptiFine detected! Automatically disabling VBOs, this will make windmills and some other objects render much less efficiently");
            return true;
        }
        catch (Exception x) {
            return false;
        }
    });
    private static final Map<RenderType, List<BufferedJob>> JOBS = new IdentityHashMap<RenderType, List<BufferedJob>>();
    private final ResettableLazy<VertexBuffer> buffer;
    private final IVertexBufferHolder.Renderer renderer;

    private static VertexBufferHolder forQuads(final NonNullSupplier<List<BakedQuad>> quads) {
        final ResettableLazy<List<BakedQuad>> cachedQuads = new ResettableLazy<List<BakedQuad>>(quads);
        return new VertexBufferHolder(new IVertexBufferHolder.Renderer(){

            @Override
            public void render(VertexConsumer builder, PoseStack transform, int light, int overlay) {
                for (BakedQuad quad : (List)quads.get()) {
                    builder.m_85987_(transform.m_85850_(), quad, 1.0f, 1.0f, 1.0f, light, overlay);
                }
            }

            @Override
            public void reset() {
                cachedQuads.reset();
            }
        });
    }

    private VertexBufferHolder(IVertexBufferHolder.Renderer renderer) {
        this.renderer = renderer;
        this.buffer = new ResettableLazy(() -> {
            VertexBuffer vb = new VertexBuffer();
            RenderSystem.m_157427_(IEGLShaders::getVboShader);
            Tesselator tes = Tesselator.m_85913_();
            BufferBuilder bb = tes.m_85915_();
            bb.m_166779_(VertexFormat.Mode.QUADS, BUFFER_FORMAT);
            this.renderer.render((VertexConsumer)bb, new PoseStack(), 0, 0);
            vb.m_85921_();
            vb.m_231221_(bb.m_231175_());
            VertexBuffer.m_85931_();
            return vb;
        }, VertexBuffer::close);
    }

    public static void addToAPI() {
        IVertexBufferHolder.CREATE.setValue(new IVertexBufferHolder.VertexBufferHolderFactory(){

            @Override
            public IVertexBufferHolder create(IVertexBufferHolder.Renderer renderer) {
                return new VertexBufferHolder(renderer);
            }

            @Override
            public IVertexBufferHolder apply(NonNullSupplier<List<BakedQuad>> quads) {
                return VertexBufferHolder.forQuads(quads);
            }
        });
    }

    @Override
    public void render(RenderType type, int light, int overlay, MultiBufferSource directOut, PoseStack transform, boolean inverted) {
        if (((Boolean)IEClientConfig.enableVBOs.get()).booleanValue() && !((Boolean)HAS_OPTIFINE.get()).booleanValue()) {
            JOBS.computeIfAbsent(type, t -> new ArrayList()).add(new BufferedJob(this, light, overlay, transform, inverted));
        } else {
            this.renderToBuilder(directOut.m_6299_(type), transform, light, overlay, inverted);
        }
    }

    @Override
    public void reset() {
        this.buffer.reset();
        this.renderer.reset();
    }

    private void renderToBuilder(VertexConsumer builder, PoseStack transform, int light, int overlay, boolean inverted) {
        if (inverted) {
            builder = new InvertingVertexBuffer(4, (VertexConsumer)builder);
        }
        this.renderer.render((VertexConsumer)builder, transform, light, overlay);
    }

    public static void afterTERRendering() {
        if (JOBS.isEmpty()) {
            return;
        }
        for (Map.Entry<RenderType, List<BufferedJob>> typeEntry : JOBS.entrySet()) {
            RenderType type = typeEntry.getKey();
            type.m_110185_();
            boolean inverted = false;
            for (BufferedJob job : typeEntry.getValue()) {
                if (job.inverted && !inverted) {
                    GL11.glCullFace((int)1028);
                } else if (!job.inverted && inverted) {
                    GL11.glCullFace((int)1029);
                }
                inverted = job.inverted;
                VertexBuffer buffer = job.buffer.buffer.get();
                buffer.m_85921_();
                ShaderInstance shader = IEGLShaders.getVboShader();
                RenderSystem.m_157427_(() -> shader);
                Objects.requireNonNull(shader.m_173348_("LightUV")).m_142326_(job.light & 0xFFFF, job.light >> 16 & 0xFFFF);
                Objects.requireNonNull(shader.m_173348_("OverlayUV")).m_142326_(job.overlay & 0xFFFF, job.overlay >> 16 & 0xFFFF);
                buffer.m_166867_(job.transform, RenderSystem.m_157192_(), shader);
            }
            if (inverted) {
                GL11.glCullFace((int)1029);
            }
            type.m_110188_();
        }
        VertexBuffer.m_85931_();
        JOBS.clear();
    }

    private static class BufferedJob {
        private final VertexBufferHolder buffer;
        private final int light;
        private final int overlay;
        private final Matrix4f transform;
        private final boolean inverted;

        private BufferedJob(VertexBufferHolder buffer, int light, int overlay, PoseStack transform, boolean inverted) {
            this.buffer = buffer;
            this.light = light;
            this.overlay = overlay;
            this.transform = transform.m_85850_().m_85861_();
            this.inverted = inverted;
        }
    }
}

