/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.impl;

import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltip;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoText;

public class WrappedTooltipEngine
implements ITooltipProvider {
    public long lastUpdateTime;
    private final BlockEntity tile;
    private final ITooltipTile ttt;
    protected long updateRate = 5L;

    public WrappedTooltipEngine(BlockEntity tile, ITooltipTile ttt) {
        this.tile = tile;
        this.ttt = ttt;
    }

    @Override
    public void addInformation(ITooltip tip) {
        ProgressBar[] bars;
        Player player = tip.getPlayer();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.ttt.getTextTooltip(tooltip, player);
        tooltip.stream().map(TooltipInfoText::new).forEach(t -> tip.add((IRenderableInfo)t).newLine());
        if (this.ttt.hasProgressBars(player) && (bars = this.ttt.getProgressBars(player)) != null) {
            for (ProgressBar bar : bars) {
                tip.add(new TooltipInfoProgressBar(bar)).newLine();
            }
        }
    }

    @Override
    public boolean isTooltipDirty() {
        return this.tile.m_58898_() && this.tile.m_58904_().m_46467_() - this.lastUpdateTime > this.updateRate;
    }

    @Override
    public void setTooltipDirty(boolean dirty) {
        if (!dirty && this.tile.m_58898_()) {
            this.lastUpdateTime = this.tile.m_58904_().m_46467_();
        }
    }
}

