/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.core.init.SourceTypesHL;
import org.zeith.hammerlib.util.java.Cast;

public class TileSourceType
implements IObjectSourceType {
    public IObjectSource<BlockEntity> readSource(CompoundTag tag) {
        return new TileSource(tag);
    }

    public static class TileSource
    implements IObjectSource<BlockEntity> {
        public final BlockPos pos;

        public TileSource(BlockPos pos) {
            this.pos = pos;
        }

        public TileSource(CompoundTag tag) {
            this.pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
        }

        @Override
        public CompoundTag writeSource() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            return tag;
        }

        @Override
        public IObjectSourceType getType() {
            return SourceTypesHL.TILE_TYPE;
        }

        @Override
        public Class<BlockEntity> getBaseType() {
            return BlockEntity.class;
        }

        @Override
        public BlockEntity get(Level world) {
            return Cast.cast(world.m_7702_(this.pos), BlockEntity.class);
        }
    }
}

