/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EmittersInit<T extends IEmitter, E extends Enum<?>>
extends RelatedUnitsInit<T, E> {
    protected final Map<EntityType<?>, T> entities = new ConcurrentHashMap();
    protected final Optional<Field> isRandomlyTicking;

    public EmittersInit(AbstractForgeMod mod, Class<E> builtIn) {
        super(mod, builtIn);
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(BlockBehaviour.class, (String)"f_60445_");
            field.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isRandomlyTicking = Optional.ofNullable(field);
    }

    @Override
    protected void clearAttachedStates() {
        this.entities.clear();
        super.clearAttachedStates();
    }

    @Override
    protected void attachToStates() {
        this.clearAttachedStates();
        this.streamAll().forEach(emitter -> {
            if (emitter.getType().isEntity()) {
                EntityType type;
                UnitId id = emitter.getRelatedId();
                if (AbstractForgeMod.isLoaded(id.getModId()) && (type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id.toResLoc())) != null) {
                    this.entities.put(type, emitter);
                }
            } else {
                this.attachToBlockStates(emitter);
                this.attachToItemStates(emitter);
                this.attachToFluids(emitter);
            }
        });
    }

    public Optional<T> get(Entity entity) {
        return Optional.ofNullable((IEmitter)this.entities.get(entity.m_6095_()));
    }

    public Optional<T> get(LevelReader reader, BlockPos pos) {
        BlockEntity tile;
        BlockState state;
        IEmitter emitter;
        if (reader.m_46805_(pos) && (emitter = (IEmitter)this.get(state = reader.m_8055_(pos)).orElse(null)) != null && emitter.isIdentified((INBTSerializable<CompoundTag>)(tile = reader.m_7702_(pos)))) {
            return Optional.of(emitter);
        }
        return Optional.empty();
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        this.streamAll().forEach(unit -> {
            unit.onPostInit();
            BlockStatesSet states = unit.getRelatedId().getAllMatchedBlockStates();
            if (states != null) {
                for (Block block : states.getBlocksWithAllStates()) {
                    if (block.m_49966_().m_60767_() == Material.f_76296_) continue;
                    this.setIsRandomlyTicking((BlockBehaviour)block);
                }
                for (BlockState state : states) {
                    if (state.m_60767_() == Material.f_76296_) continue;
                    this.setIsRandomlyTicking((BlockBehaviour)state.m_60734_());
                }
            }
        });
    }

    protected void setIsRandomlyTicking(BlockBehaviour block) {
        if (this.isRandomlyTicking.isPresent()) {
            try {
                this.isRandomlyTicking.get().set(block, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

