/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.google.common.collect.Lists;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.BladeSpan;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ComponentModelData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class ShaftSection {
    final RotorShaftState State;
    final ModelData ShaftModelData;
    final BladeSpan[] Blades;

    public static Builder builder(RotorShaftState state) {
        return new Builder(state);
    }

    private ShaftSection(RotorShaftState state, List<BladeSpan> blades) {
        this.State = state;
        this.ShaftModelData = ComponentModelData.from(state);
        this.Blades = blades.toArray(new BladeSpan[0]);
    }

    public static class Builder {
        private final RotorShaftState _state;
        private final List<BladeSpan> _blades;

        public ShaftSection build() {
            return new ShaftSection(this._state, this._blades);
        }

        public Builder addBlade(RotorBladeState state, short length, Direction direction) {
            this._blades.add(BladeSpan.from(state, length, direction));
            return this;
        }

        private Builder(RotorShaftState state) {
            this._state = state;
            this._blades = Lists.newArrayListWithCapacity((int)4);
        }
    }
}

