/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.model;

import com.google.common.collect.Lists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.ReprocessorPartType;
import it.zerono.mods.zerocore.lib.client.model.multiblock.CuboidPartVariantsModelBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;

public class ReprocessorModelBuilder
extends CuboidPartVariantsModelBuilder {
    public ReprocessorModelBuilder() {
        this("assembledplating");
    }

    protected ReprocessorModelBuilder(String templateName) {
        super(ReprocessorModelBuilder.getModelRL(templateName), true);
        this.build();
    }

    protected void build() {
        this.addBlockWithVariants(ReprocessorPartType.Casing, "casing", "casing_01_face", "casing_02_frame_ds", "casing_03_frame_de", "casing_04_frame_dn", "casing_05_frame_dw", "casing_06_frame_us", "casing_07_frame_ue", "casing_08_frame_un", "casing_09_frame_uw", "casing_10_frame_se", "casing_11_frame_ne", "casing_12_frame_nw", "casing_13_frame_sw", "casing_14_corner_dsw", "casing_15_corner_dse", "casing_16_corner_dne", "casing_17_corner_dnw", "casing_18_corner_usw", "casing_19_corner_use", "casing_20_corner_une", "casing_21_corner_unw");
        this.addBlockWithVariants(ReprocessorPartType.Controller, "controller", "controller_on", "controller_off");
        this.addBlockWithVariants(ReprocessorPartType.PowerPort, "powerport", new String[0]);
        this.addBlockWithVariants(ReprocessorPartType.FluidInjector, "fluidinjector", "fluidinjector_connected");
        this.addBlockWithVariants(ReprocessorPartType.OutputPort, "outputport", "outputport_connected");
    }

    protected void addBlockWithVariants(ReprocessorPartType partType, String blockCommonName, String ... additionalVariantsModelNames) {
        this.addBlock(partType.ordinal(), this.getBlockStateRL(blockCommonName), 0, false);
        this.addBlockVariants(partType, blockCommonName, additionalVariantsModelNames);
    }

    protected void addBlockVariants(ReprocessorPartType partType, String blockCommonName, String ... additionalVariantsModelNames) {
        ArrayList variants = Lists.newArrayListWithCapacity((int)(1 + additionalVariantsModelNames.length));
        variants.add(this.getBlockStateRL(blockCommonName));
        Arrays.stream(additionalVariantsModelNames).map(ReprocessorModelBuilder::getModelRL).collect(Collectors.toCollection(() -> variants));
        this.addModels(partType.ordinal(), variants);
    }

    protected ResourceLocation getBlockStateRL(String blockCommonName) {
        return this.getBlockStateRL(blockCommonName, "");
    }

    protected ResourceLocation getBlockStateRL(String blockCommonName, String blockStateVariant) {
        return new ModelResourceLocation(ExtremeReactors.newID("reprocessor" + blockCommonName), blockStateVariant);
    }

    protected static ResourceLocation getModelRL(String modelName) {
        return ExtremeReactors.newID("block/reprocessor/" + modelName);
    }
}

