/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.AbstractMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.NumberInput;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Static;
import it.zerono.mods.zerocore.lib.client.gui.control.TextInput;
import it.zerono.mods.zerocore.lib.client.gui.databind.BindingGroup;
import it.zerono.mods.zerocore.lib.client.gui.databind.IBinding;
import it.zerono.mods.zerocore.lib.client.gui.databind.MonoConsumerBinding;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class ReactorControlRodScreen
extends AbstractMultiblockScreen<MultiblockReactor, ReactorControlRodEntity, ModTileContainer<ReactorControlRodEntity>> {
    private final BindingGroup _bindings;
    private final TextInput _nameInput;
    private final NumberInput.IntNumberInput _insertionInput;

    public ReactorControlRodScreen(ModTileContainer<ReactorControlRodEntity> container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorControlRodScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorControlRodEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        this.ignoreCloseOnInventoryKey(true);
        this._bindings = new BindingGroup();
        this._nameInput = new TextInput((ModContainerScreen)this, "name");
        this._insertionInput = new NumberInput.IntNumberInput((ModContainerScreen)this, "insertion", 0, 100, 0);
    }

    @Override
    protected void onScreenCreate() {
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, ExtremeReactors.newID("reactor/part-controlrod"), 1);
        int panelWidth = this.getGuiWidth() - 26;
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)((VerticalLayoutEngine)new VerticalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setControlsSpacing(7)).setHorizontalMargin(13)).setVerticalMargin(8));
        Label l = new Label((ModContainerScreen)this, "nameLabel", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.name.label"));
        l.setHorizontalAlignment(HorizontalAlignment.Left);
        l.setDesiredDimension(DesiredDimension.Width, panelWidth);
        this.addControl((IControl)l);
        Panel p = new Panel((ModContainerScreen)this, "namePanel");
        p.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setVerticalAlignment(VerticalAlignment.Center)).setControlsSpacing(2)).setHorizontalMargin(0));
        p.setDesiredDimension(panelWidth, 18);
        Picture c = new Picture((ModContainerScreen)this, "p1", CommonIcons.LabelEdit.get());
        c.setDesiredDimension(16, 16);
        p.addControl((IControl)c);
        this._nameInput.setDesiredDimension(DesiredDimension.Height, 16);
        this.addBinding(ReactorControlRodEntity::getName, arg_0 -> ((TextInput)this._nameInput).setText(arg_0));
        p.addControl((IControl)this._nameInput);
        Button b = new Button((ModContainerScreen)this, "nameSet", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.name.set"));
        b.setDesiredDimension(40, 16);
        b.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.name.set.tooltip.line1")});
        b.Clicked.subscribe((button, mousebutton) -> this.sendSetName(this._nameInput.getText()));
        p.addControl((IControl)b);
        this.addControl((IControl)p);
        this.addControl((IControl)new Static((ModContainerScreen)this, panelWidth, 1).setColor(Colour.BLACK));
        l = new Label((ModContainerScreen)this, "insertionLabel", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.label"));
        l.setHorizontalAlignment(HorizontalAlignment.Left);
        l.setDesiredDimension(DesiredDimension.Width, panelWidth);
        this.addControl((IControl)l);
        p = new Panel((ModContainerScreen)this, "insertionPanel");
        p.setLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setHorizontalAlignment(HorizontalAlignment.Left)).setVerticalAlignment(VerticalAlignment.Center)).setControlsSpacing(2)).setHorizontalMargin(0));
        p.setDesiredDimension(panelWidth, 18);
        c = new Picture((ModContainerScreen)this, "p2", CommonIcons.ButtonSensorInputSetControlRod.get());
        c.setDesiredDimension(16, 16);
        p.addControl((IControl)c);
        this._insertionInput.setStep(1, 10);
        this._insertionInput.setDisplaySuffix("%");
        this._insertionInput.setHorizontalAlignment(HorizontalAlignment.Right);
        this._insertionInput.setDesiredDimension(42, 14);
        this._insertionInput.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line1").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line2"), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line3"), Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line4"), CodeHelper.TEXT_EMPTY_LINE, Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line5"), Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.input.tooltip.line6")});
        this.addBinding(ReactorControlRodEntity::getInsertionRatio, arg_0 -> ((NumberInput.IntNumberInput)this._insertionInput).setValue(arg_0));
        p.addControl((IControl)this._insertionInput);
        b = new Button((ModContainerScreen)this, "rodSet", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.set"));
        b.setDesiredDimension(67, 16);
        b.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.set.tooltip.line1"), Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.set.tooltip.line2")});
        b.Clicked.subscribe((button, mousebutton) -> this.sendSetInsertion(this._insertionInput.getAsInt(), false));
        p.addControl((IControl)b);
        b = new Button((ModContainerScreen)this, "rodSetAll", (Component)Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.setall"));
        b.setDesiredDimension(67, 16);
        b.setTooltips(new Component[]{Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.setall.tooltip.line1"), Component.m_237115_((String)"gui.bigreactors.reactor.controlrod.insertion.setall.tooltip.line2")});
        b.Clicked.subscribe((button, mousebutton) -> this.sendSetInsertion(this._insertionInput.getAsInt(), true));
        p.addControl((IControl)b);
        this.addControl((IControl)p);
    }

    @Override
    protected void onDataUpdated() {
        super.onDataUpdated();
        this._bindings.update();
    }

    public boolean m_6913_() {
        return true;
    }

    private <Value> void addBinding(Function<ReactorControlRodEntity, Value> supplier, Consumer<Value> consumer) {
        this._bindings.addBinding((IBinding)new MonoConsumerBinding((Object)((ReactorControlRodEntity)this.getTileEntity()), supplier, consumer));
    }

    private void sendSetInsertion(int insertion, boolean setAll) {
        CompoundTag data = new CompoundTag();
        data.m_128405_("v", Mth.m_14045_((int)insertion, (int)0, (int)100));
        data.m_128379_("all", setAll);
        this.sendCommandToServer(ReactorControlRodEntity.COMMAND_SET_INSERTION, data);
    }

    private void sendSetName(String name) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("name", name);
        this.sendCommandToServer(ReactorControlRodEntity.COMMAND_SET_NAME, data);
    }
}

