/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.api.reactor.Reaction;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantStack;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.data.nbt.IMergeableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IndexedStackContainer;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.LogicalSide;

public class FuelContainer
extends IndexedStackContainer<ReactantType, Reactant, ReactantStack>
implements IFuelContainer {
    private float _radiationFuelUsage = 0.0f;

    public FuelContainer() {
        super(0, true, 60, ReactantStack.ADAPTER, (Enum)ReactantType.Fuel, (Enum)ReactantType.Waste, (Enum[])new ReactantType[0]);
    }

    void reset() {
        this._radiationFuelUsage = 0.0f;
        this.voidFuel();
        this.voidWaste();
    }

    @Override
    public Optional<Reactant> getFuel() {
        return this.getContent(ReactantType.Fuel);
    }

    @Override
    public FuelProperties getFuelProperties() {
        return (FuelProperties)this.map(ReactantType.Fuel, Reactant::getFuelData, FuelProperties.INVALID);
    }

    @Override
    public Optional<Reactant> getWaste() {
        return this.getContent(ReactantType.Waste);
    }

    @Override
    public int getFuelAmount() {
        return this.getContentAmount(ReactantType.Fuel);
    }

    @Override
    public int getWasteAmount() {
        return this.getContentAmount(ReactantType.Waste);
    }

    public int insertFuel(Reactant reactant, int amount, OperationMode mode) {
        return amount <= 0 ? 0 : this.insert(ReactantType.Fuel, reactant, amount, mode);
    }

    public int insertFuel(ReactantStack stack, OperationMode mode) {
        return stack.isEmpty() ? 0 : this.insert(ReactantType.Fuel, stack, mode);
    }

    public int insertWaste(Reactant reactant, int amount, OperationMode mode) {
        return amount <= 0 ? 0 : this.insert(ReactantType.Waste, reactant, amount, mode);
    }

    public int voidFuel() {
        return ((ReactantStack)this.clear(ReactantType.Fuel)).getAmount();
    }

    public int voidFuel(int amount) {
        return this.voidReactant(ReactantType.Fuel, amount);
    }

    public int voidWaste() {
        return ((ReactantStack)this.clear(ReactantType.Waste)).getAmount();
    }

    public int voidWaste(int amount) {
        return this.voidReactant(ReactantType.Waste, amount);
    }

    public int voidReactant(ReactantType index, int amount) {
        return this.getContent(index).map(r -> ((ReactantStack)this.extract(index, r, amount, OperationMode.Execute)).getAmount()).orElse(0);
    }

    @Override
    public void onIrradiation(float fuelUsed) {
        if (Float.isInfinite(fuelUsed) || Float.isNaN(fuelUsed)) {
            return;
        }
        this._radiationFuelUsage += fuelUsed;
        if (this._radiationFuelUsage < 1.0f) {
            return;
        }
        int fuelToConvert = Math.min(this.getFuelAmount(), (int)this._radiationFuelUsage);
        if (fuelToConvert <= 0) {
            return;
        }
        this._radiationFuelUsage = Math.max(0.0f, this._radiationFuelUsage - (float)fuelToConvert);
        Optional<Reactant> fuelReactant = this.getFuel();
        if (fuelReactant.isPresent()) {
            this.voidFuel(fuelToConvert);
            Optional<Reactant> wasteReactant = this.getWaste();
            if (wasteReactant.isPresent()) {
                this.insertWaste(wasteReactant.get(), fuelToConvert, OperationMode.Execute);
            } else {
                wasteReactant = ReactionsRegistry.get(fuelReactant.get()).map(IMapping.Impl::getProduct);
                if (wasteReactant.isPresent()) {
                    this.insertWaste(wasteReactant.get(), fuelToConvert, OperationMode.Execute);
                } else {
                    Log.LOGGER.warn(Log.REACTOR, "Could not locate waste for reaction of fuel type {}: no waste will be produced", fuelReactant);
                }
            }
        } else {
            Log.LOGGER.warn(Log.REACTOR, "Attempting to use {} fuel and there's no fuel in the tank", (Object)fuelToConvert);
        }
    }

    @Override
    public float getFuelReactivity() {
        Optional<Reactant> reactant = this.getFuel();
        Optional<Float> reactivity = reactant.flatMap(ReactionsRegistry::get).map(Reaction::getReactivity);
        if (!reactivity.isPresent()) {
            Log.LOGGER.warn(Log.REACTOR, "Could not locate reaction data for reactant type {}; using default value for reactivity", reactant.isPresent() ? reactant.get() : "<UNKNOWN>");
        }
        return reactivity.orElse(Float.valueOf(1.05f)).floatValue();
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.m_128441_("radiationFuelUsage")) {
            this._radiationFuelUsage = data.m_128457_("radiationFuelUsage");
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.m_128350_("radiationFuelUsage", this._radiationFuelUsage);
        return data;
    }

    public void syncDataFrom(IMergeableEntity other) {
        if (other instanceof FuelContainer) {
            this._radiationFuelUsage = Math.max(this._radiationFuelUsage, ((FuelContainer)other)._radiationFuelUsage);
        }
        super.syncDataFrom(other);
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.addUnlocalized("Radiation fuel usage: %1$.4f", new Object[]{Float.valueOf(this._radiationFuelUsage)});
    }

    public String toString() {
        return "Radiation Fuel Usage: " + this._radiationFuelUsage + "\n" + super.toString();
    }
}

