/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.datagen.recipes.AbstractRecipeGenerator;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class TurbineRecipeGenerator
extends AbstractRecipeGenerator {
    public TurbineRecipeGenerator(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String m_6055_() {
        return "Extreme Reactors 2 Turbine recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> c) {
        TurbineVariant variant = TurbineVariant.Basic;
        RegistryObject<BlockItem> casing = Content.Items.TURBINE_CASING_BASIC;
        TagKey core = Tags.Items.STORAGE_BLOCKS_REDSTONE;
        TagKey metal = Tags.Items.INGOTS_IRON;
        TagKey alternativeMetal = null;
        this.turbineCasing(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CASING_BASIC, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineGlass(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_GLASS_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.turbineController(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CONTROLLER_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.turbinePowerTap(c, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_PASSIVE_BASIC, (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_BASIC, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.turbineFluidPort(c, variant, "forge", (Supplier<? extends ItemLike>)Content.Items.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC, (Supplier<? extends ItemLike>)Content.Items.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.turbineBlade(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORBLADE_BASIC, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineShaft(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORSHAFT_BASIC, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineBearing(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORBEARING_BASIC, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineRedstonePort(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_REDSTONEPORT_BASIC, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:turbine", TurbineRecipeGenerator::turbineRecipeName, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CHARGINGPORT_FE_BASIC, (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_BASIC, (ItemLike)Items.f_42525_, (ItemLike)Items.f_42451_);
        this.turbineCasingRecycle(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CASING_BASIC, ContentTags.Items.USING_TURBINE_CASING_BASIC, (Supplier<? extends ItemLike>)Content.Items.TURBINE_GLASS_BASIC);
        variant = TurbineVariant.Reinforced;
        casing = Content.Items.TURBINE_CASING_REINFORCED;
        core = Tags.Items.STORAGE_BLOCKS_IRON;
        metal = TAG_INGOTS_STEEL;
        alternativeMetal = Tags.Items.STORAGE_BLOCKS_IRON;
        this.turbineCasing(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CASING_REINFORCED, (TagKey<Item>)core, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineCasingUpgrade(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CASING_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineGlass(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_GLASS_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.GLASS);
        this.turbineController(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CONTROLLER_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.turbinePowerTap(c, variant, "fe", (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42153_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42451_));
        this.turbineFluidPort(c, variant, "forge", (Supplier<? extends ItemLike>)Content.Items.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED, (Supplier<? extends ItemLike>)casing, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42448_), (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42447_));
        this.turbineComputerPort(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_COMPUTERPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineBlade(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORBLADE_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineShaft(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORSHAFT_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineBearing(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_ROTORBEARING_REINFORCED, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal);
        this.turbineRedstonePort(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_REDSTONEPORT_REINFORCED, (Supplier<? extends ItemLike>)casing, (TagKey<Item>)metal, (TagKey<Item>)alternativeMetal, (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.generatorChargingPort(c, variant, "chargingfe", "bigreactors:turbine", TurbineRecipeGenerator::turbineRecipeName, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CHARGINGPORT_FE_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, (ItemLike)Items.f_42054_, (ItemLike)Items.f_42153_);
        this.turbineCasingRecycle(c, variant, (Supplier<? extends ItemLike>)Content.Items.TURBINE_CASING_REINFORCED, ContentTags.Items.USING_TURBINE_CASING_REINFORCED, (Supplier<? extends ItemLike>)Content.Items.TURBINE_GLASS_REINFORCED);
    }

    private void turbineCasing(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> core, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_206416_(Character.valueOf('C'), core).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_CYANITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineCasingUpgrade(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_upgrade"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "casing_upgrade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_126127_(Character.valueOf('C'), (ItemLike)Content.Blocks.TURBINE_CASING_BASIC.get()).m_206416_(Character.valueOf('G'), ContentTags.Items.INGOTS_CYANITE).m_126130_("IGI").m_126130_("GCG").m_126130_("IGI").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)((ItemLike)Content.Blocks.TURBINE_CASING_BASIC.get()))));
    }

    private void turbineCasingRecycle(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> casingResult, TagKey<Item> casingSourceTag, Supplier<? extends ItemLike> glassSourceItem) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)casingResult.get(), (int)1).m_126209_(glassSourceItem.get()).m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)glassSourceItem.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "casing_recycle_glass"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)casingResult.get(), (int)4).m_206419_(casingSourceTag).m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_(casingSourceTag)).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "casing_recycle"));
    }

    private void turbineGlass(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> glass) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result.get()).m_126127_(Character.valueOf('C'), casing.get()).m_206416_(Character.valueOf('G'), glass).m_126130_("GCG").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "glass"));
    }

    private void turbineController(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> diamond) {
        ShapedRecipeBuilder.m_126116_((ItemLike)result.get()).m_126127_(Character.valueOf('C'), casing.get()).m_206416_(Character.valueOf('Y'), ContentTags.Items.BLOCKS_CYANITE).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('D'), diamond).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42351_).m_126130_("CXC").m_126130_("YDY").m_126130_("CRC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_(ContentTags.Items.BLOCKS_CYANITE)).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "controller"));
    }

    private void turbinePowerTap(Consumer<FinishedRecipe> c, TurbineVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> energyBig, Supplier<? extends ItemLike> energySmall) {
        ShapedRecipeBuilder.m_126116_((ItemLike)passiveResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)energySmall.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "passivetap_" + name));
        ShapedRecipeBuilder.m_126116_((ItemLike)activeResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), energyBig.get()).m_126127_(Character.valueOf('S'), energySmall.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)energyBig.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "activetap_" + name));
    }

    private void turbineComputerPort(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "computerport"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "computerport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('G'), Tags.Items.STORAGE_BLOCKS_GOLD).m_206416_(Character.valueOf('Z'), Tags.Items.GEMS_LAPIS).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private void turbineFluidPort(Consumer<FinishedRecipe> c, TurbineVariant variant, String name, Supplier<? extends ItemLike> passiveResult, Supplier<? extends ItemLike> activeResult, Supplier<? extends ItemLike> casing, Supplier<? extends ItemLike> lava, Supplier<? extends ItemLike> water) {
        ShapedRecipeBuilder.m_126116_((ItemLike)passiveResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CSC").m_126130_("SBS").m_126130_("CSC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)water.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "passivefluidport_" + name));
        ShapedRecipeBuilder.m_126116_((ItemLike)activeResult.get()).m_126127_(Character.valueOf('C'), casing.get()).m_126127_(Character.valueOf('B'), lava.get()).m_126127_(Character.valueOf('S'), water.get()).m_126130_("CBC").m_126130_("BSB").m_126130_("CBC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)casing.get())).m_126132_("has_item2", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)lava.get())).m_126140_(c, TurbineRecipeGenerator.turbineRecipeName(variant, "activefluidport_" + name));
    }

    private void turbineBlade(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "blade"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "blade_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_206416_(Character.valueOf('C'), ContentTags.Items.INGOTS_CYANITE).m_126130_("ICI").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineShaft(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "shaft"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "shaft_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_206416_(Character.valueOf('C'), ContentTags.Items.INGOTS_CYANITE).m_126130_(" I ").m_126130_("ICI").m_126130_(" I ").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_(ContentTags.Items.INGOTS_CYANITE)));
    }

    private void turbineBearing(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "bearing"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "bearing_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_206416_(Character.valueOf('I'), metalTag).m_126127_(Character.valueOf('R'), (ItemLike)Blocks.f_50330_).m_206416_(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_IRON).m_126130_("IRI").m_126130_("B B").m_126130_("IRI").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_206406_((TagKey)Tags.Items.STORAGE_BLOCKS_IRON)));
    }

    private void turbineRedstonePort(Consumer<FinishedRecipe> c, TurbineVariant variant, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> casing, TagKey<Item> metal, @Nullable TagKey<Item> alternativeMetal, TagKey<Item> gold) {
        TurbineRecipeGenerator.recipeWithAlternativeTag(c, (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "redstoneport"), (ResourceLocation)TurbineRecipeGenerator.turbineRecipeName(variant, "redstoneport_alt"), metal, alternativeMetal, metalTag -> ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)result.get())).m_126127_(Character.valueOf('C'), (ItemLike)casing.get()).m_206416_(Character.valueOf('M'), metalTag).m_206416_(Character.valueOf('G'), gold).m_126127_(Character.valueOf('Z'), (ItemLike)Items.f_42351_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42350_).m_126130_("CZC").m_126130_("MGM").m_126130_("CXC").m_126145_("bigreactors:turbine").m_126132_("has_item", (CriterionTriggerInstance)TurbineRecipeGenerator.m_125977_((ItemLike)((ItemLike)casing.get()))));
    }

    private static ResourceLocation turbineRecipeName(IMultiblockGeneratorVariant variant, String name) {
        return ExtremeReactors.newID("turbine/" + variant.getName() + "/" + name);
    }

    private static ResourceLocation turbineRecipeName(IMultiblockGeneratorVariant variant, String name, TagKey<Item> tag) {
        return ExtremeReactors.newID("turbine/" + variant.getName() + "/" + name + "_" + tag.f_203868_().m_135815_().replace('/', '_'));
    }
}

