/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors;

import com.mojang.brigadier.CommandDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.config.conditions.ConfigCondition;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.command.ExtremeReactorsCommand;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.network.UpdateClientsFuelRodsLayout;
import it.zerono.mods.extremereactors.proxy.IProxy;
import it.zerono.mods.extremereactors.proxy.ProxySafeReferent;
import it.zerono.mods.zerocore.lib.init.IModInitializationHandler;
import it.zerono.mods.zerocore.lib.network.IModMessage;
import it.zerono.mods.zerocore.lib.network.NetworkHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="bigreactors")
public class ExtremeReactors
implements IModInitializationHandler {
    public static final String MOD_ID = "bigreactors";
    public static final String MOD_NAME = "Extreme Reactors 2";
    private static ExtremeReactors s_instance;
    private static IProxy s_proxy;
    private final NetworkHandler _network;

    public static ExtremeReactors getInstance() {
        return s_instance;
    }

    public static IProxy getProxy() {
        return s_proxy;
    }

    public static ResourceLocation newID(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public ExtremeReactors() {
        s_instance = this;
        this._network = new NetworkHandler(ExtremeReactors.newID("network"), "1");
        Config.initialize();
        Content.initialize();
        s_proxy = (IProxy)DistExecutor.safeRunForDist(() -> ProxySafeReferent::client, () -> ProxySafeReferent::server);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::onCommonInit);
        modBus.addListener(this::onInterModProcess);
        modBus.addListener(this::onRegisterRecipeSerializer);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
    }

    public void onCommonInit(FMLCommonSetupEvent event) {
        this._network.registerMessage(UpdateClientsFuelRodsLayout.class, UpdateClientsFuelRodsLayout::new);
    }

    public void onInterModProcess(InterModProcessEvent event) {
        this.imcProcessAPIMessages(event, "reactant-register");
        this.imcProcessAPIMessages(event, "mapping-register");
        this.imcProcessAPIMessages(event, "reaction-register");
        this.imcProcessAPIMessages(event, "reaction-remove");
        this.imcProcessAPIMessages(event, "mapping-remove");
        this.imcProcessAPIMessages(event, "reactant-remove");
        this.imcProcessAPIMessages(event, "moderator-s-register");
        this.imcProcessAPIMessages(event, "moderator-f-register");
        this.imcProcessAPIMessages(event, "moderator-s-remove");
        this.imcProcessAPIMessages(event, "moderator-f-remove");
        this.imcProcessAPIMessages(event, "fluid-register");
        this.imcProcessAPIMessages(event, "fluid-mapping-register");
        this.imcProcessAPIMessages(event, "fluid-transition-register");
        this.imcProcessAPIMessages(event, "fluid-transition-remove");
        this.imcProcessAPIMessages(event, "fluid-mapping-remove");
        this.imcProcessAPIMessages(event, "fluid-remove");
        this.imcProcessAPIMessages(event, "coilmaterial-register");
        this.imcProcessAPIMessages(event, "coilmaterial-remove");
        ApiWrapper.processFile();
    }

    public void onRegisterRecipeSerializer(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> CraftingHelper.register((IConditionSerializer)ConfigCondition.Serializer.INSTANCE));
    }

    public <T extends IModMessage> void sendPacket(T packet, Level world, BlockPos center, int radius) {
        this._network.sendToAllAround(packet, (double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_(), (double)radius, world.m_46472_());
    }

    private void imcProcessAPIMessages(InterModProcessEvent event, String method) {
        event.getIMCStream(method::equals).map(imc -> (Runnable)imc.messageSupplier().get()).forEach(Runnable::run);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        ExtremeReactorsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

