/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.tileentity.BaseTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.FluxAlternatorContainer;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class FluxAlternatorTileEntity
extends BaseTileEntity
implements MenuProvider {
    private final EnergyStorage energy = new EnergyStorage(((Integer)ModConfigs.FLUX_ALTERNATOR_POWER_CAPACITY.get()).intValue());
    private int oldEnergy;

    public FluxAlternatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FLUX_ALTERNATOR.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.extendedcrafting.flux_alternator").build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return FluxAlternatorContainer.create(windowId, playerInventory, this.m_58899_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(this::getEnergy));
        }
        return super.getCapability(cap, side);
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FluxAlternatorTileEntity tile) {
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            tile.markDirtyAndDispatch();
        }
    }
}

