/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.init;

import com.blakebr0.extendedcrafting.crafting.condition.UltimateSingularityRecipeCondition;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.CompressorRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessEnderCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.UltimateSingularityRecipe;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public final class ModRecipeSerializers {
    public static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"extendedcrafting");
    public static final RegistryObject<RecipeSerializer<?>> COMBINATION = ModRecipeSerializers.register("combination", CombinationRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPED_TABLE = ModRecipeSerializers.register("shaped_table", ShapedTableRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPELESS_TABLE = ModRecipeSerializers.register("shapeless_table", ShapelessTableRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> COMPRESSOR = ModRecipeSerializers.register("compressor", CompressorRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPED_ENDER_CRAFTER = ModRecipeSerializers.register("shaped_ender_crafter", ShapedEnderCrafterRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPELESS_ENDER_CRAFTER = ModRecipeSerializers.register("shapeless_ender_crafter", ShapelessEnderCrafterRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPED_FLUX_CRAFTER = ModRecipeSerializers.register("shaped_flux_crafter", ShapedFluxCrafterRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> SHAPELESS_FLUX_CRAFTER = ModRecipeSerializers.register("shapeless_flux_crafter", ShapelessFluxCrafterRecipe.Serializer::new);
    public static final RegistryObject<RecipeSerializer<?>> ULTIMATE_SINGULARITY = ModRecipeSerializers.register("ultimate_singularity", UltimateSingularityRecipe.Serializer::new);

    @SubscribeEvent
    public void onRegisterSerializers(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, (T registry) -> CraftingHelper.register((IConditionSerializer)UltimateSingularityRecipeCondition.Serializer.INSTANCE));
    }

    private static RegistryObject<RecipeSerializer<?>> register(String name, Supplier<RecipeSerializer<?>> serializer) {
        return REGISTRY.register(name, serializer);
    }
}

