/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.util.TriFunction;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ShapedTableRecipe
implements ISpecialRecipe,
ITableRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int width;
    private final int height;
    private final int tier;
    private TriFunction<Integer, Integer, ItemStack, ItemStack> transformer;

    public ShapedTableRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output) {
        this(recipeId, width, height, inputs, output, 0);
    }

    public ShapedTableRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output, int tier) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.width = width;
        this.height = height;
        this.tier = tier;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        if (this.tier != 0 && this.tier != this.getTierFromGridSize(inventory)) {
            return false;
        }
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i <= size - this.width; ++i) {
            for (int j = 0; j <= size - this.height; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_TABLE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.TABLE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public NonNullList<ItemStack> getRemainingItems(IItemHandler inventory) {
        if (this.transformer != null) {
            NonNullList remaining = NonNullList.m_122780_((int)inventory.getSlots(), (Object)ItemStack.f_41583_);
            int size = (int)Math.sqrt(inventory.getSlots());
            block0: for (int i = 0; i <= size - this.width; ++i) {
                for (int j = 0; j <= size - this.height; ++j) {
                    ItemStack stack;
                    int index;
                    int l;
                    int k;
                    if (this.checkMatch(inventory, i, j, true)) {
                        for (k = 0; k < this.height; ++k) {
                            for (l = 0; l < this.width; ++l) {
                                index = this.width - 1 - l + i + (k + j) * size;
                                stack = inventory.getStackInSlot(index);
                                remaining.set(index, (Object)((ItemStack)this.transformer.apply((Object)l, (Object)k, (Object)stack)));
                            }
                        }
                        continue block0;
                    }
                    if (!this.checkMatch(inventory, i, j, false)) continue;
                    for (k = 0; k < this.height; ++k) {
                        for (l = 0; l < this.width; ++l) {
                            index = l + i + (k + j) * size;
                            stack = inventory.getStackInSlot(index);
                            remaining.set(index, (Object)((ItemStack)this.transformer.apply((Object)l, (Object)k, (Object)stack)));
                        }
                    }
                    continue block0;
                }
            }
            return remaining;
        }
        return super.getRemainingItems(inventory);
    }

    @Override
    public int getTier() {
        if (this.tier > 0) {
            return this.tier;
        }
        return this.width < 4 && this.height < 4 ? 1 : (this.width < 6 && this.height < 6 ? 2 : (this.width < 8 && this.height < 8 ? 3 : 4));
    }

    @Override
    public boolean hasRequiredTier() {
        return this.tier > 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private int getTierFromGridSize(IItemHandler inv) {
        int size = inv.getSlots();
        return size < 10 ? 1 : (size < 26 ? 2 : (size < 50 ? 3 : 4));
    }

    private boolean checkMatch(IItemHandler inventory, int x, int y, boolean mirror) {
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirror ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inventory.getStackInSlot(i + j * size))) continue;
                return false;
            }
        }
        return true;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public void setTransformer(TriFunction<Integer, Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedTableRecipe> {
        public ShapedTableRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Map map = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedTableRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.m_44202_((String[])pattern, (Map)map, (int)width, (int)height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int tier = GsonHelper.m_13824_((JsonObject)json, (String)"tier", (int)0);
            int size = tier * 2 + 1;
            if (tier != 0 && (width > size || height > size)) {
                throw new JsonSyntaxException("The pattern size is larger than the specified tier can support");
            }
            return new ShapedTableRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public ShapedTableRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int tier = buffer.m_130242_();
            return new ShapedTableRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, tier);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedTableRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.tier);
        }
    }
}

