/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ShapedFluxCrafterRecipe
implements ISpecialRecipe,
IFluxCrafterRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int width;
    private final int height;
    private final int powerRequired;
    private final int powerRate;

    public ShapedFluxCrafterRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output, int powerRequired) {
        this(recipeId, width, height, inputs, output, powerRequired, (Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get());
    }

    public ShapedFluxCrafterRecipe(ResourceLocation recipeId, int width, int height, NonNullList<Ingredient> inputs, ItemStack output, int powerRequired, int powerRate) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.output = output;
        this.width = width;
        this.height = height;
        this.powerRequired = powerRequired;
        this.powerRate = powerRate;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i <= size - this.width; ++i) {
            for (int j = 0; j <= size - this.height; ++j) {
                if (this.checkMatch(inventory, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.SHAPED_FLUX_CRAFTER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.FLUX_CRAFTER.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @Override
    public int getPowerRequired() {
        return this.powerRequired;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean checkMatch(IItemHandler inventory, int x, int y, boolean mirror) {
        int size = (int)Math.sqrt(inventory.getSlots());
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = mirror ? (Ingredient)this.inputs.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inventory.getStackInSlot(i + j * size))) continue;
                return false;
            }
        }
        return true;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedFluxCrafterRecipe> {
        public ShapedFluxCrafterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Map map = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedFluxCrafterRecipe.patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.m_44202_((String[])pattern, (Map)map, (int)width, (int)height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int powerRequired = GsonHelper.m_13927_((JsonObject)json, (String)"powerRequired");
            int powerRate = GsonHelper.m_13824_((JsonObject)json, (String)"powerRate", (int)((Integer)ModConfigs.FLUX_CRAFTER_POWER_RATE.get()));
            return new ShapedFluxCrafterRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, powerRequired, powerRate);
        }

        public ShapedFluxCrafterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int powerRequired = buffer.m_130242_();
            int powerRate = buffer.m_130242_();
            return new ShapedFluxCrafterRecipe(recipeId, width, height, (NonNullList<Ingredient>)inputs, output, powerRequired, powerRate);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedFluxCrafterRecipe recipe) {
            buffer.m_130130_(recipe.width);
            buffer.m_130130_(recipe.height);
            for (Ingredient ingredient : recipe.inputs) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.powerRequired);
            buffer.m_130130_(recipe.powerRate);
        }
    }
}

