/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.category.table;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.compat.jei.JeiCompat;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapedTableRecipe;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AdvancedTableCategory
implements IRecipeCategory<ITableRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("extendedcrafting", "textures/gui/jei/advanced_crafting.png");
    public static final RecipeType<ITableRecipe> RECIPE_TYPE = RecipeType.create((String)"extendedcrafting", (String)"advanced_crafting", ITableRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable required;

    public AdvancedTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 150, 90);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ADVANCED_TABLE.get()));
        this.required = helper.createDrawable(JeiCompat.ICONS, 0, 0, 15, 15);
    }

    public RecipeType<ITableRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.extendedcrafting.advanced_crafting").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ITableRecipe recipe, IRecipeSlotsView slots, PoseStack stack, double mouseX, double mouseY) {
        stack.m_85836_();
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        if (recipe.hasRequiredTier()) {
            this.required.draw(stack, shapeless ? 265 : 285, 0);
        }
        stack.m_85849_();
    }

    public List<Component> getTooltipStrings(ITableRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        boolean shapeless = recipe instanceof ShapelessTableRecipe;
        int sX = (shapeless ? 265 : 285) / 2;
        int sY = 0;
        if (recipe.hasRequiredTier() && mouseX > (double)(sX - 1) && mouseX < (double)(sX + 8) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            return List.of(ModTooltips.REQUIRES_TABLE.args(new Object[]{recipe.getTier()}).color(ChatFormatting.WHITE).build());
        }
        return List.of();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ITableRecipe recipe, IFocusGroup focuses) {
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_();
        if (recipe instanceof ShapedTableRecipe) {
            ShapedTableRecipe shaped = (ShapedTableRecipe)recipe;
            int heightOffset = Math.floorDiv(5 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(5 - shaped.getWidth(), 2);
            int stackIndex = 0;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 1, i * 18 + 1);
                    if (i < heightOffset || i >= shaped.getHeight() + heightOffset || j < widthOffset || j >= shaped.getWidth() + widthOffset) continue;
                    slot.addIngredients((Ingredient)inputs.get(stackIndex++));
                }
            }
        } else if (recipe instanceof ShapelessTableRecipe) {
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    int index = j + i * 5;
                    if (index >= inputs.size()) continue;
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 1, i * 18 + 1).addIngredients((Ingredient)inputs.get(index));
                }
            }
            builder.setShapeless();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 36).addItemStack(output);
        builder.moveRecipeTransferButton(138, 78);
    }
}

