/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.extendedcrafting.CombinationCrafting")
@ZenRegister
public final class CombinationCrafting {
    @ZenCodeType.Method
    public static void addRecipe(final String id, final IItemStack output, final int cost, final IIngredient[] inputs) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                CombinationRecipe recipe = new CombinationRecipe(new ResourceLocation("crafttweaker", id), CombinationCrafting.toIngredientsList(inputs), output.getInternal(), cost);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Combination Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void addRecipe(final String id, final IItemStack output, final int cost, final IIngredient[] inputs, final int perTick) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                CombinationRecipe recipe = new CombinationRecipe(new ResourceLocation("crafttweaker", id), CombinationCrafting.toIngredientsList(inputs), output.getInternal(), cost, perTick);
                RecipeHelper.addRecipe((Recipe)recipe);
            }

            public String describe() {
                return "Adding Combination Crafting recipe for " + output.getCommandString();
            }
        });
    }

    @ZenCodeType.Method
    public static void remove(final IItemStack stack) {
        CraftTweakerAPI.apply((IAction)new IRuntimeAction(){

            public void apply() {
                List<ResourceLocation> recipes = ((Map)RecipeHelper.getRecipes().getOrDefault(ModRecipeTypes.COMBINATION.get(), new HashMap())).values().stream().filter(r -> r.m_8043_().m_41656_(stack.getInternal())).map(Recipe::m_6423_).toList();
                recipes.forEach(r -> ((Map)RecipeHelper.getRecipes().get(ModRecipeTypes.COMBINATION.get())).remove(r));
            }

            public String describe() {
                return "Removing Combination Crafting recipes for " + stack.getCommandString();
            }
        });
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... ingredients) {
        return Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_));
    }
}

