/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen.button;

import com.blakebr0.cucumber.client.screen.button.IconButton;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.network.NetworkHandler;
import com.blakebr0.extendedcrafting.network.message.SaveRecipeMessage;
import com.blakebr0.extendedcrafting.network.message.SelectRecipeMessage;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class RecipeSelectButton
extends IconButton {
    private static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("extendedcrafting", "textures/gui/widgets.png");
    private final int index;
    private final TableRecipeStorage recipeStorage;

    public RecipeSelectButton(int x, int y, BlockPos pos, int index, TableRecipeStorage recipeStorage, Button.OnTooltip onTooltip) {
        this(x, y, pos, index, 0, recipeStorage, onTooltip);
    }

    public RecipeSelectButton(int x, int y, BlockPos pos, int index, int textureY, TableRecipeStorage recipeStorage, Button.OnTooltip onTooltip) {
        super(x, y, 11, 11, index * 11, textureY, WIDGETS_LOCATION, button -> RecipeSelectButton.onPress(pos, index), onTooltip);
        this.index = index;
        this.recipeStorage = recipeStorage;
    }

    protected int m_7202_(boolean isHovered) {
        return isHovered ? 2 : (this.isSelected() ? 0 : 1);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSelected() {
        return this.recipeStorage.getSelected() == this.index;
    }

    private static void onPress(BlockPos pos, int index) {
        if (Screen.m_96638_()) {
            NetworkHandler.INSTANCE.sendToServer((Object)new SaveRecipeMessage(pos, index));
        } else {
            NetworkHandler.INSTANCE.sendToServer((Object)new SelectRecipeMessage(pos, index));
        }
    }
}

