/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.client.screen.button.ToggleTableRunningButton;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.IEnergyStorage;

public class UltimateAutoTableScreen
extends BaseContainerScreen<UltimateAutoTableContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/ultimate_auto_table.png");
    private AutoTableTileEntity tile;

    public UltimateAutoTableScreen(UltimateAutoTableContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 254, 278, 512, 512);
    }

    public void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((UltimateAutoTableContainer)this.m_6262_()).getPos();
        this.m_142416_((GuiEventListener)new ToggleTableRunningButton(x + 226, y + 114, pos, this::isRunning));
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 210, y + 7, pos, 0, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 223, y + 7, pos, 1, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new RecipeSelectButton(x + 236, y + 7, pos, 2, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 59, (IEnergyStorage)this.tile.getEnergy(), (AbstractContainerScreen)this));
        }
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_7025_(stack, mouseX, mouseY);
        if (mouseX > x + 226 && mouseX < x + 239 && mouseY > y + 113 && mouseY < y + 129) {
            this.m_96602_(stack, (Component)ModTooltips.TOGGLE_AUTO_CRAFTING.color(ChatFormatting.WHITE).build(), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        this.f_96547_.m_92883_(stack, title, 26.0f, 6.0f, 0x404040);
        this.f_96547_.m_92889_(stack, this.f_169604_, 47.0f, (float)this.f_97727_ - 94.0f, 0x404040);
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.renderDefaultBg(stack, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.isRunning()) {
            int i2 = this.getProgressBarScaled();
            UltimateAutoTableScreen.m_93133_((PoseStack)stack, (int)(x + 225), (int)(y + 113), (float)272.0f, (float)0.0f, (int)13, (int)i2, (int)512, (int)512);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    int index = i * 9 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 27 + j * 18), (int)(y + 18 + i * 18), (ItemRenderer)this.f_96542_);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 225), (int)(y + 89), (ItemRenderer)this.f_96542_);
        }
    }

    private void onSelectButtonTooltip(Button button, PoseStack matrix, int mouseX, int mouseY) {
        int index = ((RecipeSelectButton)button).getIndex();
        boolean isSelected = ((RecipeSelectButton)button).isSelected();
        BaseItemStackHandler recipe = this.getRecipeInfo(index);
        if (recipe != null) {
            ArrayList tooltip;
            boolean hasRecipe;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::m_41619_);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new Component[]{Component.m_237113_((String)(output.m_41613_() + "x " + output.m_41786_().getString())), Component.m_237113_((String)""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(1, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                }
            } else {
                tooltip = Lists.newArrayList((Object[])new Component[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(0, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                    tooltip.add(1, Component.m_237113_((String)""));
                }
            }
            this.m_96597_(matrix, tooltip, mouseX, mouseY);
        }
    }

    private AutoTableTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((UltimateAutoTableContainer)this.m_6262_()).getPos())) instanceof AutoTableTileEntity) {
            AutoTableTileEntity table = (AutoTableTileEntity)tile;
            return table;
        }
        return null;
    }

    private boolean isRunning() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.isRunning();
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = this.getProgressRequired();
        return j != 0 && i != 0 ? i * 16 / j : 0;
    }
}

