/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.energy.IEnergyStorage;

public class CraftingCoreScreen
extends BaseContainerScreen<CraftingCoreContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("extendedcrafting", "textures/gui/crafting_core.png");
    private CraftingCoreTileEntity tile;

    public CraftingCoreScreen(CraftingCoreContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.m_142416_((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy(), (AbstractContainerScreen)this));
        }
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean isHoldingItem;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        boolean bl = isHoldingItem = !((CraftingCoreContainer)this.f_97732_).m_142621_().m_41619_() || this.m_7282_();
        if (!isHoldingItem && CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
            ItemStack output = this.getRecipeOutput();
            this.m_6057_(matrix, output, mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        String title = this.m_96636_().getString();
        this.f_96547_.m_92883_(matrix, title, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(title) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(matrix, this.f_169604_, 8.0f, (float)this.f_97727_ - 94.0f, 0x404040);
        matrix.m_85836_();
        matrix.m_85841_(0.75f, 0.75f, 0.75f);
        this.f_96547_.m_92883_(matrix, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.pedestals", (Object[])new Object[]{this.getPedestalCount()}), 36.0f, 36.0f, -1);
        if (!this.hasRecipe()) {
            this.f_96547_.m_92883_(matrix, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_recipe", (Object[])new Object[0]), 36.0f, 56.0f, -1);
        } else {
            this.f_96547_.m_92883_(matrix, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_cost", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRequired())}) + " FE", 36.0f, 56.0f, -1);
            this.f_96547_.m_92883_(matrix, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.power_rate", (Object[])new Object[]{CraftingCoreScreen.number((Object)this.getEnergyRate())}) + " FE/t", 36.0f, 66.0f, -1);
            if (this.getEnergyStored() < this.getEnergyRate()) {
                this.f_96547_.m_92883_(matrix, CraftingCoreScreen.text((String)"screen.extendedcrafting.crafting_core.no_power", (Object[])new Object[0]), 36.0f, 86.0f, -1);
            }
        }
        matrix.m_85849_();
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        super.renderDefaultBg(matrix, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            if (this.getProgress() > 0 && this.getEnergyRate() > 0) {
                int i2 = this.getProgressBarScaled();
                this.m_93228_(matrix, x + 116, y + 47, 194, 0, i2 + 1, 16);
            }
            ItemStack output = this.getRecipeOutput();
            this.drawItemStack(output, x + 148, y + 47);
            if (CraftingCoreScreen.isHoveringSlot(x + 148, y + 47, mouseX, mouseY)) {
                CraftingCoreScreen.m_169606_((PoseStack)matrix, (int)(x + 148), (int)(y + 47), (int)this.m_93252_());
            }
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85837_(0.0, 0.0, 32.0);
        RenderSystem.m_157182_();
        this.m_93250_(200);
        this.f_96542_.f_115093_ = 200.0f;
        Font font = IClientItemExtensions.of((ItemStack)stack).getFont(stack, IClientItemExtensions.FontContext.ITEM_COUNT);
        if (font == null) {
            font = this.f_96547_;
        }
        this.f_96542_.m_115203_(stack, x, y);
        this.m_93250_(0);
        this.f_96542_.f_115093_ = 0.0f;
    }

    private CraftingCoreTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().f_91073_;
        if (level != null && (tile = level.m_7702_(((CraftingCoreContainer)this.m_6262_()).getPos())) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            return core;
        }
        return null;
    }

    private boolean hasRecipe() {
        if (this.tile == null) {
            return false;
        }
        return this.tile.hasRecipe();
    }

    private ItemStack getRecipeOutput() {
        if (this.tile == null) {
            return ItemStack.f_41583_;
        }
        CombinationRecipe recipe = this.tile.getActiveRecipe();
        if (recipe != null) {
            return recipe.m_8043_();
        }
        return ItemStack.f_41583_;
    }

    private int getEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getEnergyStored();
    }

    private int getMaxEnergyStored() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergy().getMaxEnergyStored();
    }

    private int getEnergyRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRequired();
    }

    private int getEnergyRate() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getEnergyRate();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getPedestalCount() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getPedestalCount();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        long j = this.getEnergyRequired();
        return (int)(j != 0L && i != 0 ? (long)i * 24L / j : 0L);
    }

    private static boolean isHoveringSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX > x - 1 && mouseX < x + 16 && mouseY > y - 1 && mouseY < y + 16;
    }
}

