/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.container;

import appeng.api.networking.IGridNode;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.github.glodblock.epp.common.me.wireless.WirelessStatus;
import com.github.glodblock.epp.common.tileentities.TileWirelessConnector;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class ContainerWirelessConnector
extends UpgradeableMenu<TileWirelessConnector> {
    public static final MenuType<ContainerWirelessConnector> TYPE = MenuTypeBuilder.create(ContainerWirelessConnector::new, TileWirelessConnector.class).build("wireless_connector");
    private final TileWirelessConnector connector;
    @GuiSync(value=7)
    public double powerUse;
    @GuiSync(value=8)
    public int usedChannel;
    @GuiSync(value=9)
    public int maxChannel;
    @GuiSync(value=10)
    public long otherSide;
    @GuiSync(value=11)
    public WirelessStatus status = WirelessStatus.REMOTE_ERROR;

    public ContainerWirelessConnector(int id, Inventory playerInventory, TileWirelessConnector host) {
        super(TYPE, id, playerInventory, (IUpgradeableObject)host);
        this.connector = host;
    }

    public void m_38946_() {
        this.powerUse = this.connector.getPowerUse();
        IGridNode node = this.connector.getMainNode().getNode();
        if (node != null) {
            this.usedChannel = node.getUsedChannels();
            this.maxChannel = node.getMaxChannels();
        } else {
            this.usedChannel = 0;
            this.maxChannel = 0;
        }
        BlockPos otherSide = this.connector.getOtherSide();
        if (otherSide == null) {
            this.otherSide = 0L;
            this.status = this.connector.getFrequency() == 0L ? WirelessStatus.UNCONNECTED : WirelessStatus.REMOTE_ERROR;
        } else {
            this.otherSide = otherSide.m_121878_();
            this.status = WirelessStatus.WORKING;
        }
        if (!this.connector.getMainNode().isPowered() && this.status == WirelessStatus.WORKING) {
            this.status = WirelessStatus.NO_POWER;
        }
        super.m_38946_();
    }
}

