/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.epp.client;

import appeng.client.render.model.AutoRotatingBakedModel;
import appeng.init.client.InitScreens;
import appeng.menu.SlotSemantics;
import com.github.glodblock.epp.client.ExSemantics;
import com.github.glodblock.epp.client.gui.GuiExDrive;
import com.github.glodblock.epp.client.gui.GuiExIOBus;
import com.github.glodblock.epp.client.gui.GuiExInterface;
import com.github.glodblock.epp.client.gui.GuiExPatternProvider;
import com.github.glodblock.epp.client.gui.GuiIngredientBuffer;
import com.github.glodblock.epp.client.gui.GuiWirelessConnector;
import com.github.glodblock.epp.client.model.AERotatableBlocks;
import com.github.glodblock.epp.client.model.ExDriveModel;
import com.github.glodblock.epp.client.render.tesr.ExDriveTESR;
import com.github.glodblock.epp.client.render.tesr.IngredientBufferTESR;
import com.github.glodblock.epp.common.tileentities.TileExDrive;
import com.github.glodblock.epp.common.tileentities.TileIngredientBuffer;
import com.github.glodblock.epp.container.ContainerExDrive;
import com.github.glodblock.epp.container.ContainerExIOBus;
import com.github.glodblock.epp.container.ContainerExInterface;
import com.github.glodblock.epp.container.ContainerExPatternProvider;
import com.github.glodblock.epp.container.ContainerIngredientBuffer;
import com.github.glodblock.epp.container.ContainerWirelessConnector;
import com.github.glodblock.epp.util.FCUtil;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientRegistryHandler {
    public static final ClientRegistryHandler INSTANCE = new ClientRegistryHandler();

    public void init() {
        this.registerSemantic();
        this.registerGui();
    }

    public void registerSemantic() {
        ExSemantics.EX_1 = SlotSemantics.register((String)"EX_1", (boolean)false);
        ExSemantics.EX_2 = SlotSemantics.register((String)"EX_2", (boolean)false);
        ExSemantics.EX_3 = SlotSemantics.register((String)"EX_3", (boolean)false);
        ExSemantics.EX_4 = SlotSemantics.register((String)"EX_4", (boolean)false);
    }

    public void registerGui() {
        InitScreens.register(ContainerExPatternProvider.TYPE, GuiExPatternProvider::new, (String)"/screens/ex_pattern_provider.json");
        InitScreens.register(ContainerExInterface.TYPE, GuiExInterface::new, (String)"/screens/ex_interface.json");
        InitScreens.register(ContainerExIOBus.EXPORT_TYPE, GuiExIOBus::new, (String)"/screens/ex_export_bus.json");
        InitScreens.register(ContainerExIOBus.IMPORT_TYPE, GuiExIOBus::new, (String)"/screens/ex_import_bus.json");
        InitScreens.register(ContainerExDrive.TYPE, GuiExDrive::new, (String)"/screens/ex_drive.json");
        InitScreens.register(ContainerIngredientBuffer.TYPE, GuiIngredientBuffer::new, (String)"/screens/ingredient_buffer.json");
        InitScreens.register(ContainerWirelessConnector.TYPE, GuiWirelessConnector::new, (String)"/screens/wireless_connector.json");
    }

    @SubscribeEvent
    public void registerModels(ModelEvent.RegisterGeometryLoaders event) {
        BlockEntityRenderers.m_173590_(FCUtil.getTileType(TileExDrive.class), ExDriveTESR::new);
        BlockEntityRenderers.m_173590_(FCUtil.getTileType(TileIngredientBuffer.class), IngredientBufferTESR::new);
        event.register("ex_drive", (IGeometryLoader)new ExDriveModel.Loader());
    }

    public void registerRotatableBlock(ModelEvent.BakingCompleted event) {
        Map modelRegistry = event.getModels();
        HashSet keys = Sets.newHashSet(modelRegistry.keySet());
        BakedModel missingModel = (BakedModel)modelRegistry.get(ModelBakery.f_119230_);
        for (ResourceLocation location : keys) {
            AutoRotatingBakedModel newModel;
            BakedModel orgModel;
            if (!location.m_135827_().equals("expatternprovider") || !AERotatableBlocks.check(location) || (orgModel = (BakedModel)modelRegistry.get(location)) == missingModel || (newModel = new AutoRotatingBakedModel(orgModel)) == orgModel) continue;
            modelRegistry.put(location, newModel);
        }
    }
}

