/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.api.tag.ExNihiloTags;
import novamachina.exnihilosequentia.common.block.BaseBlock;
import novamachina.exnihilosequentia.common.block.BaseFallingBlock;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipeBuilder;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.MeshItem;
import novamachina.exnihilosequentia.common.item.OreItem;
import novamachina.exnihilosequentia.common.item.PebbleItem;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import novamachina.exnihilosequentia.common.utility.ExNihiloConstants;
import novamachina.exnihilosequentia.datagen.api.datagen.AbstractRecipeGenerator;

public class ExNihiloRecipeGenerator
extends AbstractRecipeGenerator {
    public static final String GRAVEL = "gravel";
    @Nonnull
    private static final String COBBLESTONE = "cobblestone";
    @Nonnull
    private static final String DOLL_CONDITION = "has_doll";
    @Nonnull
    private static final String GRAVEL_SUFFIX = "_gravel";
    @Nonnull
    private static final String LEAVES = "leaves";
    @Nonnull
    private static final String MATERIAL_CONDITION = "has_material";
    @Nonnull
    private static final String NETHERRACK = "netherrack";
    @Nonnull
    private static final String PORCELAIN_CLAY_CONDITION = "has_porcelain_clay";
    private static final String SILKWORM = "silkworm";
    @Nonnull
    private static final Fluid lava = Fluids.f_76195_;
    @Nonnull
    private static final Fluid seawater = (Fluid)ExNihiloFluids.SEA_WATER.get();
    @Nonnull
    private static final Fluid water = Fluids.f_76193_;
    @Nonnull
    private static final Fluid witchwater = (Fluid)ExNihiloFluids.WITCH_WATER.get();

    public ExNihiloRecipeGenerator(@Nonnull DataGenerator generator) {
        super(generator, "exnihilosequentia");
    }

    protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.registerCrooks(consumer);
        this.registerPebbleBlocks(consumer);
        this.registerBarrels(consumer);
        this.registerCrucibles(consumer);
        this.registerSieves(consumer);
        this.registerOres(consumer);
        this.registerHammers(consumer);
        this.registerDolls(consumer);
        this.registerMeshes(consumer);
        this.registerMisc(consumer);
        this.registerCustomRecipes(consumer);
    }

    private Map<Block, Item> getLeavesSaplings() {
        HashMap<Block, Item> saplingMap = new HashMap<Block, Item>();
        saplingMap.put(Blocks.f_50054_, Items.f_41827_);
        saplingMap.put(Blocks.f_50052_, Items.f_42801_);
        saplingMap.put(Blocks.f_50055_, Items.f_41828_);
        saplingMap.put(Blocks.f_50053_, Items.f_41826_);
        saplingMap.put(Blocks.f_50050_, Items.f_42799_);
        saplingMap.put(Blocks.f_50051_, Items.f_42800_);
        return saplingMap;
    }

    private void registerBarrels(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_STONE, (TagKey<Item>)Tags.Items.STONE, Items.f_41922_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_ACACIA, Items.f_42795_, Items.f_41918_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_BIRCH, Items.f_42753_, Items.f_41916_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_DARK_OAK, Items.f_42796_, Items.f_41919_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_JUNGLE, Items.f_42794_, Items.f_41917_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_MANGROVE, Items.f_220174_, Items.f_220183_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_OAK, Items.f_42647_, Items.f_41914_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_SPRUCE, Items.f_42700_, Items.f_41915_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_CRIMSON, Items.f_42797_, Items.f_41920_);
        this.createBarrel(consumer, ExNihiloBlocks.BARREL_WARPED, Items.f_42798_, Items.f_41921_);
    }

    private void registerCompostRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createCompostRecipe(consumer, (TagKey<Item>)ItemTags.f_13180_, 125, "saplings");
        this.createCompostRecipe(consumer, (TagKey<Item>)ItemTags.f_13143_, 125, LEAVES);
        this.createCompostRecipe(consumer, (TagKey<Item>)ItemTags.f_13149_, 100, "flowers");
        this.createCompostRecipe(consumer, (TagKey<Item>)ItemTags.f_13156_, 150, "fishes");
        this.createCompostRecipe(consumer, ExNihiloTags.MEAT_COOKED, 200, "meat_cooked");
        this.createCompostRecipe(consumer, ExNihiloTags.MEAT_UNCOOKED, 200, "meat_uncooked");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.SEEDS, 80, "seeds");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.CROPS_WHEAT, 80, "wheat");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.CROPS_CARROT, 100, "carrot");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.CROPS_BEETROOT, 100, "beetroot");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.CROPS_POTATO, 100, "potato");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.CROPS_NETHER_WART, 100, "nether_wart");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.EGGS, 80, "eggs");
        this.createCompostRecipe(consumer, (TagKey<Item>)Tags.Items.STRING, 40, "string");
        this.createCompostRecipe(consumer, Items.f_42583_, 100, "rotten_flesh");
        this.createCompostRecipe(consumer, Items.f_42591_, 80, "spider_eye");
        this.createCompostRecipe(consumer, Items.f_42406_, 160, "bread");
        this.createCompostRecipe(consumer, Blocks.f_50072_, 100, "brown_mushroom");
        this.createCompostRecipe(consumer, Blocks.f_50073_, 100, "red_mushroom");
        this.createCompostRecipe(consumer, Items.f_41954_, 100, "crimson_fungus");
        this.createCompostRecipe(consumer, Items.f_41955_, 100, "warped_fungus");
        this.createCompostRecipe(consumer, Items.f_42687_, 160, "pumpkin_pie");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), 40, SILKWORM);
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.COOKED_SILKWORM.get(), 40, "cooked_silkworm");
        this.createCompostRecipe(consumer, Items.f_42410_, 100, "apple");
        this.createCompostRecipe(consumer, Items.f_42575_, 40, "melon_slice");
        this.createCompostRecipe(consumer, Items.f_42028_, 166, "melon");
        this.createCompostRecipe(consumer, Items.f_42046_, 166, "pumpkin");
        this.createCompostRecipe(consumer, Items.f_42047_, 166, "carved_pumpkin");
        this.createCompostRecipe(consumer, Items.f_42055_, 166, "jack_o_lantern");
        this.createCompostRecipe(consumer, Items.f_41982_, 100, "cactus");
        this.createCompostRecipe(consumer, Items.f_42674_, 150, "baked_potato");
        this.createCompostRecipe(consumer, Items.f_42675_, 200, "poisonous_potato");
        this.createCompostRecipe(consumer, Items.f_42094_, 100, "lily_pad");
        this.createCompostRecipe(consumer, Items.f_42029_, 100, "vine");
        this.createCompostRecipe(consumer, Items.f_41907_, 100, "weeping_vine");
        this.createCompostRecipe(consumer, Items.f_41908_, 100, "twisting_vine");
        this.createCompostRecipe(consumer, Items.f_42210_, 100, "tall_grass");
        this.createCompostRecipe(consumer, Items.f_41909_, 80, "sugar_cane");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.GRASS_SEED.get(), 100, "grass_seed");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.MYCELIUM_SPORE.get(), 100, "mycelium_spore");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.CRIMSON_NYLIUM_SPORE.get(), 100, "crimson_nylium_spore");
        this.createCompostRecipe(consumer, (Item)ExNihiloItems.WARPED_NYLIUM_SPORE.get(), 100, "warped_nylium_spore");
        this.createCompostRecipe(consumer, Items.f_42780_, 100, "sweet_berries");
        this.createCompostRecipe(consumer, Items.f_151014_, 100, "spore_blossom");
        this.createCompostRecipe(consumer, Items.f_41910_, 100, "kelp");
        this.createCompostRecipe(consumer, Items.f_220180_, 100, "mangrove_roots");
        this.createCompostRecipe(consumer, Items.f_41956_, 100, "crimson_roots");
        this.createCompostRecipe(consumer, Items.f_41957_, 100, "warped_roots");
        this.createCompostRecipe(consumer, Items.f_151017_, 100, "hanging_roots");
        this.createCompostRecipe(consumer, Items.f_151018_, 100, "big_dripleaf");
        this.createCompostRecipe(consumer, Items.f_151019_, 100, "small_dripleaf");
        this.createCompostRecipe(consumer, Items.f_41865_, 100, "small_fern");
        this.createCompostRecipe(consumer, Items.f_42211_, 100, "large_fern");
        this.createCompostRecipe(consumer, Items.f_41867_, 100, "sea_grass");
        this.createCompostRecipe(consumer, Items.f_41911_, 100, "bamboo");
        this.createCompostRecipe(consumer, Items.f_151079_, 100, "glow_berries");
    }

    private void registerCrookRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createCrookRecipes(consumer, (TagKey<Item>)ItemTags.f_13143_, (ItemLike)ExNihiloItems.SILKWORM.get(), 0.1f, LEAVES);
        this.createCrookRecipes(consumer, (Block)ExNihiloBlocks.INFESTED_LEAVES.get(), (ItemLike)ExNihiloItems.SILKWORM.get(), 0.2f, SILKWORM);
        this.createCrookRecipes(consumer, (Block)ExNihiloBlocks.INFESTED_LEAVES.get(), (ItemLike)Items.f_42401_, 0.5f, "string");
    }

    private void registerCrooks(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createCrook((Item)ExNihiloItems.CROOK_ANDESITE.get(), (Item)ExNihiloItems.PEBBLE_ANDESITE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_BASALT.get(), (Item)ExNihiloItems.PEBBLE_BASALT.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_BLACKSTONE.get(), (Item)ExNihiloItems.PEBBLE_BLACKSTONE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_BONE.get(), (TagKey<Item>)Tags.Items.BONES, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_CALCITE.get(), (Item)ExNihiloItems.PEBBLE_CALCITE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_COPPER.get(), ExNihiloTags.NUGGET_COPPER, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_DEEPSLATE.get(), (Item)ExNihiloItems.PEBBLE_DEEPSLATE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_DIAMOND.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_DIORITE.get(), (Item)ExNihiloItems.PEBBLE_DIORITE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_DRIPSTONE.get(), (Item)ExNihiloItems.PEBBLE_DRIPSTONE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_GOLD.get(), (TagKey<Item>)Tags.Items.NUGGETS_GOLD, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_GRANITE.get(), (Item)ExNihiloItems.PEBBLE_GRANITE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_IRON.get(), (TagKey<Item>)Tags.Items.NUGGETS_IRON, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_NETHER_BRICK.get(), Items.f_42095_, consumer);
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CROOK_DIAMOND.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (Item)((Item)ExNihiloItems.CROOK_NETHERITE.get())).m_126389_("has_diamond_crook", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CROOK_DIAMOND.get()})).m_126389_(MATERIAL_CONDITION, (CriterionTriggerInstance)ExNihiloRecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_NETHERITE)).m_126395_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", ExNihiloConstants.Items.NETHERITE_CROOK)));
        this.createCrook((Item)ExNihiloItems.CROOK_RED_NETHER_BRICK.get(), Items.f_42261_, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_STONE.get(), (Item)ExNihiloItems.PEBBLE_STONE.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_TERRACOTTA.get(), Items.f_42199_, consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_TUFF.get(), (Item)ExNihiloItems.PEBBLE_TUFF.get(), consumer);
        this.createCrook((Item)ExNihiloItems.CROOK_WOOD.get(), (TagKey<Item>)Tags.Items.RODS_WOODEN, consumer);
    }

    private void registerCrucibleRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50652_, 250, COBBLESTONE);
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50334_, 250, "andesite");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50137_, 250, "basalt");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50730_, 250, "blackstone");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_152497_, 250, "calcite");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_152550_, 250, "deepslate");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50228_, 250, "diorite");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_152537_, 250, "dripstone");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50259_, 250, "end_stone");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50122_, 250, "granite");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_152496_, 250, "tuff");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50069_, 250, "stone");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_49994_, 200, GRAVEL);
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_ANDESITE.get(), 200, "crushed_andesite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_BASALT.get(), 200, "crushed_basalt");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_BLACKSTONE.get(), 200, "crushed_blackstone");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_CALCITE.get(), 200, "crushed_calcite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_DEEPSLATE.get(), 200, "crushed_deepslate");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_DIORITE.get(), 200, "crushed_diorite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_DRIPSTONE.get(), 200, "crushed_dripstone");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_END_STONE.get(), 200, "crushed_end_stone");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_GRANITE.get(), 200, "crushed_granite");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_NETHERRACK.get(), 200, "crushed_netherrack");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.CRUSHED_TUFF.get(), 200, "crushed_tuff");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_49992_, 100, "sand");
        this.createFiredCrucibleRecipes(consumer, (Block)ExNihiloBlocks.DUST.get(), 50, "dust");
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50134_, 1000, NETHERRACK);
        this.createFiredCrucibleRecipes(consumer, Blocks.f_50080_, 1000, "obsidian");
        this.createWaterCrucibleRecipes(consumer, (TagKey<Item>)ItemTags.f_13180_, 250, "saplings");
        this.createWaterCrucibleRecipes(consumer, (TagKey<Item>)ItemTags.f_13143_, 250, LEAVES);
    }

    private void registerCrucibles(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_ACACIA, Items.f_41841_, Items.f_41918_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_BIRCH, Items.f_41839_, Items.f_41916_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_DARK_OAK, Items.f_41842_, Items.f_41919_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_JUNGLE, Items.f_41840_, Items.f_41917_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_MANGROVE, Items.f_220179_, Items.f_220183_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_OAK, Items.f_41837_, Items.f_41914_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_SPRUCE, Items.f_41838_, Items.f_41915_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_CRIMSON, Items.f_41843_, Items.f_41920_);
        this.createCrucible(consumer, ExNihiloBlocks.CRUCIBLE_WARPED, Items.f_41844_, Items.f_41921_);
    }

    private void registerCustomRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.registerHammerRecipes(consumer);
        this.registerCrookRecipes(consumer);
        this.registerCompostRecipes(consumer);
        this.registerFluidItemRecipes(consumer);
        this.registerFluidOnTopRecipes(consumer);
        this.registerFluidTransformRecipes(consumer);
        this.registerCrucibleRecipes(consumer);
        this.registerHeatRecipes(consumer);
        this.registerSieveRecipes(consumer);
    }

    private void registerDefaultOres(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull Ore ore) {
        OreItem oreItem = ore.getPieceItem();
        if (oreItem == null) {
            return;
        }
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)oreItem)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.075f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.1f)).build(consumer, this.sieveLoc(ore.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerDolls(@Nonnull Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.SHULKER_DOLL.get())).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_PURPLE).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.END_STONES).m_206416_(Character.valueOf('b'), Tags.Items.ENDER_PEARLS).m_126127_(Character.valueOf('m'), (ItemLike)ExNihiloItems.CRAFTING_DOLL.get()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CRAFTING_DOLL.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.SHULKER_DOLL.getId()));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.GUARDIAN_DOLL.get())).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.GEMS_PRISMARINE).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), ItemTags.f_13156_).m_126127_(Character.valueOf('m'), (ItemLike)ExNihiloItems.CRAFTING_DOLL.get()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CRAFTING_DOLL.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.GUARDIAN_DOLL.getId()));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.BEE_DOLL.get())).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_YELLOW).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), ItemTags.f_13149_).m_126127_(Character.valueOf('b'), (ItemLike)ExNihiloItems.BEEHIVE_FRAME.get()).m_126127_(Character.valueOf('m'), (ItemLike)ExNihiloItems.CRAFTING_DOLL.get()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CRAFTING_DOLL.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.BEE_DOLL.getId()));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.BLAZE_DOLL.get())).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42593_).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), Tags.Items.CROPS_NETHER_WART).m_126127_(Character.valueOf('m'), (ItemLike)ExNihiloItems.CRAFTING_DOLL.get()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CRAFTING_DOLL.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.BLAZE_DOLL.getId()));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.ENDERMAN_DOLL.get())).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_BLACK).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), Tags.Items.CROPS_NETHER_WART).m_126127_(Character.valueOf('m'), (ItemLike)ExNihiloItems.CRAFTING_DOLL.get()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.CRAFTING_DOLL.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.ENDERMAN_DOLL.getId()));
    }

    private void registerFluidItemRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createFluidItemRecipes(consumer, water, ((BaseFallingBlock)((Object)ExNihiloBlocks.DUST.get())).m_5456_(), Blocks.f_50129_, "clay");
        this.createFluidItemRecipes(consumer, water, Blocks.f_50493_.m_5456_(), Blocks.f_220864_, "mud");
        this.createFluidItemRecipes(consumer, lava, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, Blocks.f_50134_, NETHERRACK);
        this.createFluidItemRecipes(consumer, lava, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, Blocks.f_50259_, "end_stone");
        this.createFluidItemRecipes(consumer, witchwater, (TagKey<Item>)Tags.Items.SAND, Blocks.f_50135_, "soul_sand");
        this.createFluidItemRecipes(consumer, witchwater, Items.f_42382_, Blocks.f_50136_, "soul_soil");
        this.createFluidItemRecipes(consumer, witchwater, (TagKey<Item>)Tags.Items.MUSHROOMS, Blocks.f_50374_, "slime");
        this.createFluidItemRecipes(consumer, seawater, (Item)ExNihiloItems.TUBE_CORAL_LARVA.get(), Blocks.f_50584_, "tube_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)ExNihiloItems.FIRE_CORAL_LARVA.get(), Blocks.f_50587_, "fire_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)ExNihiloItems.BRAIN_CORAL_LARVA.get(), Blocks.f_50585_, "brain_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)ExNihiloItems.BUBBLE_CORAL_LARVA.get(), Blocks.f_50586_, "bubble_coral");
        this.createFluidItemRecipes(consumer, seawater, (Item)ExNihiloItems.HORN_CORAL_LARVA.get(), Blocks.f_50588_, "horn_coral");
        this.createFluidItemRecipes(consumer, witchwater, (Item)ExNihiloItems.MYCELIUM_SPORE.get(), Blocks.f_50180_, "brown_mushroom");
        this.createFluidItemRecipes(consumer, witchwater, Blocks.f_50180_.m_5456_(), Blocks.f_50181_, "red_mushroom");
        this.createFluidItemRecipes(consumer, water, ((BaseFallingBlock)((Object)ExNihiloBlocks.CRUSHED_DRIPSTONE.get())).m_5456_(), Blocks.f_152588_, "pointed_dripstone");
    }

    private void registerFluidOnTopRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createFluidOnTopRecipes(consumer, lava, water, Blocks.f_50080_, "obsidian");
        this.createFluidOnTopRecipes(consumer, water, lava, Blocks.f_50652_, COBBLESTONE);
    }

    private void registerFluidTransformRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createFluidTransformRecipes(consumer, water, Blocks.f_50195_.m_5456_(), witchwater, "witch_water");
        this.createFluidTransformRecipes(consumer, water, (TagKey<Item>)Tags.Items.SAND, seawater, "sea_water");
    }

    private void registerGoldOres(@Nonnull Consumer<FinishedRecipe> consumer) {
        OreItem oreItem = ExNihiloItems.GOLD.getPieceItem();
        if (oreItem == null) {
            return;
        }
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((ItemLike)oreItem)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.25f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.25f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.4f)).build(consumer, this.sieveLoc(ExNihiloItems.GOLD.getPieceName() + "_crushed_netherrack"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)oreItem)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.075f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.15f)).build(consumer, this.sieveLoc(ExNihiloItems.GOLD.getPieceName() + GRAVEL_SUFFIX));
    }

    private void registerHammerRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createHammerRecipes(consumer, Blocks.f_50069_, Blocks.f_50652_, COBBLESTONE);
        this.createHammerRecipes(consumer, Blocks.f_50652_, Blocks.f_49994_, GRAVEL);
        this.createHammerRecipes(consumer, Blocks.f_49994_, Blocks.f_49992_, "sand");
        this.createHammerRecipes(consumer, Blocks.f_49992_, (Block)ExNihiloBlocks.DUST.get(), "dust");
        this.createHammerRecipes(consumer, Blocks.f_50334_, (Block)ExNihiloBlocks.CRUSHED_ANDESITE.get(), "andesite");
        this.createHammerRecipes(consumer, Blocks.f_50137_, (Block)ExNihiloBlocks.CRUSHED_BASALT.get(), "basalt");
        this.createHammerRecipes(consumer, Blocks.f_50730_, (Block)ExNihiloBlocks.CRUSHED_BLACKSTONE.get(), "blackstone");
        this.createHammerRecipes(consumer, Blocks.f_152497_, (Block)ExNihiloBlocks.CRUSHED_CALCITE.get(), "calcite");
        this.createHammerRecipes(consumer, Blocks.f_152550_, (Block)ExNihiloBlocks.CRUSHED_DEEPSLATE.get(), "deepslate");
        this.createHammerRecipes(consumer, Blocks.f_50228_, (Block)ExNihiloBlocks.CRUSHED_DIORITE.get(), "diorite");
        this.createHammerRecipes(consumer, Blocks.f_152537_, (Block)ExNihiloBlocks.CRUSHED_DRIPSTONE.get(), "dripstone");
        this.createHammerRecipes(consumer, Blocks.f_50259_, (Block)ExNihiloBlocks.CRUSHED_END_STONE.get(), "end_stone");
        this.createHammerRecipes(consumer, Blocks.f_50122_, (Block)ExNihiloBlocks.CRUSHED_GRANITE.get(), "granite");
        this.createHammerRecipes(consumer, Blocks.f_50134_, (Block)ExNihiloBlocks.CRUSHED_NETHERRACK.get(), NETHERRACK);
        this.createHammerRecipes(consumer, Blocks.f_152496_, (Block)ExNihiloBlocks.CRUSHED_TUFF.get(), "tuff");
        this.createHammerRecipes(consumer, Blocks.f_50584_, Blocks.f_50594_, "tube_coral");
        this.createHammerRecipes(consumer, Blocks.f_50585_, Blocks.f_50595_, "brain_coral");
        this.createHammerRecipes(consumer, Blocks.f_50586_, Blocks.f_50596_, "bubble_coral");
        this.createHammerRecipes(consumer, Blocks.f_50587_, Blocks.f_50597_, "fire_coral");
        this.createHammerRecipes(consumer, Blocks.f_50588_, Blocks.f_50598_, "horn_coral");
        this.createHammerRecipes(consumer, Blocks.f_50594_, Blocks.f_50552_, "tube_coral_fan");
        this.createHammerRecipes(consumer, Blocks.f_50595_, Blocks.f_50553_, "brain_coral_fan");
        this.createHammerRecipes(consumer, Blocks.f_50596_, Blocks.f_50554_, "bubble_coral_fan");
        this.createHammerRecipes(consumer, Blocks.f_50597_, Blocks.f_50555_, "fire_coral_fan");
        this.createHammerRecipes(consumer, Blocks.f_50598_, Blocks.f_50556_, "horn_coral_fan");
    }

    private void registerHammers(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createHammer((Item)ExNihiloItems.HAMMER_ANDESITE.get(), Items.f_42170_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_BASALT.get(), Items.f_42051_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_BLACKSTONE.get(), Items.f_42755_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_CALCITE.get(), Items.f_151047_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_COPPER.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_DEEPSLATE.get(), Items.f_151034_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_DIAMOND.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_DIORITE.get(), Items.f_42064_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_DRIPSTONE.get(), Items.f_151054_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_GOLD.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_GRANITE.get(), Items.f_41958_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_IRON.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_NETHER_BRICK.get(), Items.f_42095_, consumer);
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.HAMMER_DIAMOND.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (Item)((Item)ExNihiloItems.HAMMER_NETHERITE.get())).m_126389_("has_diamond_hammer", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.HAMMER_DIAMOND.get()})).m_126389_(MATERIAL_CONDITION, (CriterionTriggerInstance)ExNihiloRecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_NETHERITE)).m_126395_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", ExNihiloConstants.Items.NETHERITE_HAMMER)));
        this.createHammer((Item)ExNihiloItems.HAMMER_RED_NETHER_BRICK.get(), Items.f_42261_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_STONE.get(), Items.f_42594_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_TERRACOTTA.get(), Items.f_42199_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_TUFF.get(), Items.f_151048_, consumer);
        this.createHammer((Item)ExNihiloItems.HAMMER_WOOD.get(), (TagKey<Item>)ItemTags.f_13168_, consumer);
    }

    private void registerHeatRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createHeatRecipes(consumer, Blocks.f_49991_, 3, "lava");
        this.createHeatRecipes(consumer, Blocks.f_50083_, 4, "fire");
        this.createHeatRecipes(consumer, Blocks.f_50081_, 1, "torch");
        this.createHeatRecipes(consumer, Blocks.f_50082_, 1, "wall_torch");
        this.createHeatRecipes(consumer, Blocks.f_50450_, 2, "magma_block");
        this.createHeatRecipes(consumer, Blocks.f_50141_, 2, "glowstone");
        this.createHeatRecipes(consumer, Blocks.f_50701_, 2, "shroomlight");
        this.createHeatRecipes(consumer, Blocks.f_50084_, 4, "soul_fire");
        StatePropertiesPredicate lit = StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BlockStateProperties.f_61443_, true).m_67706_();
        this.createHeatRecipes(consumer, Blocks.f_50683_, 4, lit, "campfire");
        this.createHeatRecipes(consumer, Blocks.f_50684_, 4, lit, "soul_campfire");
        this.createHeatRecipes(consumer, Blocks.f_50094_, 3, lit, "furnace");
        this.createHeatRecipes(consumer, Blocks.f_50174_, 1, lit, "redstone_torch");
        this.createHeatRecipes(consumer, Blocks.f_50123_, 1, lit, "redstone_wall_torch");
    }

    private void registerIronOres(@Nonnull Consumer<FinishedRecipe> consumer) {
        OreItem oreItem = ExNihiloItems.IRON.getPieceItem();
        if (oreItem == null) {
            return;
        }
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)oreItem)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.15f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.25f)).build(consumer, this.sieveLoc(ExNihiloItems.IRON.getPieceName() + GRAVEL_SUFFIX));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49992_})).addResult((ItemLike)oreItem)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.5f)).build(consumer, this.sieveLoc(ExNihiloItems.IRON.getPieceName() + "_sand"));
    }

    private void registerMeshes(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createMesh((Item)ExNihiloItems.MESH_FLINT.get(), (Item)ExNihiloItems.MESH_STRING.get(), Items.f_42484_, consumer);
        this.createMesh((Item)ExNihiloItems.MESH_IRON.get(), (Item)ExNihiloItems.MESH_FLINT.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createMesh((Item)ExNihiloItems.MESH_DIAMOND.get(), (Item)ExNihiloItems.MESH_IRON.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createMesh((Item)ExNihiloItems.MESH_EMERALD.get(), (Item)ExNihiloItems.MESH_DIAMOND.get(), (TagKey<Item>)Tags.Items.GEMS_EMERALD, consumer);
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.MESH_EMERALD.get()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (Item)((Item)ExNihiloItems.MESH_NETHERITE.get())).m_126389_("has_emerald_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.MESH_EMERALD.get()})).m_126389_(MATERIAL_CONDITION, (CriterionTriggerInstance)ExNihiloRecipeGenerator.m_206406_((TagKey)Tags.Items.INGOTS_NETHERITE)).m_126395_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "netherite_mesh")));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.MESH_STRING.get())).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_206416_(Character.valueOf('i'), Tags.Items.STRING).m_126132_("has_sieve", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.SIEVE_OAK.get(), (ItemLike)ExNihiloBlocks.SIEVE_ACACIA.get(), (ItemLike)ExNihiloBlocks.SIEVE_BIRCH.get(), (ItemLike)ExNihiloBlocks.SIEVE_JUNGLE.get(), (ItemLike)ExNihiloBlocks.SIEVE_MANGROVE.get(), (ItemLike)ExNihiloBlocks.SIEVE_DARK_OAK.get(), (ItemLike)ExNihiloBlocks.SIEVE_SPRUCE.get(), (ItemLike)ExNihiloBlocks.SIEVE_CRIMSON.get(), (ItemLike)ExNihiloBlocks.SIEVE_WARPED.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.MESH_STRING.getId()));
    }

    private void registerMisc(@Nonnull Consumer<FinishedRecipe> consumer) {
        ResourceLocation ancientDebrisResourceLocation;
        ResourceLocation cryingObsidianResourceLocation;
        ResourceLocation beehive = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50718_);
        if (beehive != null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50718_).m_126130_("xxx").m_126130_("fff").m_126130_("xxx").m_206416_(Character.valueOf('x'), ItemTags.f_13168_).m_126127_(Character.valueOf('f'), (ItemLike)ExNihiloItems.BEEHIVE_FRAME.get()).m_126132_("has_frame", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.BEEHIVE_FRAME.get()})).m_126140_(consumer, this.createSaveLocation(beehive));
        }
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloItems.BEEHIVE_FRAME.get())).m_126130_("xxx").m_126130_("xfx").m_126130_("xxx").m_206416_(Character.valueOf('x'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('f'), Tags.Items.STRING).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS_WOODEN).m_45077_()})).m_126132_("has_string", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.STRING).m_45077_()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.BEEHIVE_FRAME.getId()));
        this.createCookingRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), (Item)ExNihiloItems.COOKED_SILKWORM.get(), 0.1f, 600, 0.1f, 100, "has_silkworm", ExNihiloItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, (Item)ExNihiloItems.SILKWORM.get(), (Item)ExNihiloItems.COOKED_SILKWORM.get(), 0.1f, 200, 0.1f, 100, "has_silkworm", ExNihiloItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, ((BaseBlock)((Object)ExNihiloBlocks.CRUCIBLE_UNFIRED.get())).m_5456_(), ((BaseBlock)((Object)ExNihiloBlocks.CRUCIBLE_FIRED.get())).m_5456_(), 0.7f, 200, 0.7f, 100, "has_uncooked_crucible", ExNihiloBlocks.CRUCIBLE_FIRED.getId());
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloBlocks.CRUCIBLE_UNFIRED.get())).m_126130_("c c").m_126130_("c c").m_126130_("ccc").m_126127_(Character.valueOf('c'), (ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()})).m_126140_(consumer, this.createSaveLocation(ExNihiloBlocks.CRUCIBLE_UNFIRED.getId()));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ExNihiloItems.CRAFTING_DOLL.get()), (int)4).m_126130_("xex").m_126130_(" x ").m_126130_("x x").m_126127_(Character.valueOf('x'), (ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_DIAMOND).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()})).m_126132_("has_diamond", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.GEMS_DIAMOND).m_45077_()})).m_126140_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x4")));
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ExNihiloItems.CRAFTING_DOLL.get()), (int)6).m_126130_("xex").m_126130_(" x ").m_126130_("x x").m_126127_(Character.valueOf('x'), (ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloItems.PORCELAIN_CLAY.get()})).m_126132_("has_emerald", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.GEMS_EMERALD).m_45077_()})).m_126140_(consumer, this.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x6")));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)ExNihiloBlocks.END_CAKE.get())).m_126130_("ece").m_126130_("eke").m_126130_("ece").m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42729_).m_126127_(Character.valueOf('k'), (ItemLike)Items.f_42502_).m_126132_("has_ender_pearl", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42584_})).m_126140_(consumer, this.createSaveLocation(ExNihiloBlocks.END_CAKE.getId()));
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)ExNihiloItems.PORCELAIN_CLAY.get())).m_206419_(ExNihiloTags.CLAY).m_126209_((ItemLike)Items.f_42499_).m_126132_("has_clay", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ExNihiloTags.CLAY).m_45077_()})).m_126140_(consumer, this.createSaveLocation(ExNihiloItems.PORCELAIN_CLAY.getId()));
        RegistryObject<PebbleItem> blackstonePebble = ExNihiloItems.PEBBLE_BLACKSTONE;
        ResourceLocation gildedBlackstoneResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50706_);
        if (ExNihiloItems.GOLD.getRawOreItem() != null && gildedBlackstoneResourceLocation != null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50706_).m_126130_("xxx").m_126130_("xgx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)blackstonePebble.get()).m_206416_(Character.valueOf('g'), Tags.Items.RAW_MATERIALS_GOLD).m_126132_("has_gold", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_151053_})).m_126140_(consumer, this.createSaveLocation(gildedBlackstoneResourceLocation));
        }
        if ((cryingObsidianResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50723_)) != null) {
            ShapedRecipeBuilder.m_126116_((ItemLike)Blocks.f_50723_).m_126130_(" o ").m_126130_("obo").m_126130_(" o ").m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('o'), (ItemLike)Blocks.f_50080_).m_126132_("has_obsidian", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50080_})).m_126140_(consumer, this.createSaveLocation(cryingObsidianResourceLocation));
        }
        if ((ancientDebrisResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50722_)) != null) {
            ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50722_).m_126209_((ItemLike)Items.f_42419_).m_126209_((ItemLike)Blocks.f_50080_).m_126132_("has_scrap", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42419_})).m_126140_(consumer, this.createSaveLocation(ancientDebrisResourceLocation));
        }
    }

    private void registerOres(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createOre(ExNihiloItems.IRON, consumer);
        this.createOre(ExNihiloItems.GOLD, consumer);
        this.createOre(ExNihiloItems.COPPER, consumer);
        this.createOreRecipes(ExNihiloItems.LEAD, new ResourceLocation("exnihilosequentia", ExNihiloItems.LEAD.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.NICKEL, new ResourceLocation("exnihilosequentia", ExNihiloItems.NICKEL.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.SILVER, new ResourceLocation("exnihilosequentia", ExNihiloItems.SILVER.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.TIN, new ResourceLocation("exnihilosequentia", ExNihiloItems.TIN.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.ALUMINUM, new ResourceLocation("exnihilosequentia", ExNihiloItems.ALUMINUM.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.PLATINUM, new ResourceLocation("exnihilosequentia", ExNihiloItems.PLATINUM.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.URANIUM, new ResourceLocation("exnihilosequentia", ExNihiloItems.URANIUM.getIngotName()), consumer);
        this.createOreRecipes(ExNihiloItems.ZINC, new ResourceLocation("exnihilosequentia", ExNihiloItems.ZINC.getIngotName()), consumer);
    }

    private void registerPebbleBlocks(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createPebbleBlock(Blocks.f_50334_, (Item)ExNihiloItems.PEBBLE_ANDESITE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50137_, (Item)ExNihiloItems.PEBBLE_BASALT.get(), consumer);
        this.createPebbleBlock(Blocks.f_50730_, (Item)ExNihiloItems.PEBBLE_BLACKSTONE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50652_, (Item)ExNihiloItems.PEBBLE_STONE.get(), consumer);
        this.createPebbleBlock(Blocks.f_152497_, (Item)ExNihiloItems.PEBBLE_CALCITE.get(), consumer);
        this.createPebbleBlock(Blocks.f_152550_, (Item)ExNihiloItems.PEBBLE_DEEPSLATE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50228_, (Item)ExNihiloItems.PEBBLE_DIORITE.get(), consumer);
        this.createPebbleBlock(Blocks.f_152537_, (Item)ExNihiloItems.PEBBLE_DRIPSTONE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50259_, (Item)ExNihiloItems.PEBBLE_END_STONE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50122_, (Item)ExNihiloItems.PEBBLE_GRANITE.get(), consumer);
        this.createPebbleBlock(Blocks.f_50134_, (Item)ExNihiloItems.PEBBLE_NETHERRACK.get(), consumer);
        this.createPebbleBlock(Blocks.f_152496_, (Item)ExNihiloItems.PEBBLE_TUFF.get(), consumer);
    }

    private void registerSieveRecipes(@Nonnull Consumer<FinishedRecipe> consumer) {
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_STONE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 1.0f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 1.0f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_stone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_ANDESITE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_andesite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_DIORITE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_diorite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_GRANITE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_granite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_BASALT.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_basalt"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_BLACKSTONE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_blackstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_CALCITE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_calcite"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_DEEPSLATE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_deepslate"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_DRIPSTONE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_dripstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_END_STONE.get()})).addResult((ItemLike)ExNihiloItems.PEBBLE_END_STONE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_end_stone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((ItemLike)ExNihiloItems.PEBBLE_NETHERRACK.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_netherrack"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.PEBBLE_TUFF.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.5f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("pebble_tuff"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)Items.f_42404_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.7f)).build(consumer, this.sieveLoc("seed_wheat"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)Items.f_42578_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.35f)).build(consumer, this.sieveLoc("seed_melon"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)Items.f_42577_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.35f)).build(consumer, this.sieveLoc("seed_pumpkin"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)Items.f_42733_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.35f)).build(consumer, this.sieveLoc("seed_beetroot"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.MYCELIUM_SPORE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("mycelium_spore"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((ItemLike)ExNihiloItems.CRIMSON_NYLIUM_SPORE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("crimson_nylium_spore"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((ItemLike)ExNihiloItems.WARPED_NYLIUM_SPORE.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("warped_nylium_spore"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50493_})).addResult((ItemLike)ExNihiloItems.GRASS_SEED.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("seed_grass"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_220864_})).addResult((ItemLike)Items.f_220175_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.03f)).isWaterlogged().build(consumer, this.sieveLoc("mangrove_propagule"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49992_})).addResult((ItemLike)Items.f_42533_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.03f)).build(consumer, this.sieveLoc("cocoa_beans"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49992_})).addResult((ItemLike)Items.f_42695_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.02f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.04f)).isWaterlogged().build(consumer, this.sieveLoc("prismarine_shard"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49992_})).addResult((ItemLike)Items.f_42696_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.01f)).isWaterlogged().build(consumer, this.sieveLoc("prismarine_crystals"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_42484_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.25f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.25f)).build(consumer, this.sieveLoc("flint"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_42413_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.125f)).build(consumer, this.sieveLoc("coal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_42534_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("lapis_lazuli"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_42415_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.008f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.016f)).build(consumer, this.sieveLoc("diamond"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_NETHERRACK.get()})).addResult((ItemLike)Items.f_42419_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.004f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.008f)).build(consumer, this.sieveLoc("netherite_scrap"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_42616_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.008f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.016f)).build(consumer, this.sieveLoc("emerald"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50135_})).addResult((ItemLike)Items.f_42692_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 1.0f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.33f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 1.0f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.8f)).build(consumer, this.sieveLoc("quartz"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50135_})).addResult((ItemLike)Items.f_42588_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.1f)).build(consumer, this.sieveLoc("nether_wart"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50135_})).addResult((ItemLike)Items.f_42586_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.02f)).build(consumer, this.sieveLoc("ghast_tear"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.DUST.get()})).addResult((ItemLike)Items.f_42499_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.2f)).build(consumer, this.sieveLoc("bone_meal"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.DUST.get()})).addResult((ItemLike)Items.f_42403_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.07f)).build(consumer, this.sieveLoc("gunpowder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.DUST.get()})).addResult((ItemLike)Items.f_42451_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.125f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.25f)).build(consumer, this.sieveLoc("redstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.DUST.get()})).addResult((ItemLike)Items.f_42525_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.0625f)).build(consumer, this.sieveLoc("glowstone"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.DUST.get()})).addResult((ItemLike)Items.f_42593_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("blaze_powder"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_END_STONE.get()})).addResult((ItemLike)Items.f_42584_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.005f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.01f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_EMERALD.get())).getType(), 0.015f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_NETHERITE.get())).getType(), 0.02f)).build(consumer, this.sieveLoc("ender_pearl"));
        this.registerIronOres(consumer);
        this.registerGoldOres(consumer);
        this.registerDefaultOres(consumer, ExNihiloItems.COPPER);
        this.registerDefaultOres(consumer, ExNihiloItems.LEAD);
        this.registerDefaultOres(consumer, ExNihiloItems.NICKEL);
        this.registerDefaultOres(consumer, ExNihiloItems.SILVER);
        this.registerDefaultOres(consumer, ExNihiloItems.TIN);
        this.registerDefaultOres(consumer, ExNihiloItems.ALUMINUM);
        this.registerDefaultOres(consumer, ExNihiloItems.PLATINUM);
        this.registerDefaultOres(consumer, ExNihiloItems.URANIUM);
        this.registerDefaultOres(consumer, ExNihiloItems.ZINC);
        this.createSeeds((ItemLike)Items.f_41828_, consumer);
        this.createSeeds((ItemLike)Items.f_42800_, consumer);
        this.createSeeds((ItemLike)Items.f_42801_, consumer);
        this.createSeeds((ItemLike)Items.f_41826_, consumer);
        this.createSeeds((ItemLike)Items.f_41827_, consumer);
        this.createSeeds((ItemLike)Items.f_42799_, consumer);
        this.createSeeds((ItemLike)Items.f_42619_, consumer);
        this.createSeeds((ItemLike)Items.f_42620_, consumer);
        this.createSeeds((ItemLike)Items.f_42780_, consumer);
        this.createSeeds((ItemLike)Items.f_41911_, consumer);
        this.createSeeds((ItemLike)Items.f_41865_, consumer);
        this.createSeeds((ItemLike)Items.f_42211_, consumer);
        this.createSeeds((ItemLike)Items.f_41982_, consumer, Blocks.f_49992_);
        this.createSeeds((ItemLike)Items.f_41909_, consumer, Blocks.f_49992_);
        this.createWaterSeeds((ItemLike)Items.f_41910_, consumer);
        this.createWaterSeeds((ItemLike)Items.f_41868_, consumer);
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ExNihiloBlocks.CRUSHED_END_STONE.get()})).addResult((ItemLike)Items.f_42003_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.01f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_EMERALD.get())).getType(), 0.02f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_NETHERITE.get())).getType(), 0.05f)).build(consumer, this.sieveLoc("chorus_flower"));
        this.getLeavesSaplings().forEach((input, drop) -> {
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey(input);
            if (resourceLocation != null) {
                if (Objects.equals(ForgeRegistries.BLOCKS.getKey(input), new ResourceLocation("jungle_leaves"))) {
                    ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input})).addResult((ItemLike)drop)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_STRING.get()))).getType(), 0.025f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_FLINT.get()))).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_IRON.get()))).getType(), 0.075f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_DIAMOND.get()))).getType(), 0.1f)).build(consumer, this.sieveLoc(resourceLocation.m_135815_()));
                } else {
                    ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input})).addResult((ItemLike)drop)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_STRING.get()))).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_FLINT.get()))).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_IRON.get()))).getType(), 0.15f)).addRoll(new MeshWithChance(((MeshItem)((Object)((Object)ExNihiloItems.MESH_DIAMOND.get()))).getType(), 0.2f)).build(consumer, this.sieveLoc(resourceLocation.m_135815_()));
                }
            }
        });
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13143_)).addResult((ItemLike)Items.f_42410_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.15f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.2f)).build(consumer, this.sieveLoc("apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13143_)).addResult((ItemLike)Items.f_42436_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.001f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.003f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.005f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.01f)).build(consumer, this.sieveLoc("golden_apple"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13143_)).addResult((ItemLike)ExNihiloItems.SILKWORM.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.025f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.2f)).build(consumer, this.sieveLoc(SILKWORM));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)ExNihiloItems.TUBE_CORAL_LARVA.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_blue_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)ExNihiloItems.BUBBLE_CORAL_LARVA.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_purple_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)ExNihiloItems.BRAIN_CORAL_LARVA.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_pink_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)ExNihiloItems.HORN_CORAL_LARVA.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_yellow_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)ExNihiloItems.FIRE_CORAL_LARVA.get())).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seed_red_coral"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_204132_((TagKey)ItemTags.f_13137_)).addResult((ItemLike)Items.f_41867_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.05f)).isWaterlogged().build(consumer, this.sieveLoc("seagrass"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50546_})).addResult((ItemLike)Items.f_42329_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 1.0f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.4f)).build(consumer, this.sieveLoc("dirt"));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50546_})).addResult((ItemLike)Items.f_41832_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.4f)).build(consumer, this.sieveLoc(GRAVEL));
        ((SieveRecipeBuilder)SieveRecipeBuilder.builder().input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_49994_})).addResult((ItemLike)Items.f_151049_)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_STRING.get())).getType(), 0.05f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_FLINT.get())).getType(), 0.1f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_IRON.get())).getType(), 0.15f)).addRoll(new MeshWithChance(((MeshItem)((Object)ExNihiloItems.MESH_DIAMOND.get())).getType(), 0.2f)).build(consumer, this.sieveLoc("amethyst_shard"));
    }

    private void registerSieves(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_ACACIA, Items.f_42795_, Items.f_41918_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_BIRCH, Items.f_42753_, Items.f_41916_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_DARK_OAK, Items.f_42796_, Items.f_41919_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_JUNGLE, Items.f_42794_, Items.f_41917_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_MANGROVE, Items.f_220174_, Items.f_220183_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_OAK, Items.f_42647_, Items.f_41914_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_SPRUCE, Items.f_42700_, Items.f_41915_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_CRIMSON, Items.f_42797_, Items.f_41920_);
        this.createSieve(consumer, ExNihiloBlocks.SIEVE_WARPED, Items.f_42798_, Items.f_41921_);
    }
}

