/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.client;

import net.minecraft.data.DataGenerator;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;
import novamachina.exnihilosequentia.common.item.ore.Ore;
import novamachina.exnihilosequentia.common.utility.ExNihiloConstants;
import novamachina.exnihilosequentia.datagen.api.datagen.AbstractLangGenerator;

public class ExNihiloLangGenerator
extends AbstractLangGenerator {
    public ExNihiloLangGenerator(DataGenerator gen, String locale) {
        super(gen, "exnihilosequentia", locale);
    }

    @Override
    protected void addTranslations() {
        this.add("itemGroup.exnihilosequentia", "Ex Nihilo: Sequentia");
        this.addBlock();
        this.addItem();
        this.addCompat();
        this.addMisc();
    }

    private void addCompat() {
        String WAILA_LANG = "waila.";
        this.add("jei.sieve.dropChance", "Drop Chance");
        this.add("waila.progress", "Progress: %s");
        this.add("waila.barrel.fluidAmount", "Fluid(%s): %s mB");
        this.add("waila.barrel.solidAmount", "Solid(%s): %s / %s");
        this.add("waila.barrel.block", "Block: %s");
        this.add("waila.barrel.compost", "Compost: %s / %s");
        this.add("waila.sieve.block", "Sifting: %s");
        this.add("waila.sieve.mesh", "Mesh: %s");
        this.add("waila.crucible.fluid", "Fluid(%s): %s mB");
        this.add("waila.crucible.solid", "Solid(%s): %s");
        this.add("waila.crucible.heat", "Heat: %s");
        this.add("waila.crucible.no_heat", "No Heat Source");
        this.add("top.barrel.mode", "Mode: %s");
    }

    private void addMisc() {
        this.addFluid("witch_water", "Witch Water");
        this.addFluid("sea_water", "Sea Water");
        this.addFluid("witch_water_flow", "Flowing Witch Water");
        this.addFluid("sea_water_flow", "Flowing Sea Water");
        this.add("tooltip.doll.bee", "Add to a barrel of witch water to spawn a Bee");
        this.add("tooltip.doll.blaze", "Add to a barrel of lava to spawn a Blaze");
        this.add("tooltip.doll.enderman", "Add to a barrel of witch water to spawn an Enderman");
        this.add("tooltip.doll.guardian", "Add to a barrel of sea water to spawn a Guardian");
        this.add("tooltip.doll.shulker", "Add to a barrel of witch water to spawn a Shulker");
        this.add("exnihilosequentia.subtitle.pebbleThrow", "Pebble flies");
        this.add("throwing.pebble", "Flying Pebble");
        this.add("stat.exnihilosequentia.sieved", "Times Sieved");
        this.addJadeEntry("barrel");
        this.addJadeEntry("crucible");
        this.addJadeEntry("sieve");
        this.addJadeEntry("infesting_leaves");
    }

    private void addJadeEntry(String id) {
        this.add("config.jade.plugin_exnihilosequentia." + id, this.properNaming(id));
    }

    private void addItem() {
        for (Ore ore : ExNihiloItems.ORES) {
            this.addOreAutoName(ore);
        }
        for (MeshType mesh : MeshType.values()) {
            this.addMeshAutoName(mesh.getMeshName());
        }
        this.addItem("porcelain_doll", "Porcelain Doll");
        this.addItem("bee_doll", "Buzzing Doll");
        this.addItem("blaze_doll", "Blazing Doll");
        this.addItem("enderman_doll", "Creeping Doll");
        this.addItem("guardian_doll", "Protecting Doll");
        this.addItem("shulker_doll", "Floating Doll");
        for (String name : ExNihiloConstants.Items.resourceList) {
            this.addItemAutoName(name);
        }
    }

    private void addBlock() {
        for (int i = 0; i < ExNihiloConstants.Blocks.blocksList.size(); ++i) {
            this.addBlockAutoName(ExNihiloConstants.Blocks.blocksList.get(i));
        }
    }
}

