/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.datagen.api.datagen;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.block.BlockSieve;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;

public abstract class AbstractBlockStateGenerator
extends BlockStateProvider {
    @Nonnull
    protected static final String PARTICLE_TAG = "particle";

    protected AbstractBlockStateGenerator(@Nonnull DataGenerator gen, @Nonnull String modId, @Nonnull ExistingFileHelper exFileHelper) {
        super(gen, modId, exFileHelper);
    }

    @Nonnull
    protected ResourceLocation exnihiloLoc(@Nonnull String string) {
        return new ResourceLocation("exnihilosequentia", string);
    }

    protected ResourceLocation vanillaLoc(@Nonnull String string) {
        return new ResourceLocation("minecraft", string);
    }

    protected void basicBlock(@Nonnull Block block) {
        this.simpleItemBlock(block, this.cubeAll(block));
    }

    protected void registerFluid(@Nonnull Fluid fluid, ResourceLocation stillTexture) {
        ResourceLocation resourceLocation = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (resourceLocation != null) {
            ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder("block/" + resourceLocation.m_135815_())).texture(PARTICLE_TAG, stillTexture);
            this.getVariantBuilder(fluid.m_76145_().m_76188_().m_60734_()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    protected void simpleItemBlock(@Nonnull Block block, @Nonnull ModelFile modelFile) {
        this.simpleBlock(block, modelFile);
        this.simpleBlockItem(block, modelFile);
    }

    @Nullable
    protected String getRegistryName(@Nonnull Block b) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)b);
        if (resourceLocation != null) {
            return resourceLocation.toString();
        }
        return null;
    }

    protected void createBarrel(@Nonnull Block block, @Nonnull ResourceLocation texture, @Nonnull ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/barrel_base"))).texture("texture", texture)).texture(PARTICLE_TAG, particle));
        this.simpleItemBlock(block, model.model);
    }

    protected void createCake(@Nonnull Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 1; i < 7; ++i) {
            VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
            ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_slice" + i)));
            partialBlockstate.with((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{model});
        }
        VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
        ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_uneaten")));
        partialBlockstate.with((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{model});
    }

    protected void createCrucible(@Nonnull Block block, @Nonnull ResourceLocation texture, @Nonnull ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/crucible_base"))).texture(PARTICLE_TAG, particle)).texture("texture", texture));
        this.simpleItemBlock(block, model.model);
    }

    protected void createSieve(@Nonnull Block block, @Nonnull ResourceLocation texture, @Nonnull ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/sieve_base"))).texture("texture", texture)).texture(PARTICLE_TAG, particle));
        MultiPartBlockStateBuilder builder = this.getMultipartBuilder(block);
        MultiPartBlockStateBuilder.PartBuilder partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(model.model).addModel();
        partBuilder.end();
        for (MeshType mesh : MeshType.values()) {
            if (mesh == MeshType.NONE) continue;
            partBuilder = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)new ModelFile.ExistingModelFile(this.exnihiloLoc("block/" + mesh.getMeshName()), this.models().existingFileHelper)).addModel();
            partBuilder.condition(BlockSieve.MESH, (Comparable[])new MeshType[]{mesh});
            partBuilder.end();
        }
        this.simpleBlockItem(block, model.model);
    }
}

