/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import novamachina.exnihilosequentia.common.init.ExNihiloInitialization;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;
import novamachina.exnihilosequentia.common.utility.Config;

public class MeshItem
extends Item {
    private static final Map<MeshType, MeshItem> meshItemMap = new HashMap<MeshType, MeshItem>();
    private final String name;
    private final MeshType type;

    public MeshItem(String name, int maxDamage, MeshType type) {
        super(Config.enableMeshDurability() ? new Item.Properties().m_41491_(ExNihiloInitialization.ITEM_GROUP).m_41503_(maxDamage) : new Item.Properties().m_41491_(ExNihiloInitialization.ITEM_GROUP).m_41487_(Config.getMeshStackSize()));
        this.name = name;
        this.type = type;
        meshItemMap.put(type, this);
    }

    public static MeshItem getMesh(MeshType meshType) {
        return meshItemMap.get((Object)meshType);
    }

    public boolean canApplyAtEnchantingTable(@Nonnull ItemStack stack, @Nonnull Enchantment enchantment) {
        return enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44987_;
    }

    public int getBurnTime(@Nonnull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        if (((MeshItem)itemStack.m_41720_()).getType() == MeshType.STRING) {
            return 200;
        }
        return 0;
    }

    public int getLevel() {
        return this.type.getLevel();
    }

    public String getName() {
        return this.name;
    }

    public MeshType getType() {
        return this.type;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return true;
    }
}

