/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;

public class HammerRecipeSerializer
extends ExNihiloRecipeSerializer<HammerRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloItems.HAMMER_DIAMOND.get());
    }

    @Nonnull
    public HammerRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int outputCount = buffer.readInt();
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            output.add(ItemStackWithChance.read(buffer));
        }
        return new HammerRecipe(recipeId, input, output);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull HammerRecipe recipe) {
        recipe.getInput().m_43923_(buffer);
        buffer.writeInt(recipe.getOutput().size());
        for (ItemStackWithChance stack : recipe.getOutput()) {
            stack.write(buffer);
        }
    }

    @Override
    @Nonnull
    protected HammerRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<ItemStackWithChance> output = new ArrayList<ItemStackWithChance>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            output.add(ItemStackWithChance.deserialize(results.get(i)));
        }
        return new HammerRecipe(recipeId, input, output);
    }
}

