/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import novamachina.exnihilosequentia.common.blockentity.crucible.CrucibleTypeEnum;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.utility.FluidStackUtils;

public class CrucibleRecipeSerializer
extends ExNihiloRecipeSerializer<CrucibleRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)ExNihiloBlocks.CRUCIBLE_FIRED.get());
    }

    @Nonnull
    public CrucibleRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int amount = buffer.readInt();
        FluidStack fluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        CrucibleTypeEnum type = (CrucibleTypeEnum)buffer.m_130066_(CrucibleTypeEnum.class);
        return new CrucibleRecipe(recipeId, input, amount, fluid, type);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull CrucibleRecipe recipe) {
        recipe.getInput().m_43923_(buffer);
        buffer.writeInt(recipe.getAmount());
        recipe.getResultFluid().writeToPacket(buffer);
        buffer.m_130068_((Enum)recipe.getCrucibleType());
    }

    @Override
    @Nonnull
    protected CrucibleRecipe readFromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        int amount = json.get("amount").getAsInt();
        FluidStack fluid = FluidStackUtils.jsonDeserializeFluidStack(json.get("fluidResult").getAsJsonObject());
        CrucibleTypeEnum typeEnum = CrucibleTypeEnum.getTypeByName(json.get("crucibleType").getAsString());
        return new CrucibleRecipe(recipeId, input, amount, fluid, typeEnum);
    }
}

