/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.api.tag;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.item.ore.Ore;

public class ExNihiloTags {
    @Nonnull
    public static final TagKey<Item> CLAY = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("clay"));
    @Nonnull
    public static final TagKey<Item> HAMMER = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("hammer"));
    @Nonnull
    public static final TagKey<Item> CROOK = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("crook"));
    @Nonnull
    public static final TagKey<Item> MEAT_COOKED = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("meat_cooked"));
    @Nonnull
    public static final TagKey<Item> MEAT_UNCOOKED = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("meat_uncooked"));
    @Nonnull
    public static final TagKey<Item> CRUCIBLE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("crucibles"));
    @Nonnull
    public static final TagKey<Item> BARREL = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("barrels"));
    @Nonnull
    public static final TagKey<Item> SIEVE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("sieves"));
    @Nonnull
    public static final TagKey<Item> PIECE = ItemTags.create((ResourceLocation)ExNihiloTags.modLoc("pieces"));
    @Nonnull
    public static final TagKey<Block> MINEABLE_WITH_CROOK = BlockTags.create((ResourceLocation)ExNihiloTags.modLoc("mineable/crook"));
    @Nonnull
    public static final TagKey<Block> MINEABLE_WITH_HAMMER = BlockTags.create((ResourceLocation)ExNihiloTags.modLoc("mineable/hammer"));
    @Nonnull
    public static final OreTag IRON = new OreTag(ExNihiloItems.IRON);
    @Nonnull
    public static final OreTag GOLD = new OreTag(ExNihiloItems.GOLD);
    @Nonnull
    public static final OreTag COPPER = new OreTag(ExNihiloItems.COPPER);
    @Nonnull
    public static final OreTag LEAD = new OreTag(ExNihiloItems.LEAD);
    @Nonnull
    public static final OreTag NICKEL = new OreTag(ExNihiloItems.NICKEL);
    @Nonnull
    public static final OreTag SILVER = new OreTag(ExNihiloItems.SILVER);
    @Nonnull
    public static final OreTag TIN = new OreTag(ExNihiloItems.TIN);
    @Nonnull
    public static final OreTag ALUMINUM = new OreTag(ExNihiloItems.ALUMINUM);
    @Nonnull
    public static final OreTag PLATINUM = new OreTag(ExNihiloItems.PLATINUM);
    @Nonnull
    public static final OreTag URANIUM = new OreTag(ExNihiloItems.URANIUM);
    @Nonnull
    public static final OreTag ZINC = new OreTag(ExNihiloItems.ZINC);
    public static final TagKey<Item> NUGGET_COPPER = ItemTags.create((ResourceLocation)ExNihiloTags.forgeLoc("nuggets/copper"));

    private ExNihiloTags() {
    }

    @Nonnull
    public static ResourceLocation getIngot(@Nonnull String ingot) {
        return ExNihiloTags.forgeLoc("ingots/" + ingot);
    }

    @Nonnull
    public static ResourceLocation getRawMaterial(@Nonnull String ore) {
        return ExNihiloTags.forgeLoc("raw_materials/" + ore);
    }

    @Nonnull
    public static ResourceLocation getNugget(@Nonnull String ore) {
        return ExNihiloTags.forgeLoc("nuggets/" + ore);
    }

    @Nonnull
    private static ResourceLocation forgeLoc(@Nonnull String path) {
        return new ResourceLocation("forge", path);
    }

    @Nonnull
    private static ResourceLocation modLoc(@Nonnull String path) {
        return new ResourceLocation("exnihilosequentia", path);
    }

    public static class OreTag {
        @Nonnull
        private final TagKey<Item> ingot;
        @Nonnull
        private final TagKey<Item> rawMaterial;
        @Nonnull
        private final TagKey<Item> nugget;

        public OreTag(@Nonnull Ore ore) {
            this.ingot = ItemTags.create((ResourceLocation)ExNihiloTags.getIngot(ore.getOreName()));
            this.rawMaterial = ItemTags.create((ResourceLocation)ExNihiloTags.getRawMaterial(ore.getOreName()));
            this.nugget = ItemTags.create((ResourceLocation)ExNihiloTags.getNugget(ore.getOreName()));
        }

        @Nonnull
        public TagKey<Item> getIngotTag() {
            return this.ingot;
        }

        @Nonnull
        public TagKey<Item> getRawMaterialTag() {
            return this.rawMaterial;
        }

        public TagKey<Item> getNuggetTag() {
            return this.nugget;
        }
    }
}

