/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.util.Translator;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.modcompat.jei.RecipeRegistryJeiRecipeWrapper;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;

public class BloodInfuserRecipeJEI
extends RecipeRegistryJeiRecipeWrapper<IInventoryFluidTier, RecipeBloodInfuser, BloodInfuserRecipeJEI> {
    private final FluidStack inputFluid;
    private final int inputTier;
    private final List<ItemStack> inputItems;
    private final ItemStack outputItem;
    private final String xpString;
    private final int duration;

    public BloodInfuserRecipeJEI(RecipeBloodInfuser recipe) {
        super(RegistryEntries.RECIPETYPE_BLOOD_INFUSER, (Recipe)recipe);
        this.inputFluid = recipe.getInputFluid();
        this.inputTier = recipe.getInputTier();
        this.inputItems = Arrays.stream(recipe.getInputIngredient().m_43908_()).collect(Collectors.toList());
        this.outputItem = recipe.m_8043_();
        this.xpString = Translator.translateToLocalFormatted((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(recipe.getXp())});
        this.duration = recipe.getDuration();
    }

    protected BloodInfuserRecipeJEI() {
        super(RegistryEntries.RECIPETYPE_BLOOD_INFUSER, null);
        this.inputFluid = null;
        this.inputTier = -1;
        this.inputItems = null;
        this.outputItem = null;
        this.xpString = null;
        this.duration = 0;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getInputTier() {
        return this.inputTier;
    }

    public List<ItemStack> getInputItems() {
        return this.inputItems;
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public String getXpString() {
        return this.xpString;
    }

    public int getDuration() {
        return this.duration;
    }

    protected RecipeType<RecipeBloodInfuser> getRecipeType() {
        return RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
    }

    protected BloodInfuserRecipeJEI newInstance(RecipeBloodInfuser recipe) {
        return new BloodInfuserRecipeJEI(recipe);
    }

    public static List<BloodInfuserRecipeJEI> getAllRecipes() {
        return new BloodInfuserRecipeJEI().createAllRecipes().stream().sorted(Comparator.comparing(r -> r.inputTier)).collect(Collectors.toList());
    }
}

