/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.api.broom.IBroomPartRegistry;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class BroomPartRegistry
implements IBroomPartRegistry {
    private static final String NBT_TAG_NAME = "broom_parts_tag";
    private final Map<ResourceLocation, IBroomPart> parts = Maps.newLinkedHashMap();
    private final Multimap<IBroomPart, ItemStack> partItems = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<IBroomPart.BroomPartType, IBroomPart> partsByType = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<IBroomPart, Map<BroomModifier, Float>> baseModifiers = Maps.newHashMap();
    @OnlyIn(value=Dist.CLIENT)
    private Map<IBroomPart, ResourceLocation> partModels;

    public BroomPartRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (MinecraftHelpers.isClientSide()) {
            this.partModels = Maps.newHashMap();
        }
    }

    @Override
    public <P extends IBroomPart> P registerPart(P part) {
        Objects.requireNonNull(part);
        this.parts.put(part.getId(), part);
        this.partsByType.put((Object)part.getType(), part);
        return part;
    }

    @Override
    public <P extends IBroomPart> void registerPartItem(@Nullable P part, ItemStack item) {
        if (part != null) {
            Objects.requireNonNull(item.m_41720_());
            this.partItems.put(part, (Object)item);
        }
    }

    @Override
    public <P extends IBroomPart> void registerBaseModifiers(@Nullable P part, Map<BroomModifier, Float> modifiers) {
        if (part != null) {
            this.baseModifiers.put(part, modifiers);
        }
    }

    @Override
    public <P extends IBroomPart> void registerBaseModifiers(@Nullable P part, BroomModifier modifier, float modifierValue) {
        HashMap map = Maps.newHashMap();
        map.put(modifier, Float.valueOf(modifierValue));
        this.registerBaseModifiers(part, map);
    }

    @Override
    public <P extends IBroomPart> Map<BroomModifier, Float> getBaseModifiersFromPart(P part) {
        if (this.baseModifiers.containsKey(part)) {
            return this.baseModifiers.get(part);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<BroomModifier, Float> getBaseModifiersFromBroom(ItemStack broomStack) {
        HashMap baseModifiers = Maps.newHashMap();
        for (IBroomPart part : this.getBroomParts(broomStack)) {
            for (Map.Entry<BroomModifier, Float> entry : BroomParts.REGISTRY.getBaseModifiersFromPart(part).entrySet()) {
                BroomModifier modifier = entry.getKey();
                if (baseModifiers.containsKey(modifier)) {
                    baseModifiers.put(modifier, Float.valueOf(entry.getValue().floatValue() + ((Float)baseModifiers.get(modifier)).floatValue()));
                    continue;
                }
                baseModifiers.put(modifier, entry.getValue());
            }
        }
        return baseModifiers;
    }

    @Override
    public <P extends IBroomPart> Collection<ItemStack> getItemsFromPart(P part) {
        return Collections.unmodifiableCollection(this.partItems.get(part));
    }

    @Override
    public <P extends IBroomPart> P getPartFromItem(ItemStack item) {
        for (Map.Entry entry : this.partItems.entries()) {
            if (!ItemStack.m_41746_((ItemStack)item, (ItemStack)((ItemStack)entry.getValue())) || !ItemStack.m_41658_((ItemStack)item, (ItemStack)((ItemStack)entry.getValue()))) continue;
            return (P)((IBroomPart)entry.getKey());
        }
        return null;
    }

    @Override
    public Collection<IBroomPart> getParts() {
        return Collections.unmodifiableCollection(this.parts.values());
    }

    @Override
    public IBroomPart getPart(ResourceLocation partId) {
        return this.parts.get(partId);
    }

    @Override
    public Collection<IBroomPart> getParts(IBroomPart.BroomPartType type) {
        return Collections.unmodifiableCollection(this.partsByType.get((Object)type));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerPartModel(IBroomPart part, ResourceLocation modelLocation) {
        this.partModels.put(part, modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getPartModel(IBroomPart part) {
        return this.partModels.get(part);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Collection<ResourceLocation> getPartModels() {
        return Collections.unmodifiableCollection(this.partModels.values());
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack broomStack) {
        if (!broomStack.m_41619_()) {
            ArrayList parts = Lists.newArrayList();
            if (broomStack.m_41782_()) {
                ListTag tags = broomStack.m_41783_().m_128437_(NBT_TAG_NAME, 8);
                for (int i = 0; i < tags.size(); ++i) {
                    String id = tags.m_128778_(i);
                    IBroomPart part = this.getPart(new ResourceLocation(id));
                    if (part == null) continue;
                    parts.add(part);
                }
            }
            if (parts.isEmpty() && BroomParts.BRUSH_WHEAT != null) {
                return Lists.newArrayList((Object[])new IBroomPart[]{BroomParts.BRUSH_WHEAT, BroomParts.CAP_GEM_DARK, BroomParts.ROD_WOOD});
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public void setBroomParts(ItemStack broomStack, Collection<IBroomPart> broomParts) {
        ListTag list = new ListTag();
        for (IBroomPart broomPart : broomParts) {
            list.add((Object)StringTag.m_129297_((String)broomPart.getId().toString()));
        }
        if (!broomStack.m_41782_()) {
            broomStack.m_41751_(new CompoundTag());
        }
        broomStack.m_41783_().m_128365_(NBT_TAG_NAME, (Tag)list);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltipEvent(ItemTooltipEvent event) {
        Map<BroomModifier, Float> modifiers;
        Object part;
        if (ItemBroomConfig.broomPartTooltips && (part = this.getPartFromItem(event.getItemStack())) != null && !(modifiers = this.getBaseModifiersFromPart(part)).isEmpty()) {
            if (MinecraftHelpers.isShifted()) {
                event.getToolTip().add(Component.m_237115_((String)"broom.modifiers.evilcraft.types").m_130940_(ChatFormatting.ITALIC));
                for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
                    event.getToolTip().add(entry.getKey().getTooltipLine("  ", entry.getValue().floatValue(), 0.0f, false));
                }
            } else {
                event.getToolTip().add(Component.m_237115_((String)"broom.parts.evilcraft.shiftinfo").m_130940_(ChatFormatting.ITALIC));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void beforeItemsRegistered(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            this.parts.clear();
            this.partItems.clear();
            this.partsByType.clear();
            this.baseModifiers.clear();
            if (MinecraftHelpers.isClientSide()) {
                this.partModels.clear();
            }
        }
    }
}

