/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.Advancements;
import org.cyclops.evilcraft.EvilCraftSoundEvents;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class BlockEntityBoxOfEternalClosure
extends CyclopsBlockEntity {
    public static final String NBTKEY_SPIRIT = "spiritTag";
    public static final String NBTKEY_PLAYERID = "playerId";
    public static final String NBTKEY_PLAYERNAME = "playerName";
    public static final float START_LID_ANGLE = 65.0f;
    private static final int TICK_MODULUS = 10;
    private static final int TARGET_RADIUS = 10;
    private static final double ABSORB_RADIUS = 0.5;
    private static final int NO_TARGET = -1;
    private static final float LID_STEP = 11.5f;
    public int innerRotation;
    @NBTPersist
    private CompoundTag spiritTag = new CompoundTag();
    @NBTPersist
    private String playerId = "";
    @NBTPersist
    private String playerName = "";
    private EntityVengeanceSpiritData spiritData = null;
    private EntityVengeanceSpirit targetSpirit = null;
    @NBTPersist(useDefaultValue=false)
    private Integer targetSpiritId = -1;
    @NBTPersist(useDefaultValue=false)
    private Float lidAngle = Float.valueOf(65.0f);
    private float previousLidAngle = 65.0f;
    private State state = State.UNKNOWN;

    public BlockEntityBoxOfEternalClosure(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_BOX_OF_ETERNAL_CLOSURE, blockPos, blockState);
        this.innerRotation = new Random().nextInt(100000);
    }

    @Nullable
    public static EntityType<?> getSpiritType(@Nullable CompoundTag tag) {
        if (tag != null) {
            CompoundTag spiritTag = tag.m_128469_(NBTKEY_SPIRIT);
            return EntityVengeanceSpiritData.getSpiritType(spiritTag);
        }
        return null;
    }

    public CompoundTag getSpiritTag() {
        if (this.spiritTag == null) {
            this.spiritTag = new CompoundTag();
        }
        return this.spiritTag;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
        this.m_6596_();
        this.sendUpdate();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.m_6596_();
        this.sendUpdate();
    }

    public void setSpiritTag(CompoundTag tag) {
        this.spiritTag = tag;
        this.m_6596_();
        this.sendUpdate();
    }

    public boolean isClosed() {
        return this.getState() == State.CLOSED;
    }

    public State getState() {
        if (this.state == State.UNKNOWN) {
            this.updateState();
        }
        return this.state;
    }

    private void setState(State newState) {
        if (newState != this.state) {
            State oldState = this.state;
            this.state = newState;
            this.onStateChanged(oldState, this.state);
        }
    }

    private void updateState() {
        if (this.lidAngle.floatValue() <= 0.0f) {
            this.setState(State.CLOSED);
        } else if (this.lidAngle.floatValue() >= 65.0f) {
            this.setState(State.OPEN);
        }
    }

    private void onStateChanged(State oldState, State newState) {
        if (oldState == State.UNKNOWN) {
            return;
        }
        switch (this.state) {
            case OPEN: {
                this.onBoxOpened();
                break;
            }
            case CLOSED: {
                this.onBoxClosed();
                break;
            }
            case OPENING: {
                this.onBoxOpening();
                break;
            }
            case CLOSING: {
                this.onBoxClosing();
                break;
            }
        }
    }

    private void onBoxOpened() {
        if (!this.f_58857_.m_5776_() && this.hasSpirit()) {
            this.releaseSpirit();
        }
    }

    private void onBoxClosed() {
    }

    private void onBoxOpening() {
        if (this.f_58857_.m_5776_()) {
            this.playOpenSound();
        }
    }

    private void onBoxClosing() {
        if (this.f_58857_.m_5776_()) {
            this.playCloseSound();
        }
    }

    public boolean hasSpirit() {
        return !this.getSpiritTag().m_128456_();
    }

    private void releaseSpirit() {
        EntityVengeanceSpirit spirit = this.createNewVengeanceSpirit();
        this.f_58857_.m_7967_((Entity)spirit);
        this.clearSpirit();
    }

    private void playOpenSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, pitch);
    }

    private void playCloseSound() {
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, pitch);
    }

    private EntityVengeanceSpirit createNewVengeanceSpirit() {
        RandomSource rand = this.f_58857_.f_46441_;
        EntityVengeanceSpirit spirit = EntityVengeanceSpirit.fromNBT(this.m_58904_(), this.getSpiritTag());
        spirit.m_6034_((double)this.m_58899_().m_123341_() + rand.m_188500_(), (double)this.m_58899_().m_123342_() + rand.m_188500_(), (double)this.m_58899_().m_123343_() + rand.m_188500_());
        spirit.setFrozenDuration(0);
        spirit.setGlobalVengeance(true);
        spirit.setRemainingLife(Mth.m_216271_((RandomSource)this.f_58857_.f_46441_, (int)250, (int)1000));
        return spirit;
    }

    private void clearSpirit() {
        this.spiritTag = new CompoundTag();
        this.spiritData = null;
    }

    private float randomFloat(float min, float max) {
        return min + this.f_58857_.f_46441_.m_188501_() * max;
    }

    private void playSound(SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.f_58857_.m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), sound, category, volume, pitch, false);
    }

    public void open() {
        this.setState(State.OPENING);
    }

    public void close() {
        this.setState(State.CLOSING);
    }

    public void initializeState() {
        if (this.hasSpirit()) {
            this.setState(State.CLOSED);
        } else {
            this.setState(State.OPEN);
        }
    }

    private void initializeLidAngle() {
        if (this.getState() == State.OPEN) {
            this.lidAngle = Float.valueOf(65.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        } else if (this.getState() == State.CLOSED) {
            this.lidAngle = Float.valueOf(0.0f);
            this.previousLidAngle = this.lidAngle.floatValue();
        }
    }

    private void setSpirit(EntityVengeanceSpirit spirit) {
        spirit.getData().writeNBT(this.getSpiritTag());
    }

    private void updateLidAngle() {
        State state = this.getState();
        this.previousLidAngle = this.lidAngle.floatValue();
        if (state == State.OPENING) {
            this.incrementLidAngle(11.5f);
        } else if (state == State.CLOSING) {
            this.incrementLidAngle(-11.5f);
        }
        if (state == State.OPENING || state == State.CLOSING) {
            this.updateState();
        }
    }

    private void pullEntity() {
        EntityVengeanceSpirit target = this.getTargetSpirit();
        if (target != null) {
            double dx = this.targetSpirit.m_20185_() - (double)this.m_58899_().m_123341_() - 0.5;
            double dy = this.targetSpirit.m_20186_() - (double)this.m_58899_().m_123342_() - 0.5;
            double dz = this.targetSpirit.m_20189_() - (double)this.m_58899_().m_123343_() - 0.5;
            double distance = Mth.m_14116_((float)((float)(dx * dx + dy * dy + dz * dz)));
            if (!target.m_6084_() || !target.isFrozen()) {
                this.setTargetSpirit(null);
            } else {
                BlockPos blockPos = this.m_58899_();
                AABB boxBoundingBox = this.m_58900_().m_60812_((BlockGetter)this.f_58857_, blockPos).m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()).m_83215_();
                AABB spiritBoundingBox = target.m_20191_().m_82400_(0.5);
                boolean spiritTrapped = spiritBoundingBox.m_82381_(boxBoundingBox);
                if (spiritTrapped) {
                    this.captureSpirit(this.targetSpirit);
                    this.close();
                } else {
                    double strength = 1.0 / distance / 50.0 + 0.01;
                    target.m_20256_(target.m_20184_().m_82492_(dx * strength, dy * strength, dz * strength));
                }
            }
        }
    }

    private void captureSpirit(EntityVengeanceSpirit targetSpirit) {
        for (ServerPlayer player : targetSpirit.getEntanglingPlayers()) {
            Advancements.BOX_OF_ETERNAL_CLOSURE_CAPTURE.test(player, (Entity)targetSpirit.getInnerEntity());
        }
        targetSpirit.m_142687_(Entity.RemovalReason.DISCARDED);
        this.playerId = targetSpirit.getPlayerId();
        this.playerName = targetSpirit.getPlayerName();
        this.setSpirit(targetSpirit);
        this.setTargetSpirit(null);
        this.close();
    }

    private boolean findsOrHasTargetEntity() {
        return this.hasTargetSpirit() || this.findsTargetEntity();
    }

    private boolean findsTargetEntity() {
        return WorldHelpers.efficientTick((Level)this.m_58904_(), (int)10, (BlockPos)this.m_58899_()) && this.findNextEntity();
    }

    private boolean hasTargetSpirit() {
        return this.getTargetSpirit() != null;
    }

    private void playBeamSound() {
        float volume = this.randomFloat(0.1f, 0.9f);
        float pitch = this.randomFloat(0.1f, 0.9f);
        this.playSound(EvilCraftSoundEvents.effect_box_beam, SoundSource.AMBIENT, volume, pitch);
    }

    private boolean findNextEntity() {
        AABB box = new AABB((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()).m_82377_(10.0, 10.0, 10.0);
        List entities = this.f_58857_.m_45976_(EntityVengeanceSpirit.class, box);
        double minDistanceSquared = Math.pow(11.0, 2.0);
        EntityVengeanceSpirit closest = null;
        for (EntityVengeanceSpirit spirit : entities) {
            double distance;
            if (!spirit.isFrozen() || spirit.isSwarm() || !((distance = spirit.m_20275_(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_())) < minDistanceSquared)) continue;
            minDistanceSquared = distance;
            closest = spirit;
        }
        this.setTargetSpirit(closest);
        return this.targetSpirit != null;
    }

    protected void updateLight() {
        BlockState blockState = this.m_58904_().m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), blockState, blockState, 3);
    }

    public float getLidAngle() {
        return this.lidAngle.floatValue();
    }

    private void setLidAngle(float newLidAngle) {
        if (newLidAngle != this.lidAngle.floatValue()) {
            this.lidAngle = Float.valueOf(newLidAngle);
            if (this.lidAngle.floatValue() < 0.0f) {
                this.lidAngle = Float.valueOf(0.0f);
                this.updateLight();
            } else if (this.lidAngle.floatValue() > 65.0f) {
                this.lidAngle = Float.valueOf(65.0f);
                this.updateLight();
            }
        }
    }

    private void incrementLidAngle(float increment) {
        this.setLidAngle(this.lidAngle.floatValue() + increment);
    }

    public float getPreviousLidAngle() {
        return this.previousLidAngle;
    }

    public EntityVengeanceSpirit getTargetSpirit() {
        if (this.m_58904_().m_5776_() && this.targetSpiritId == -1) {
            this.targetSpirit = null;
        } else if (this.targetSpirit == null && this.targetSpiritId != -1) {
            this.setTargetSpirit((EntityVengeanceSpirit)this.m_58904_().m_6815_(this.targetSpiritId.intValue()));
        }
        return this.targetSpirit;
    }

    private void setTargetSpirit(EntityVengeanceSpirit targetSpirit) {
        EntityVengeanceSpirit old = this.targetSpirit;
        this.targetSpirit = targetSpirit;
        this.targetSpiritId = targetSpirit != null ? Integer.valueOf(targetSpirit.m_19879_()) : Integer.valueOf(-1);
        if (old != targetSpirit) {
            this.sendUpdate();
        }
    }

    public EntityVengeanceSpiritData getSpiritData() {
        return this.hasSpirit() ? this.loadSpiritDataLazy() : null;
    }

    private EntityVengeanceSpiritData loadSpiritDataLazy() {
        if (this.spiritData == null) {
            this.spiritData = EntityVengeanceSpiritData.fromNBT(this.getSpiritTag());
        }
        return this.spiritData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.initializeState();
        this.initializeLidAngle();
    }

    public static enum State {
        UNKNOWN,
        OPEN,
        OPENING,
        CLOSING,
        CLOSED;

    }

    public static class TickerClient
    extends BlockEntityTickerDelayed<BlockEntityBoxOfEternalClosure> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBoxOfEternalClosure blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            ++blockEntity.innerRotation;
            if (blockEntity.hasTargetSpirit()) {
                blockEntity.playBeamSound();
            }
            blockEntity.updateLidAngle();
        }
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityBoxOfEternalClosure> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityBoxOfEternalClosure blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            ++blockEntity.innerRotation;
            if (!blockEntity.hasSpirit() && blockEntity.findsOrHasTargetEntity()) {
                blockEntity.pullEntity();
            }
            blockEntity.updateLidAngle();
        }

        protected void onSendUpdate(Level level, BlockPos pos) {
            super.onSendUpdate(level, pos);
            level.m_46672_(pos, level.m_8055_(pos).m_60734_());
        }
    }
}

