/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntityBloodStain
extends CyclopsBlockEntity {
    public static final int CAPACITY = 5000;
    @NBTPersist
    private Integer amount = 0;

    public BlockEntityBloodStain(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_BLOOD_STAIN, blockPos, blockState);
        this.addCapabilityInternal(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, LazyOptional.of(() -> new FluidHandler(this)));
    }

    public int getAmount() {
        return this.amount;
    }

    public void addAmount(int amount) {
        this.amount = Math.min(5000, Math.max(0, this.amount + amount));
        if (this.amount == 0) {
            this.m_58904_().m_7471_(this.m_58899_(), false);
        }
        this.m_6596_();
    }

    public static class FluidHandler
    implements IFluidHandler {
        private final BlockEntityBloodStain tile;

        public FluidHandler(BlockEntityBloodStain tile) {
            this.tile = tile;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, this.tile.getAmount());
        }

        public int getTankCapacity(int tank) {
            return 5000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && stack.getFluid() == RegistryEntries.FLUID_BLOOD;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == RegistryEntries.FLUID_BLOOD) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            maxDrain = Math.min(this.tile.getAmount(), maxDrain);
            FluidStack drained = new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, maxDrain);
            if (action.execute()) {
                this.tile.addAmount(-maxDrain);
            }
            return drained;
        }
    }
}

