/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBloodInfuser;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.FluidContainerItemTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodinfuser.InfuseItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.core.recipe.type.InventoryFluidTier;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.inventory.container.ContainerBloodInfuser;

public class BlockEntityBloodInfuser
extends BlockEntityWorking<BlockEntityBloodInfuser, MutableInt>
implements MenuProvider {
    public static final int SLOTS = 3;
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_INFUSE = 1;
    public static final int SLOT_INFUSE_RESULT = 2;
    public static final int LIQUID_PER_SLOT = 10000;
    public static Metadata METADATA = new Metadata();
    private int infuseTicker = this.addTicker(new TickComponent<BlockEntityBloodInfuser, ITickAction<BlockEntityBloodInfuser>>(this, INFUSE_TICK_ACTIONS, 1));
    private SingleCache<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>> recipeCache;
    private float xp;
    private static final Multimap<Class<?>, ITickAction<BlockEntityBloodInfuser>> INFUSE_TICK_ACTIONS = LinkedListMultimap.create();
    private static final Map<Class<?>, ITickAction<BlockEntityBloodInfuser>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_FILLBLOODPERTICK;

    public BlockEntityBloodInfuser(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_BLOOD_INFUSER, blockPos, blockState, 3, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        this.addTicker(new TickComponent<BlockEntityBloodInfuser, ITickAction<BlockEntityBloodInfuser>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntityBloodInfuser, MutableInt>(2.0){

            @Override
            public void applyUpgrade(BlockEntityBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntityBloodInfuser, MutableInt>(1.0){

            @Override
            public void applyUpgrade(BlockEntityBloodInfuser upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableInt> event) {
                if (event.getType() == UPGRADEEVENT_FILLBLOODPERTICK) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val * (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                } else if (event.getType() == UPGRADEEVENT_SPEED) {
                    int val = event.getObject().getValue();
                    val = (int)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Triple<ItemStack, Integer, Integer>, Optional<RecipeBloodInfuser>>(){

            public Optional<RecipeBloodInfuser> getNewValue(Triple<ItemStack, Integer, Integer> key) {
                InventoryFluidTier recipeInput = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), (NonNullList<FluidStack>)NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, ((Integer)key.getMiddle()).intValue())}), (Integer)key.getRight());
                return BlockEntityBloodInfuser.this.f_58857_.m_7465_().m_44056_(BlockEntityBloodInfuser.this.getRegistry(), (Container)recipeInput, BlockEntityBloodInfuser.this.m_58904_()).stream().max(Comparator.comparingInt(RecipeBloodInfuser::getInputTier));
            }

            public boolean isKeyEqual(Triple<ItemStack, Integer, Integer> cacheKey, Triple<ItemStack, Integer, Integer> newKey) {
                return cacheKey == null || newKey == null || ItemStack.m_41728_((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && ((Integer)cacheKey.getMiddle()).equals(newKey.getMiddle()) && ((Integer)cacheKey.getRight()).equals(newKey.getRight());
            }
        });
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerInfuse = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{1}));
        LazyOptional itemHandlerInfuseResult = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{2}));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0}));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, itemHandlerInfuse);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, itemHandlerInfuseResult);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, itemHandlerContainer);
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new Inventory(inventorySize, stackSize, this);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        data.m_128350_("xp", this.xp);
        super.m_183515_(data);
    }

    @Override
    public void read(CompoundTag data) {
        this.xp = data.m_128457_("xp");
        super.read(data);
    }

    public Direction getRotation() {
        return ((Direction)BlockHelpers.getSafeBlockStateProperty((BlockState)this.m_58900_(), (Property)BlockBloodInfuser.FACING, (Comparable)Direction.NORTH)).m_122424_();
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public Optional<RecipeBloodInfuser> getRecipe(ItemStack itemStack) {
        return (Optional)this.recipeCache.get((Object)Triple.of((Object)(itemStack.m_41619_() ? ItemStack.f_41583_ : itemStack.m_41777_()), (Object)this.getTank().getFluidAmount(), (Object)this.getTileWorkingMetadata().getTier((Container)this.getInventory())));
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockBloodInfuser.ON, (Comparable)Boolean.valueOf(this.isWorking())));
        BlockHelpers.markForUpdate((Level)this.m_58904_(), (BlockPos)this.m_58899_());
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    protected int getWorkTicker() {
        return this.infuseTicker;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, net.minecraft.world.entity.player.Inventory playerInventory, Player playerEntity) {
        return new ContainerBloodInfuser(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public RecipeType<RecipeBloodInfuser> getRegistry() {
        return RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.evilcraft.blood_infuser");
    }

    public void setXp(float xp) {
        this.xp = xp;
        this.m_6596_();
    }

    public float getXp() {
        return this.xp;
    }

    public void addXp(float xp) {
        this.setXp(this.getXp() + xp);
    }

    public void resetXp() {
        this.setXp(0.0f);
    }

    static {
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new FluidContainerItemTickAction());
        INFUSE_TICK_ACTIONS.put(Item.class, (Object)new InfuseItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 2;
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_FILLBLOODPERTICK = Upgrades.newUpgradeEventType();
    }

    public static class Inventory
    extends BlockEntityWorking.Inventory<BlockEntityBloodInfuser> {
        public Inventory(int size, int stackLimit, BlockEntityBloodInfuser tile) {
            super(size, stackLimit, tile);
        }

        @Override
        public boolean m_7013_(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return ((BlockEntityBloodInfuser)this.tile).getTileWorkingMetadata().canConsume(itemStack, ((BlockEntityBloodInfuser)this.tile).m_58904_());
            }
            if (slot == 0) {
                return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
            }
            return super.m_7013_(slot, itemStack);
        }
    }

    public static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(3);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            LazyOptional fluidHandler;
            if (!itemStack.m_41619_() && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack.m_41777_().m_41620_(1))).isPresent()) {
                return true;
            }
            InventoryFluidTier recipeInput = new InventoryFluidTier((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{itemStack}), (NonNullList<FluidStack>)NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{new FluidStack((Fluid)RegistryEntries.FLUID_BLOOD, Integer.MAX_VALUE)}), 3);
            return world.m_7465_().m_44015_(RegistryEntries.RECIPETYPE_BLOOD_INFUSER, (Container)recipeInput, world).isPresent();
        }

        @Override
        public boolean canInsertItem(Container inventory, int slot, ItemStack itemStack) {
            return slot != this.getProduceSlot() && super.canInsertItem(inventory, slot, itemStack);
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_BLOOD_INFUSER;
        }

        public int getConsumeSlot() {
            return 1;
        }

        public int getProduceSlot() {
            return 2;
        }
    }
}

