/*
 * Decompiled with CFR 0.152.
 */
package top.seraphjack.simplelogin.server.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import top.seraphjack.simplelogin.server.capability.CapabilityLoader;
import top.seraphjack.simplelogin.server.capability.ILastPos;
import top.seraphjack.simplelogin.server.storage.Position;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public class CapabilityLastPos {
    public static final Position defaultPosition = new Position(0.0, 255.0, 0.0);

    public static class Implementation
    implements ILastPos {
        Position lastPos = defaultPosition;

        @Override
        public Position getLastPos() {
            return this.lastPos;
        }

        @Override
        public void setLastPos(Position pos) {
            this.lastPos = pos;
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        private final ILastPos lastPos = new Implementation();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityLoader.CAPABILITY_LAST_POS) {
                return LazyOptional.of(() -> this.lastPos);
            }
            return LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.lastPos.getLastPos().toNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.lastPos.setLastPos(Position.fromNBT((CompoundTag)nbt));
        }
    }
}

