/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfig;

public class FluidAction
extends ConfigurableTypeAction<FluidConfig, ForgeFlowingFluid.Properties> {
    private final Multimap<String, Pair<FluidConfig, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Pair<FluidConfig, Callable<?>>>>(){

        public List<Pair<FluidConfig, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private boolean registryEventPassed = false;

    public FluidAction() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void onRegisterForge(FluidConfig config) {
        if (this.registryEventPassed) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)ForgeRegistries.FLUIDS.getRegistryKey().toString(), (Object)Pair.of((Object)config, () -> {
            config.onForgeRegistered();
            return null;
        }));
    }

    @SubscribeEvent
    public void onRegistryEvent(RegisterEvent event) {
        if (event.getRegistryKey() == ForgeRegistries.FLUIDS.getRegistryKey()) {
            this.registryEventPassed = true;
            IForgeRegistry registry = event.getForgeRegistry();
            this.registryEntriesHolder.get((Object)registry.getRegistryKey().toString()).forEach(pair -> {
                FluidConfig config = (FluidConfig)pair.getLeft();
                ForgeFlowingFluid.Properties instance = (ForgeFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier still = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"still");
                java.util.function.Supplier flowing = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"flowing");
                this.registerFluid((IForgeRegistry<Fluid>)registry, still, new ResourceLocation(config.getMod().getModId(), config.getNamedId()));
                this.registerFluid((IForgeRegistry<Fluid>)registry, flowing, new ResourceLocation(config.getMod().getModId(), config.getNamedId() + "_flowing"));
                try {
                    if (pair.getRight() != null) {
                        ((Callable)pair.getRight()).call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (event.getRegistryKey() == ((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get()).getRegistryKey()) {
            this.registryEntriesHolder.get((Object)ForgeRegistries.FLUIDS.getRegistryKey().toString()).forEach(pair -> {
                FluidConfig config = (FluidConfig)pair.getLeft();
                ForgeFlowingFluid.Properties instance = (ForgeFlowingFluid.Properties)config.getInstance();
                java.util.function.Supplier fluidType = (java.util.function.Supplier)ObfuscationReflectionHelper.getPrivateValue(ForgeFlowingFluid.Properties.class, (Object)instance, (String)"fluidType");
                event.getForgeRegistry().register(new ResourceLocation(config.getMod().getModId(), config.getNamedId()), (Object)((FluidType)fluidType.get()));
            });
        }
    }

    protected void registerFluid(IForgeRegistry<Fluid> registry, java.util.function.Supplier<? extends Fluid> fluidSupplier, ResourceLocation name) {
        registry.register(name, (Object)fluidSupplier.get());
    }
}

