/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackUtil {
    public static int countEmptySlots(IItemHandler handler) {
        if (handler == null) {
            return 0;
        }
        int empty = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).m_41619_()) continue;
            ++empty;
        }
        return empty;
    }

    public static ItemStack findItem(String id) {
        Item head = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)id));
        if (head != null) {
            return new ItemStack((ItemLike)head);
        }
        return ItemStack.f_41583_;
    }

    public static void repairItem(ItemStack s) {
        ItemStackUtil.repairItem(s, 1);
    }

    public static void repairItem(ItemStack s, int amount) {
        s.m_41721_(Math.max(0, s.m_41773_() - amount));
    }

    public static void damageItem(LivingEntity player, ItemStack stack) {
        if (!stack.m_41763_()) {
            return;
        }
        if (player == null) {
            stack.m_41721_(stack.m_41773_() + 1);
        } else {
            stack.m_41622_(1, player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        if (stack.m_41773_() >= stack.m_41776_()) {
            stack.m_41774_(1);
            stack = ItemStack.f_41583_;
        }
    }

    public static void damageItemRandomly(LivingEntity player, ItemStack stack) {
        if (player.f_19853_.f_46441_.m_188500_() < 0.001) {
            ItemStackUtil.damageItem(player, stack);
        }
    }

    public static void drop(Level world, BlockPos pos, Block drop) {
        ItemStackUtil.drop(world, pos, new ItemStack((ItemLike)drop.m_5456_()));
    }

    public static void drop(Level world, BlockPos pos, ItemStack drop) {
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), drop));
        }
    }

    public static boolean matches(ItemStack current, ItemStack in) {
        return ItemStack.m_41758_((ItemStack)current, (ItemStack)in) && ItemStack.m_41658_((ItemStack)current, (ItemStack)in);
    }

    public static void shrink(Player player, ItemStack stac) {
        if (!player.m_7500_()) {
            stac.m_41774_(1);
        }
    }

    public static void drop(Level world, BlockPos center, List<ItemStack> lootDrops) {
        for (ItemStack dropMe : lootDrops) {
            ItemStackUtil.drop(world, center, dropMe);
        }
    }

    public static void dropItemStackMotionless(Level world, BlockPos pos, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        if (!world.f_46443_) {
            ItemEntity entityItem = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
            world.m_7967_((Entity)entityItem);
            entityItem.m_20334_(0.0, 0.0, 0.0);
        }
    }

    public static void deleteTag(ItemStack itemstack) {
        int dmg = itemstack.m_41773_();
        itemstack.m_41751_(null);
        itemstack.m_41721_(dmg);
    }
}

