/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.fluid.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class SlimeFluidBlock
extends LiquidBlock {
    VoxelShape[] shapes = new VoxelShape[16];

    public SlimeFluidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties props) {
        super(supplier, props);
        int max = 15;
        float offset = 0.875f;
        for (int i = 0; i <= max; ++i) {
            this.shapes[i] = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, (double)(offset - (float)i / 8.0f), 1.0));
        }
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[(Integer)state.m_61143_((Property)f_54688_)];
    }

    @Deprecated
    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.shapes[(Integer)state.m_61143_((Property)f_54688_)];
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.m_20162_()) {
            super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
        }
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(worldIn, entityIn);
        } else {
            this.collision(entityIn);
        }
    }

    private void collision(Entity entity) {
        Vec3 vec3d = entity.m_20184_();
        if (vec3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * d0, vec3d.f_82481_);
        }
    }

    public static class Source
    extends ForgeFlowingFluid.Source {
        public Source(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_6719_(LevelReader worldIn) {
            return 1;
        }

        public int m_6713_(LevelReader worldIn) {
            return 6;
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing {
        public Flowing(ForgeFlowingFluid.Properties properties) {
            super(properties);
        }

        public int m_6719_(LevelReader worldIn) {
            return 1;
        }

        public int m_6713_(LevelReader worldIn) {
            return 2;
        }
    }
}

