/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.packager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.Tags;

public class UtilPackager {
    private static final Map<Item, CraftingRecipe> fourItemRecipeCache = new HashMap<Item, CraftingRecipe>();
    private static final Map<Item, CraftingRecipe> nineItemRecipeCache = new HashMap<Item, CraftingRecipe>();
    private static final Map<CraftingRecipe, Integer> ingredientsInRecipeCache = new HashMap<CraftingRecipe, Integer>();
    private static final Map<Item, Boolean> itemValidCache = new HashMap<Item, Boolean>();
    private static final Map<CraftingRecipe, Boolean> recipeValidCache = new HashMap<CraftingRecipe, Boolean>();

    private UtilPackager() {
    }

    private static Map<Item, CraftingRecipe> getFourItemRecipeCache(RecipeManager recipeManager) {
        if (fourItemRecipeCache.isEmpty()) {
            UtilPackager.buildRecipeCaches(recipeManager);
        }
        return fourItemRecipeCache;
    }

    public static int getIngredientsInRecipe(CraftingRecipe recipe) {
        return ingredientsInRecipeCache.computeIfAbsent(recipe, k -> {
            int count = 0;
            for (Ingredient ingredient : recipe.m_7527_()) {
                ItemStack[] matchingStacks;
                if (ingredient == Ingredient.f_43901_ || (matchingStacks = ingredient.m_43908_()).length == 0) continue;
                ++count;
            }
            return count;
        });
    }

    private static Map<Item, CraftingRecipe> getNineItemRecipeCache(RecipeManager recipeManager) {
        if (nineItemRecipeCache.isEmpty()) {
            UtilPackager.buildRecipeCaches(recipeManager);
        }
        return nineItemRecipeCache;
    }

    public static CraftingRecipe getRecipeForItemStack(RecipeManager recipeManager, ItemStack itemStack) {
        CraftingRecipe recipe;
        if (itemStack.m_41613_() >= 9 && (recipe = UtilPackager.getNineItemRecipeCache(recipeManager).get(itemStack.m_41720_())) != null) {
            return recipe;
        }
        if (itemStack.m_41613_() >= 4) {
            return UtilPackager.getFourItemRecipeCache(recipeManager).get(itemStack.m_41720_());
        }
        return null;
    }

    public static boolean isItemStackValid(RecipeManager recipeManager, ItemStack itemStack) {
        return itemValidCache.computeIfAbsent(itemStack.m_41720_(), item -> UtilPackager.getFourItemRecipeCache(recipeManager).containsKey(item) || UtilPackager.getNineItemRecipeCache(recipeManager).containsKey(item));
    }

    public static boolean isRecipeValid(CraftingRecipe recipe) {
        return recipeValidCache.computeIfAbsent(recipe, k -> {
            ItemStack recipeOutput = recipe.m_8043_();
            if (recipeOutput.m_41741_() == 1 || recipeOutput.m_41613_() != 1) {
                return false;
            }
            Ingredient mainIngredient = null;
            ItemStack mainIngredientStack = null;
            int count = 0;
            for (Ingredient ingredient : recipe.m_7527_()) {
                ItemStack[] matchingStacks;
                if (ingredient == Ingredient.f_43901_ || (matchingStacks = ingredient.m_43908_()).length == 0) continue;
                ItemStack matchingStack = matchingStacks[0];
                if (mainIngredient != null && !mainIngredient.test(matchingStack)) {
                    return false;
                }
                mainIngredient = ingredient;
                mainIngredientStack = matchingStack;
                ++count;
            }
            if (mainIngredient == null) {
                return false;
            }
            boolean outIsStorage = recipeOutput.m_204117_(Tags.Items.STORAGE_BLOCKS);
            boolean inIsIngot = mainIngredientStack.m_204117_(Tags.Items.INGOTS);
            if (!outIsStorage && inIsIngot) {
                return false;
            }
            return count == 4 || count == 9;
        });
    }

    public static void buildRecipeCaches(RecipeManager recipeManager) {
        block0: for (CraftingRecipe recipe : recipeManager.m_44013_(RecipeType.f_44107_)) {
            ItemStack recipeOutput = recipe.m_8043_();
            if (recipeOutput.m_41741_() == 1 || recipeOutput.m_41613_() != 1) continue;
            Ingredient mainIngredient = null;
            ItemStack mainIngredientStack = null;
            int count = 0;
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (ingredient == Ingredient.f_43901_) continue;
                ItemStack[] matchingStacks = ingredient.m_43908_();
                if (matchingStacks.length != 1) {
                    recipeValidCache.put(recipe, false);
                    continue block0;
                }
                ItemStack matchingStack = matchingStacks[0];
                if (mainIngredient != null && !mainIngredient.test(matchingStack)) {
                    recipeValidCache.put(recipe, false);
                    continue block0;
                }
                mainIngredient = ingredient;
                mainIngredientStack = matchingStack;
                ++count;
            }
            if (mainIngredient == null) continue;
            boolean outIsStorage = recipeOutput.m_204117_(Tags.Items.STORAGE_BLOCKS);
            Item mainIngredientItem = mainIngredientStack.m_41720_();
            boolean inIsIngot = mainIngredientStack.m_204117_(Tags.Items.INGOTS);
            if (!outIsStorage && inIsIngot) continue;
            if (count == 4) {
                fourItemRecipeCache.put(mainIngredientItem, recipe);
                ingredientsInRecipeCache.put(recipe, 4);
                recipeValidCache.put(recipe, true);
                continue;
            }
            if (count == 9) {
                nineItemRecipeCache.put(mainIngredientItem, recipe);
                ingredientsInRecipeCache.put(recipe, 9);
                recipeValidCache.put(recipe, true);
                continue;
            }
            recipeValidCache.put(recipe, false);
        }
    }
}

