/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.harvester;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.harvester.ContainerHarvester;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.HarvestUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class TileHarvester
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int MAX_SIZE = 12;
    static final int MAX_ENERGY = 640000;
    static final int MAX_HEIGHT = 16;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int radius = 12;
    private int shapeIndex = 0;
    private int height = 1;
    private boolean directionIsUp = false;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileHarvester(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.HARVESTER.get(), pos, state);
        this.timer = 1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileHarvester e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileHarvester e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos targetPos = this.getShapeTarget();
        ++this.shapeIndex;
        if (targetPos != null && HarvestUtil.tryHarvestSingle(this.f_58857_, targetPos)) {
            this.energy.extractEnergy(cost, false);
        }
    }

    private BlockPos getShapeTarget() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return null;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        return shape.get(this.shapeIndex);
    }

    public List<BlockPos> getShape() {
        int diff;
        List<BlockPos> shape = ShapeUtil.cubeSquareBase(this.getCurrentFacingPos(this.radius + 1), this.radius, 0);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (this.height > 0) {
            shape = ShapeUtil.repeatShapeByHeight(shape, diff * this.height);
        }
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        int diff;
        List<BlockPos> shape = ShapeUtil.squareHorizontalHollow(this.getCurrentFacingPos(this.radius + 1), this.radius);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (this.height > 0) {
            shape = ShapeUtil.repeatShapeByHeight(shape, diff * this.height);
        }
        return shape;
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
            case HEIGHT: {
                return this.height;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 16);
            }
        }
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.radius = tag.m_128451_("radius");
        this.height = tag.m_128451_("height");
        this.directionIsUp = tag.m_128471_("directionIsUp");
        this.shapeIndex = tag.m_128451_("shapeIndex");
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("shapeIndex", this.shapeIndex);
        tag.m_128405_("height", this.height);
        tag.m_128379_("directionIsUp", this.directionIsUp);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        super.m_183515_(tag);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.HARVESTER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerHarvester(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

